/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.service;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataBroker;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataTransaction;
import org.opendaylight.controller.md.sal.common.impl.service.DataChangeListenerRegistration;
import org.opendaylight.controller.md.sal.common.impl.service.ListenerStateCapture;
import org.opendaylight.controller.md.sal.common.impl.service.RootedChangeSet;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TwoPhaseCommit<P extends Path<P>, D, DCL extends DataChangeListener<P, D>>
implements Callable<RpcResult<TransactionStatus>> {
    private static final Logger log = LoggerFactory.getLogger(TwoPhaseCommit.class);
    private final AbstractDataTransaction<P, D> transaction;
    private final AbstractDataBroker<P, D, DCL> dataBroker;

    public TwoPhaseCommit(AbstractDataTransaction<P, D> transaction, AbstractDataBroker<P, D, DCL> broker) {
        this.transaction = transaction;
        this.dataBroker = broker;
    }

    @Override
    public RpcResult<TransactionStatus> call() throws Exception {
        Object transactionId = this.transaction.getIdentifier();
        ImmutableSet changedPaths = ImmutableSet.builder().addAll(this.transaction.getUpdatedConfigurationData().keySet()).addAll(this.transaction.getCreatedConfigurationData().keySet()).addAll(this.transaction.getRemovedConfigurationData()).addAll(this.transaction.getUpdatedOperationalData().keySet()).addAll(this.transaction.getCreatedOperationalData().keySet()).addAll(this.transaction.getRemovedOperationalData()).build();
        log.trace("Transaction: {} Affected Subtrees: {}", transactionId, (Object)changedPaths);
        if (changedPaths.isEmpty()) {
            this.dataBroker.getFinishedTransactionsCount().getAndIncrement();
            this.transaction.succeeded();
            log.trace("Transaction: {} Finished successfully (no effects).", transactionId);
            return RpcResultBuilder.success((Object)TransactionStatus.COMMITED).build();
        }
        ImmutableList.Builder listenersBuilder = ImmutableList.builder();
        listenersBuilder.addAll(this.dataBroker.affectedListeners((Set<P>)changedPaths));
        this.filterProbablyAffectedListeners(this.dataBroker.probablyAffectedListeners((Set<P>)changedPaths), listenersBuilder);
        ImmutableList listeners = listenersBuilder.build();
        ImmutableList<DataCommitHandler<P, D>> commitHandlers = this.dataBroker.affectedCommitHandlers((Set<P>)changedPaths);
        this.captureInitialState(listeners);
        log.trace("Transaction: {} Starting Request Commit.", transactionId);
        ArrayList<DataCommitHandler.DataCommitTransaction<P, D>> handlerTransactions = new ArrayList<DataCommitHandler.DataCommitTransaction<P, D>>();
        try {
            for (DataCommitHandler handler : commitHandlers) {
                DataCommitHandler.DataCommitTransaction requestCommit = handler.requestCommit(this.transaction);
                if (requestCommit != null) {
                    handlerTransactions.add(requestCommit);
                    continue;
                }
                log.debug("Transaction: {}, Handler {}  is not participating in transaction.", transactionId, (Object)handler);
            }
        }
        catch (Exception e) {
            log.error("Transaction: {} Request Commit failed", transactionId, (Object)e);
            this.dataBroker.getFailedTransactionsCount().getAndIncrement();
            this.transaction.failed();
            return this.rollback(handlerTransactions, e);
        }
        log.trace("Transaction: {} Starting Finish.", transactionId);
        ArrayList<RpcResult> results = new ArrayList<RpcResult>();
        try {
            for (DataCommitHandler.DataCommitTransaction subtransaction : handlerTransactions) {
                results.add(subtransaction.finish());
            }
        }
        catch (Exception e) {
            log.error("Transaction: {} Finish Commit failed", transactionId, (Object)e);
            this.dataBroker.getFailedTransactionsCount().getAndIncrement();
            this.transaction.failed();
            return this.rollback(handlerTransactions, e);
        }
        this.dataBroker.getFinishedTransactionsCount().getAndIncrement();
        this.transaction.succeeded();
        log.trace("Transaction: {} Finished successfully.", transactionId);
        this.captureFinalState(listeners);
        log.trace("Transaction: {} Notifying listeners.", transactionId);
        this.publishDataChangeEvent(listeners);
        return RpcResultBuilder.success((Object)TransactionStatus.COMMITED).build();
    }

    private void captureInitialState(ImmutableList<ListenerStateCapture<P, D, DCL>> listeners) {
        for (ListenerStateCapture state : listeners) {
            state.setInitialConfigurationState(this.dataBroker.readConfigurationData(state.getPath()));
            state.setInitialOperationalState(this.dataBroker.readOperationalData(state.getPath()));
        }
    }

    private void captureFinalState(ImmutableList<ListenerStateCapture<P, D, DCL>> listeners) {
        for (ListenerStateCapture state : listeners) {
            state.setFinalConfigurationState(this.dataBroker.readConfigurationData(state.getPath()));
            state.setFinalOperationalState(this.dataBroker.readOperationalData(state.getPath()));
        }
    }

    private void filterProbablyAffectedListeners(ImmutableList<ListenerStateCapture<P, D, DCL>> probablyAffectedListeners, ImmutableList.Builder<ListenerStateCapture<P, D, DCL>> reallyAffected) {
        for (ListenerStateCapture listenerSet : probablyAffectedListeners) {
            Object affectedPath = listenerSet.getPath();
            Optional configChange = this.resolveConfigChange(affectedPath);
            Optional operChange = this.resolveOperChange(affectedPath);
            if (!configChange.isPresent() && !operChange.isPresent()) continue;
            reallyAffected.add((Object)listenerSet);
            if (configChange.isPresent()) {
                listenerSet.setNormalizedConfigurationChanges((RootedChangeSet)configChange.get());
            }
            if (!operChange.isPresent()) continue;
            listenerSet.setNormalizedOperationalChanges((RootedChangeSet)operChange.get());
        }
    }

    private Optional<RootedChangeSet<P, D>> resolveOperChange(P affectedPath) {
        Map<P, D> originalOper = this.dataBroker.deepGetBySubpath(this.transaction.getOriginalOperationalData(), affectedPath);
        Map<P, D> createdOper = this.dataBroker.deepGetBySubpath(this.transaction.getCreatedOperationalData(), affectedPath);
        Map<P, D> updatedOper = this.dataBroker.deepGetBySubpath(this.transaction.getUpdatedOperationalData(), affectedPath);
        Set removedOper = Sets.filter(this.transaction.getRemovedOperationalData(), this.dataBroker.createIsContainedPredicate(affectedPath));
        return this.resolveChanges(affectedPath, originalOper, createdOper, updatedOper, removedOper);
    }

    private Optional<RootedChangeSet<P, D>> resolveConfigChange(P affectedPath) {
        Map<P, D> originalConfig = this.dataBroker.deepGetBySubpath(this.transaction.getOriginalConfigurationData(), affectedPath);
        Map<P, D> createdConfig = this.dataBroker.deepGetBySubpath(this.transaction.getCreatedConfigurationData(), affectedPath);
        Map<P, D> updatedConfig = this.dataBroker.deepGetBySubpath(this.transaction.getUpdatedConfigurationData(), affectedPath);
        Set removedConfig = Sets.filter(this.transaction.getRemovedConfigurationData(), this.dataBroker.createIsContainedPredicate(affectedPath));
        return this.resolveChanges(affectedPath, originalConfig, createdConfig, updatedConfig, removedConfig);
    }

    private Optional<RootedChangeSet<P, D>> resolveChanges(P affectedPath, Map<P, D> originalConfig, Map<P, D> createdConfig, Map<P, D> updatedConfig, Set<P> potentialDeletions) {
        Predicate<P> isContained = this.dataBroker.createIsContainedPredicate(affectedPath);
        if (createdConfig.isEmpty() && updatedConfig.isEmpty() && potentialDeletions.isEmpty()) {
            return Optional.absent();
        }
        RootedChangeSet<P, D> changeSet = new RootedChangeSet<P, D>(affectedPath, originalConfig);
        changeSet.addCreated(createdConfig);
        for (Map.Entry<P, D> entry : updatedConfig.entrySet()) {
            if (originalConfig.containsKey(entry.getKey())) {
                changeSet.addUpdated(entry);
                continue;
            }
            changeSet.addCreated(entry);
        }
        for (Map.Entry<P, D> entry : originalConfig.entrySet()) {
            for (Path deletion : potentialDeletions) {
                if (!isContained.apply((Object)deletion)) continue;
                changeSet.addRemoval((Path)entry.getKey());
            }
        }
        if (changeSet.isChange()) {
            return Optional.of(changeSet);
        }
        return Optional.absent();
    }

    public void publishDataChangeEvent(final ImmutableList<ListenerStateCapture<P, D, DCL>> listeners) {
        ExecutorService executor = this.dataBroker.getExecutor();
        Runnable notifyTask = new Runnable(){

            @Override
            public void run() {
                for (ListenerStateCapture listenerSet : listeners) {
                    DataChangeEvent changeEvent = listenerSet.createEvent(TwoPhaseCommit.this.transaction);
                    for (DataChangeListenerRegistration listener : listenerSet.getListeners()) {
                        try {
                            ((DataChangeListener)listener.getInstance()).onDataChanged(changeEvent);
                        }
                        catch (Exception e) {
                            log.error("Unhandled exception when invoking listener {}", listener, (Object)e);
                        }
                    }
                }
            }
        };
        executor.submit(notifyTask);
    }

    public RpcResult<TransactionStatus> rollback(List<DataCommitHandler.DataCommitTransaction<P, D>> transactions, Exception e) {
        for (DataCommitHandler.DataCommitTransaction<P, D> transaction : transactions) {
            transaction.rollback();
        }
        return RpcResultBuilder.failed().withResult((Object)TransactionStatus.FAILED).build();
    }
}

