/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Path;

public class RootedChangeSet<P extends Path<P>, D> {
    private final P root;
    private final Map<P, D> original;
    private final Map<P, D> created = new HashMap<P, D>();
    private final Map<P, D> updated = new HashMap<P, D>();
    private final Set<P> removed = new HashSet<P>();

    public RootedChangeSet(P root, Map<P, D> original) {
        this.root = root;
        this.original = original;
    }

    protected P getRoot() {
        return this.root;
    }

    protected Map<P, D> getOriginal() {
        return this.original;
    }

    protected Map<P, D> getCreated() {
        return this.created;
    }

    protected Map<P, D> getUpdated() {
        return this.updated;
    }

    protected Set<P> getRemoved() {
        return this.removed;
    }

    public void addCreated(Map<P, D> created) {
        this.created.putAll(created);
    }

    public void addCreated(Map.Entry<P, D> entry) {
        this.created.put(entry.getKey(), entry.getValue());
    }

    public void addUpdated(Map.Entry<P, D> entry) {
        this.updated.put(entry.getKey(), entry.getValue());
    }

    public void addRemoval(P path) {
        this.removed.add(path);
    }

    public boolean isChange() {
        return !this.created.isEmpty() || !this.updated.isEmpty() || !this.removed.isEmpty();
    }
}

