/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.service;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.md.sal.common.impl.service.RootedChangeSet;
import org.opendaylight.yangtools.concepts.Path;

@Deprecated
public final class ImmutableDataChangeEvent<P extends Path<P>, D>
implements DataChangeEvent<P, D> {
    private final D updatedOperationalSubtree;
    private final Map<P, D> updatedOperational;
    private final D updatedConfigurationSubtree;
    private final Map<P, D> updatedConfiguration;
    private final Set<P> removedOperational;
    private final Set<P> removedConfiguration;
    private final D originalOperationalSubtree;
    private final Map<P, D> originalOperational;
    private final D originalConfigurationSubtree;
    private final Map<P, D> originalConfiguration;
    private final Map<P, D> createdOperational;
    private final Map<P, D> createdConfiguration;

    private ImmutableDataChangeEvent(Builder<P, D> builder) {
        this.createdConfiguration = builder.getCreatedConfiguration().build();
        this.createdOperational = builder.getCreatedOperational().build();
        this.originalConfiguration = builder.getOriginalConfiguration().build();
        this.originalConfigurationSubtree = builder.getOriginalConfigurationSubtree();
        this.originalOperational = builder.getOriginalOperational().build();
        this.originalOperationalSubtree = builder.getOriginalOperationalSubtree();
        this.removedConfiguration = builder.getRemovedConfiguration().build();
        this.removedOperational = builder.getRemovedOperational().build();
        this.updatedConfiguration = builder.getUpdatedConfiguration().build();
        this.updatedConfigurationSubtree = builder.getUpdatedConfigurationSubtree();
        this.updatedOperational = builder.getUpdatedOperational().build();
        this.updatedOperationalSubtree = builder.getUpdatedOperationalSubtree();
    }

    public Map<P, D> getCreatedConfigurationData() {
        return this.createdConfiguration;
    }

    public Map<P, D> getCreatedOperationalData() {
        return this.createdOperational;
    }

    public Map<P, D> getOriginalConfigurationData() {
        return this.originalConfiguration;
    }

    public D getOriginalConfigurationSubtree() {
        return this.originalConfigurationSubtree;
    }

    public Map<P, D> getOriginalOperationalData() {
        return this.originalOperational;
    }

    public D getOriginalOperationalSubtree() {
        return this.originalOperationalSubtree;
    }

    public Set<P> getRemovedConfigurationData() {
        return this.removedConfiguration;
    }

    public Set<P> getRemovedOperationalData() {
        return this.removedOperational;
    }

    public Map<P, D> getUpdatedConfigurationData() {
        return this.updatedConfiguration;
    }

    public D getUpdatedConfigurationSubtree() {
        return this.updatedConfigurationSubtree;
    }

    public Map<P, D> getUpdatedOperationalData() {
        return this.updatedOperational;
    }

    public D getUpdatedOperationalSubtree() {
        return this.updatedOperationalSubtree;
    }

    public static final <P extends Path<P>, D> Builder<P, D> builder() {
        return new Builder();
    }

    public static final class Builder<P extends Path<P>, D> {
        private D updatedOperationalSubtree;
        private D originalOperationalSubtree;
        private D originalConfigurationSubtree;
        private D updatedConfigurationSubtree;
        private final ImmutableMap.Builder<P, D> updatedOperational = ImmutableMap.builder();
        private final ImmutableMap.Builder<P, D> updatedConfiguration = ImmutableMap.builder();
        private final ImmutableSet.Builder<P> removedOperational = ImmutableSet.builder();
        private final ImmutableSet.Builder<P> removedConfiguration = ImmutableSet.builder();
        private final ImmutableMap.Builder<P, D> originalOperational = ImmutableMap.builder();
        private final ImmutableMap.Builder<P, D> originalConfiguration = ImmutableMap.builder();
        private final ImmutableMap.Builder<P, D> createdOperational = ImmutableMap.builder();
        private final ImmutableMap.Builder<P, D> createdConfiguration = ImmutableMap.builder();

        protected Builder<P, D> addTransaction(DataModification<P, D> data, Predicate<P> keyFilter) {
            this.updatedOperational.putAll(Maps.filterKeys((Map)data.getUpdatedOperationalData(), keyFilter));
            this.updatedConfiguration.putAll(Maps.filterKeys((Map)data.getUpdatedConfigurationData(), keyFilter));
            this.originalConfiguration.putAll(Maps.filterKeys((Map)data.getOriginalConfigurationData(), keyFilter));
            this.originalOperational.putAll(Maps.filterKeys((Map)data.getOriginalOperationalData(), keyFilter));
            this.createdOperational.putAll(Maps.filterKeys((Map)data.getCreatedOperationalData(), keyFilter));
            this.createdConfiguration.putAll(Maps.filterKeys((Map)data.getCreatedConfigurationData(), keyFilter));
            this.removedOperational.addAll((Iterable)Sets.filter((Set)data.getRemovedOperationalData(), keyFilter));
            this.removedConfiguration.addAll((Iterable)Sets.filter((Set)data.getRemovedConfigurationData(), keyFilter));
            return this;
        }

        protected Builder<P, D> addConfigurationChangeSet(RootedChangeSet<P, D> changeSet) {
            if (changeSet == null) {
                return this;
            }
            this.originalConfiguration.putAll(changeSet.getOriginal());
            this.createdConfiguration.putAll(changeSet.getCreated());
            this.updatedConfiguration.putAll(changeSet.getUpdated());
            this.removedConfiguration.addAll(changeSet.getRemoved());
            return this;
        }

        protected Builder<P, D> addOperationalChangeSet(RootedChangeSet<P, D> changeSet) {
            if (changeSet == null) {
                return this;
            }
            this.originalOperational.putAll(changeSet.getOriginal());
            this.createdOperational.putAll(changeSet.getCreated());
            this.updatedOperational.putAll(changeSet.getUpdated());
            this.removedOperational.addAll(changeSet.getRemoved());
            return this;
        }

        public ImmutableDataChangeEvent<P, D> build() {
            return new ImmutableDataChangeEvent(this);
        }

        protected D getUpdatedOperationalSubtree() {
            return this.updatedOperationalSubtree;
        }

        public Builder<P, D> setUpdatedOperationalSubtree(D updatedOperationalSubtree) {
            this.updatedOperationalSubtree = updatedOperationalSubtree;
            return this;
        }

        protected D getOriginalOperationalSubtree() {
            return this.originalOperationalSubtree;
        }

        public Builder<P, D> setOriginalOperationalSubtree(D originalOperationalSubtree) {
            this.originalOperationalSubtree = originalOperationalSubtree;
            return this;
        }

        protected D getOriginalConfigurationSubtree() {
            return this.originalConfigurationSubtree;
        }

        public Builder<P, D> setOriginalConfigurationSubtree(D originalConfigurationSubtree) {
            this.originalConfigurationSubtree = originalConfigurationSubtree;
            return this;
        }

        protected D getUpdatedConfigurationSubtree() {
            return this.updatedConfigurationSubtree;
        }

        public Builder<P, D> setUpdatedConfigurationSubtree(D updatedConfigurationSubtree) {
            this.updatedConfigurationSubtree = updatedConfigurationSubtree;
            return this;
        }

        protected ImmutableMap.Builder<P, D> getUpdatedOperational() {
            return this.updatedOperational;
        }

        protected ImmutableMap.Builder<P, D> getUpdatedConfiguration() {
            return this.updatedConfiguration;
        }

        protected ImmutableSet.Builder<P> getRemovedOperational() {
            return this.removedOperational;
        }

        protected ImmutableSet.Builder<P> getRemovedConfiguration() {
            return this.removedConfiguration;
        }

        protected ImmutableMap.Builder<P, D> getOriginalOperational() {
            return this.originalOperational;
        }

        protected ImmutableMap.Builder<P, D> getOriginalConfiguration() {
            return this.originalConfiguration;
        }

        protected ImmutableMap.Builder<P, D> getCreatedOperational() {
            return this.createdOperational;
        }

        protected ImmutableMap.Builder<P, D> getCreatedConfiguration() {
            return this.createdConfiguration;
        }

        public Builder<P, D> putOriginalOperational(Map<? extends P, ? extends D> originalData) {
            this.originalOperational.putAll(originalData);
            return this;
        }

        public Builder<P, D> putCreatedOperational(Map<? extends P, ? extends D> originalData) {
            this.createdOperational.putAll(originalData);
            return this;
        }

        public Builder<P, D> putUpdatedOperational(Map<? extends P, ? extends D> originalData) {
            this.updatedOperational.putAll(originalData);
            return this;
        }

        public Builder<P, D> putRemovedOperational(Set<? extends P> originalData) {
            this.removedOperational.addAll(originalData);
            return this;
        }
    }
}

