/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.yangtools.concepts.Path;

@Deprecated
public abstract class AbstractDataModification<P extends Path<P>, D>
implements DataModification<P, D> {
    private final Map<P, D> operationalOriginal;
    private final Map<P, D> configurationOriginal;
    private final Map<P, D> operationalCreated;
    private final Map<P, D> configurationCreated;
    private final Map<P, D> configurationUpdate;
    private final Map<P, D> operationalUpdate;
    private final Map<P, P> configurationRemove;
    private final Map<P, P> operationalRemove;
    private final Map<P, D> unmodifiable_configurationOriginal;
    private final Map<P, D> unmodifiable_operationalOriginal;
    private final Map<P, D> unmodifiable_configurationCreated;
    private final Map<P, D> unmodifiable_operationalCreated;
    private final Map<P, D> unmodifiable_configurationUpdate;
    private final Map<P, D> unmodifiable_operationalUpdate;
    private final Set<P> unmodifiable_configurationRemove;
    private final Set<P> unmodifiable_OperationalRemove;
    private final DataReader<P, D> reader;

    public AbstractDataModification(DataReader<P, D> reader) {
        this.reader = reader;
        this.configurationUpdate = new LinkedHashMap<P, D>();
        this.operationalUpdate = new LinkedHashMap<P, D>();
        this.configurationRemove = new LinkedHashMap<P, P>();
        this.operationalRemove = new LinkedHashMap<P, P>();
        this.configurationOriginal = new LinkedHashMap<P, D>();
        this.operationalOriginal = new LinkedHashMap<P, D>();
        this.configurationCreated = new LinkedHashMap<P, D>();
        this.operationalCreated = new LinkedHashMap<P, D>();
        this.unmodifiable_configurationOriginal = Collections.unmodifiableMap(this.configurationOriginal);
        this.unmodifiable_operationalOriginal = Collections.unmodifiableMap(this.operationalOriginal);
        this.unmodifiable_configurationCreated = Collections.unmodifiableMap(this.configurationCreated);
        this.unmodifiable_operationalCreated = Collections.unmodifiableMap(this.operationalCreated);
        this.unmodifiable_configurationUpdate = Collections.unmodifiableMap(this.configurationUpdate);
        this.unmodifiable_operationalUpdate = Collections.unmodifiableMap(this.operationalUpdate);
        this.unmodifiable_configurationRemove = Collections.unmodifiableSet(this.configurationRemove.keySet());
        this.unmodifiable_OperationalRemove = Collections.unmodifiableSet(this.operationalRemove.keySet());
    }

    public final void putConfigurationData(P path, D data) {
        this.checkMutable();
        D original = null;
        D d = this.getConfigurationOriginal(path);
        original = d;
        if (d == null) {
            this.configurationCreated.put(path, data);
        }
        this.configurationUpdate.put(path, this.mergeConfigurationData(path, original, data));
    }

    public final void putOperationalData(P path, D data) {
        this.checkMutable();
        D original = null;
        D d = this.getOperationalOriginal(path);
        original = d;
        if (d == null) {
            this.operationalCreated.put(path, data);
        }
        this.operationalUpdate.put(path, this.mergeOperationalData(path, original, data));
    }

    public final void removeOperationalData(P path) {
        this.checkMutable();
        this.getOperationalOriginal(path);
        this.operationalUpdate.remove(path);
        this.operationalRemove.put(path, path);
    }

    public final void removeConfigurationData(P path) {
        this.checkMutable();
        this.getConfigurationOriginal(path);
        this.configurationUpdate.remove(path);
        this.configurationRemove.put(path, path);
    }

    private final void checkMutable() {
        if (!TransactionStatus.NEW.equals((Object)this.getStatus())) {
            throw new IllegalStateException("Transaction was already submitted");
        }
    }

    public final Map<P, D> getUpdatedConfigurationData() {
        return this.unmodifiable_configurationUpdate;
    }

    public final Map<P, D> getUpdatedOperationalData() {
        return this.unmodifiable_operationalUpdate;
    }

    public final Set<P> getRemovedConfigurationData() {
        return this.unmodifiable_configurationRemove;
    }

    public final Set<P> getRemovedOperationalData() {
        return this.unmodifiable_OperationalRemove;
    }

    public Map<P, D> getCreatedConfigurationData() {
        return this.unmodifiable_configurationCreated;
    }

    public Map<P, D> getCreatedOperationalData() {
        return this.unmodifiable_operationalCreated;
    }

    public Map<P, D> getOriginalConfigurationData() {
        return this.unmodifiable_configurationOriginal;
    }

    public Map<P, D> getOriginalOperationalData() {
        return this.unmodifiable_operationalOriginal;
    }

    public D readOperationalData(P path) {
        return (D)this.reader.readOperationalData(path);
    }

    public D readConfigurationData(P path) {
        return (D)this.reader.readConfigurationData(path);
    }

    private D getConfigurationOriginal(P path) {
        Object data = this.configurationOriginal.get(path);
        if (data != null) {
            return data;
        }
        data = this.reader.readConfigurationData(path);
        if (data != null) {
            this.configurationOriginal.put(path, data);
            return data;
        }
        return null;
    }

    private D getOperationalOriginal(P path) {
        Object data = this.operationalOriginal.get(path);
        if (data != null) {
            return data;
        }
        data = this.reader.readOperationalData(path);
        if (data != null) {
            this.operationalOriginal.put(path, data);
            return data;
        }
        return null;
    }

    protected D mergeOperationalData(P path, D stored, D modified) {
        return modified;
    }

    protected D mergeConfigurationData(P path, D stored, D modified) {
        return modified;
    }
}

