/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.channel.util;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opendaylight.channel.util.ChannelDBContext;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.AddChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.DeployChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.ModifyChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.QueryChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.RemoveChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.deploy.channel.input.EgressNode;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.BierForwardingType;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.BierNetworkChannel;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.BierNetworkChannelBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.BpAssignmentStrategy;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.Channel;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.BierChannel;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.BierChannelKey;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.ChannelBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.ChannelKey;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.EgressNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.egress.node.RcvTp;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.egress.node.RcvTpBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.DomainId;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.BierNetworkTopology;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.network.topology.BierTopology;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.network.topology.BierTopologyKey;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.network.topology.bier.topology.BierNode;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.network.topology.bier.topology.BierNodeKey;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.node.BierNodeParams;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.node.BierTeNodeParams;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.node.params.Domain;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.node.params.DomainKey;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.te.node.params.TeDomain;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.te.node.params.TeDomainKey;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.te.node.params.te.domain.TeSubDomain;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.te.node.params.te.domain.TeSubDomainKey;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.te.node.params.te.domain.te.sub.domain.TeBsl;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.te.node.params.te.domain.te.sub.domain.te.bsl.TeSi;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.te.node.params.te.domain.te.sub.domain.te.bsl.te.si.TeBp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BfrId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.SubDomainId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.global.cfg.BierGlobal;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.global.cfg.bier.global.SubDomain;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.global.cfg.bier.global.SubDomainKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelDBUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelDBUtil.class);
    private ChannelDBContext context;
    private static ChannelDBUtil instance = new ChannelDBUtil();
    public static final String DEFAULT_TOPO_ID = "example-linkstate-topology";

    ChannelDBUtil() {
    }

    public void setContext(ChannelDBContext context) {
        this.context = context;
    }

    public static ChannelDBUtil getInstance() {
        return instance;
    }

    public boolean isChannelExists(String name, String topologyId) {
        Optional<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> channel = this.readChannel(name, this.buildTopoId(topologyId));
        return channel != null && channel.isPresent();
    }

    public Optional<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> readChannel(String name, String topologyId) {
        ReadOnlyTransaction rtx = this.context.newReadOnlyTransaction();
        try {
            return (Optional)rtx.read(LogicalDatastoreType.CONFIGURATION, this.buildChannelPath(name, this.buildTopoId(topologyId))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Channel:occur exception when read databroker {}", (Throwable)e);
            return null;
        }
    }

    public org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel getChannelInfo(String topologyId, String channelName) {
        Optional<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> channel = this.readChannel(channelName, topologyId);
        if (channel == null || !channel.isPresent()) {
            return null;
        }
        return (org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel)channel.get();
    }

    public Optional<BierChannel> readBierChannel(String topologyId) {
        ReadOnlyTransaction rtx = this.context.newReadOnlyTransaction();
        try {
            return (Optional)rtx.read(LogicalDatastoreType.CONFIGURATION, this.buildBierChannelPath(topologyId)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Channel:occur exception when read databroker {}", (Throwable)e);
            return null;
        }
    }

    private Optional<BierNetworkChannel> readBierNetworkChannel() {
        ReadOnlyTransaction rtx = this.context.newReadOnlyTransaction();
        try {
            return (Optional)rtx.read(LogicalDatastoreType.CONFIGURATION, this.buildBierNetworkChannelPath()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Channel:occur exception when read databroker {}", (Throwable)e);
            return null;
        }
    }

    private Optional<SubDomain> readBierNodeSubDomain(String topologyId, String node, DomainId domainId, SubDomainId subDomainId) {
        ReadOnlyTransaction rtx = this.context.newReadOnlyTransaction();
        try {
            return (Optional)rtx.read(LogicalDatastoreType.CONFIGURATION, this.buildBierNodeSubDomainPath(topologyId, node, domainId, subDomainId)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Channel:occur exception when read databroker {}", (Throwable)e);
            return null;
        }
    }

    private Optional<TeSubDomain> readBierTeNodeSubDomain(String topologyId, String node, DomainId domainId, SubDomainId subDomainId) {
        ReadOnlyTransaction rtx = this.context.newReadOnlyTransaction();
        try {
            return (Optional)rtx.read(LogicalDatastoreType.CONFIGURATION, this.buildBierTeNodeSubDomainPath(topologyId, node, domainId, subDomainId)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Channel:occur exception when read databroker {}", (Throwable)e);
            return null;
        }
    }

    private InstanceIdentifier<SubDomain> buildBierNodeSubDomainPath(String topologyId, String node, DomainId domainId, SubDomainId subDomainId) {
        return InstanceIdentifier.create(BierNetworkTopology.class).child(BierTopology.class, (Identifier)new BierTopologyKey(topologyId)).child(BierNode.class, (Identifier)new BierNodeKey(node)).child(BierNodeParams.class).child(Domain.class, (Identifier)new DomainKey(domainId)).child(BierGlobal.class).child(SubDomain.class, (Identifier)new SubDomainKey(subDomainId));
    }

    private InstanceIdentifier<TeSubDomain> buildBierTeNodeSubDomainPath(String topologyId, String node, DomainId domainId, SubDomainId subDomainId) {
        return InstanceIdentifier.create(BierNetworkTopology.class).child(BierTopology.class, (Identifier)new BierTopologyKey(topologyId)).child(BierNode.class, (Identifier)new BierNodeKey(node)).child(BierTeNodeParams.class).child(TeDomain.class, (Identifier)new TeDomainKey(domainId)).child(TeSubDomain.class, (Identifier)new TeSubDomainKey(subDomainId));
    }

    private InstanceIdentifier<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> buildChannelPath(String name, String topologyId) {
        return InstanceIdentifier.create(BierNetworkChannel.class).child(BierChannel.class, (Identifier)new BierChannelKey(topologyId)).child(org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel.class, (Identifier)new ChannelKey(name));
    }

    private InstanceIdentifier<BierNetworkChannel> buildBierNetworkChannelPath() {
        return InstanceIdentifier.create(BierNetworkChannel.class);
    }

    public boolean writeChannelToDB(AddChannelInput input) {
        WriteTransaction wtx = this.context.newWriteOnlyTransaction();
        org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channel = new ChannelBuilder((Channel)input).build();
        wtx.put(LogicalDatastoreType.CONFIGURATION, this.buildChannelPath(input.getName(), this.buildTopoId(input.getTopologyId())), (DataObject)channel, true);
        return this.submitTransaction(wtx);
    }

    public boolean writeDeployChannelToDB(DeployChannelInput input) {
        WriteTransaction wtx = this.context.newWriteOnlyTransaction();
        org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel oldChannel = this.getChannelInfo(input.getTopologyId(), input.getChannelName());
        org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channelInfo = this.buildDeployChannelInfo(input, oldChannel);
        wtx.put(LogicalDatastoreType.CONFIGURATION, this.buildChannelPath(input.getChannelName(), this.buildTopoId(input.getTopologyId())), (DataObject)channelInfo);
        return this.submitTransaction(wtx);
    }

    private org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel buildDeployChannelInfo(DeployChannelInput input, org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channel) {
        ArrayList<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.EgressNode> egressNodeList = new ArrayList<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.EgressNode>();
        for (EgressNode egressNode : input.getEgressNode()) {
            ArrayList<RcvTp> rcvTpList = new ArrayList<RcvTp>();
            if (egressNode.getRcvTp() != null) {
                for (org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.deploy.channel.input.egress.node.RcvTp rcvTp : egressNode.getRcvTp()) {
                    rcvTpList.add(new RcvTpBuilder().setTp(rcvTp.getTp()).build());
                }
            }
            egressNodeList.add(new EgressNodeBuilder().setNodeId(egressNode.getNodeId()).setEgressBfrId(this.getNodeBfrId(input.getTopologyId(), egressNode.getNodeId(), channel.getDomainId(), channel.getSubDomainId())).setRcvTp(rcvTpList.isEmpty() ? null : rcvTpList).build());
        }
        return new ChannelBuilder(channel).setBierForwardingType(input.getBierForwardingType()).setBpAssignmentStrategy(this.getStrategy(channel.getBpAssignmentStrategy(), input.getBpAssignmentStrategy())).setIngressNode(input.getIngressNode()).setIngressBfrId(this.getNodeBfrId(input.getTopologyId(), input.getIngressNode(), channel.getDomainId(), channel.getSubDomainId())).setSrcTp(input.getSrcTp()).setEgressNode(egressNodeList).build();
    }

    private BpAssignmentStrategy getStrategy(BpAssignmentStrategy oldStrategy, BpAssignmentStrategy newStrategy) {
        if (oldStrategy == null && newStrategy == null) {
            return BpAssignmentStrategy.Automatic;
        }
        if (oldStrategy != null && newStrategy == null) {
            return oldStrategy;
        }
        if (oldStrategy == null && newStrategy != null) {
            return newStrategy;
        }
        return newStrategy;
    }

    private BfrId getNodeBfrId(String topologyId, String nodeId, DomainId domainId, SubDomainId subDomainId) {
        BierGlobal bierGlobal = this.readBierGlobal(this.buildTopoId(topologyId), nodeId, domainId);
        if (bierGlobal != null) {
            BfrId globalBfrId = bierGlobal.getBfrId();
            if (bierGlobal.getSubDomain() != null) {
                for (SubDomain subDomain : bierGlobal.getSubDomain()) {
                    if (!subDomain.getSubDomainId().equals((Object)subDomainId) || subDomain.getBfrId() == null || subDomain.getBfrId().getValue() == 0) continue;
                    return subDomain.getBfrId();
                }
            }
            return globalBfrId;
        }
        return null;
    }

    private BierGlobal readBierGlobal(String topologyId, String nodeId, DomainId domainId) {
        ReadOnlyTransaction rtx = this.context.newReadOnlyTransaction();
        try {
            Optional optional = (Optional)rtx.read(LogicalDatastoreType.CONFIGURATION, this.buildBierGlobalPath(topologyId, nodeId, domainId)).checkedGet();
            if (optional.isPresent()) {
                return (BierGlobal)optional.get();
            }
            return null;
        }
        catch (IllegalStateException | ReadFailedException e) {
            LOG.warn("Channel:occur exception when read databroker {}", e);
            return null;
        }
    }

    private InstanceIdentifier<BierGlobal> buildBierGlobalPath(String topologyId, String nodeId, DomainId domainId) {
        return InstanceIdentifier.create(BierNetworkTopology.class).child(BierTopology.class, (Identifier)new BierTopologyKey(topologyId)).child(BierNode.class, (Identifier)new BierNodeKey(nodeId)).child(BierNodeParams.class).child(Domain.class, (Identifier)new DomainKey(domainId)).child(BierGlobal.class);
    }

    private InstanceIdentifier<BierChannel> buildBierChannelPath(String topologyId) {
        return InstanceIdentifier.create(BierNetworkChannel.class).child(BierChannel.class, (Identifier)new BierChannelKey(topologyId));
    }

    private boolean submitTransaction(WriteTransaction writeTransaction) {
        try {
            writeTransaction.submit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Channel:write DB fail!", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean deleteChannelFromDB(RemoveChannelInput input) {
        if (!this.isChannelExists(input.getChannelName(), input.getTopologyId())) {
            return true;
        }
        WriteTransaction wtx = this.context.newWriteOnlyTransaction();
        wtx.delete(LogicalDatastoreType.CONFIGURATION, this.buildChannelPath(input.getChannelName(), this.buildTopoId(input.getTopologyId())));
        return this.submitTransaction(wtx);
    }

    public boolean modifyChannelToDB(ModifyChannelInput input) {
        org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel odlChannel = (org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel)this.readChannel(input.getName(), this.buildTopoId(input.getTopologyId())).get();
        ChannelBuilder channelBuilder = new ChannelBuilder(odlChannel);
        if (input.getDomainId() != null) {
            channelBuilder.setDomainId(input.getDomainId());
        }
        if (input.getSubDomainId() != null) {
            channelBuilder.setSubDomainId(input.getSubDomainId());
        }
        if (input.getSrcIp() != null) {
            channelBuilder.setSrcIp(input.getSrcIp());
        }
        if (input.getDstGroup() != null) {
            channelBuilder.setDstGroup(input.getDstGroup());
        }
        if (input.getSourceWildcard() != null) {
            channelBuilder.setSourceWildcard(input.getSourceWildcard());
        }
        if (input.getGroupWildcard() != null) {
            channelBuilder.setGroupWildcard(input.getGroupWildcard());
        }
        WriteTransaction wtx = this.context.newWriteOnlyTransaction();
        wtx.merge(LogicalDatastoreType.CONFIGURATION, this.buildChannelPath(input.getName(), this.buildTopoId(input.getTopologyId())), (DataObject)channelBuilder.build(), true);
        return this.submitTransaction(wtx);
    }

    public List<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> queryChannels(QueryChannelInput input) {
        ArrayList<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> channels = new ArrayList<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel>();
        for (String channelName : input.getChannelName()) {
            Optional<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> channel = this.readChannel(channelName, this.buildTopoId(input.getTopologyId()));
            if (channel == null || !channel.isPresent()) continue;
            channels.add((org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel)channel.get());
        }
        return channels;
    }

    public List<String> getChannels(String topoId) {
        ArrayList<String> channelNames = new ArrayList<String>();
        Optional<BierChannel> bierChannel = this.readBierChannel(this.buildTopoId(topoId));
        if (bierChannel != null && bierChannel.isPresent()) {
            for (org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel channel : ((BierChannel)bierChannel.get()).getChannel()) {
                channelNames.add(channel.getName());
            }
        }
        return channelNames;
    }

    private String buildTopoId(String topoId) {
        return topoId != null ? topoId : DEFAULT_TOPO_ID;
    }

    public void initDB() {
        WriteTransaction wtx = this.context.newWriteOnlyTransaction();
        Optional<BierNetworkChannel> bierChannels = this.readBierNetworkChannel();
        if (bierChannels == null || !bierChannels.isPresent()) {
            wtx.put(LogicalDatastoreType.CONFIGURATION, this.buildBierNetworkChannelPath(), (DataObject)new BierNetworkChannelBuilder().build());
        }
        this.submitTransaction(wtx);
    }

    public boolean hasChannelDeplyed(String name, String topologyId) {
        Optional<org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel> channel = this.readChannel(name, this.buildTopoId(topologyId));
        return channel != null && channel.isPresent() && ((org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel)channel.get()).getIngressNode() != null;
    }

    public boolean isBierNodeInSubDomain(String topologyId, String node, DomainId domainId, SubDomainId subDomainId, BierForwardingType type) {
        Optional<TeSubDomain> bierTeNodeSubDomain;
        Optional<SubDomain> bierNodeSubDomain;
        if (type.equals((Object)BierForwardingType.Bier) && ((bierNodeSubDomain = this.readBierNodeSubDomain(this.buildTopoId(topologyId), node, domainId, subDomainId)) == null || !bierNodeSubDomain.isPresent())) {
            return false;
        }
        return !type.equals((Object)BierForwardingType.BierTe) || (bierTeNodeSubDomain = this.readBierTeNodeSubDomain(this.buildTopoId(topologyId), node, domainId, subDomainId)) != null && bierTeNodeSubDomain.isPresent();
    }

    public boolean isTpInTeSubdomain(String topologyId, String node, DomainId domainId, SubDomainId subDomainId, String tpId) {
        Optional<TeSubDomain> bierTeNodeSubDomain = this.readBierTeNodeSubDomain(this.buildTopoId(topologyId), node, domainId, subDomainId);
        if (bierTeNodeSubDomain != null && bierTeNodeSubDomain.isPresent()) {
            for (TeBsl teBsl : ((TeSubDomain)bierTeNodeSubDomain.get()).getTeBsl()) {
                for (TeSi teSi : teBsl.getTeSi()) {
                    for (TeBp teBp : teSi.getTeBp()) {
                        if (!teBp.getTpId().equals(tpId)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

