/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.channel.check;

import com.google.common.base.Preconditions;
import org.opendaylight.channel.check.ChannelInputCheck;
import org.opendaylight.channel.check.CheckResult;
import org.opendaylight.yang.gen.v1.urn.bier.channel.api.rev161102.AddChannelInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddChannelInputCheck
extends ChannelInputCheck {
    private AddChannelInput addChannelInput;
    private static final Logger LOG = LoggerFactory.getLogger(AddChannelInputCheck.class);

    public AddChannelInputCheck(AddChannelInput input) {
        this.addChannelInput = input;
    }

    @Override
    public CheckResult check() {
        CheckResult result = this.checkParam();
        if (result.isInputIllegal()) {
            return result;
        }
        if (this.checkChannelExist(this.addChannelInput.getName(), this.addChannelInput.getTopologyId())) {
            return new CheckResult(true, "The Channel already exists!");
        }
        return new CheckResult(false, "");
    }

    private CheckResult checkParam() {
        CheckResult result = this.checkInputNull(this.addChannelInput);
        if (result.isInputIllegal()) {
            return result;
        }
        return this.paramValidity(this.addChannelInput);
    }

    private CheckResult paramValidity(AddChannelInput input) {
        CheckResult result = this.checkIpRange("src-ip", input.getSrcIp(), false);
        if (result.isInputIllegal()) {
            return result;
        }
        result = this.checkIpRange("dest-group", input.getDstGroup(), true);
        if (result.isInputIllegal()) {
            return result;
        }
        return this.checkWildCard(input.getGroupWildcard(), input.getSourceWildcard());
    }

    private CheckResult checkInputNull(AddChannelInput input) {
        try {
            Preconditions.checkNotNull((Object)input, (Object)"Input is null!");
            Preconditions.checkNotNull((Object)input.getName(), (Object)"channel-name is null!");
            Preconditions.checkNotNull((Object)input.getSrcIp(), (Object)"src-ip is null!");
            Preconditions.checkNotNull((Object)input.getDstGroup(), (Object)"dest-group is null!");
            Preconditions.checkNotNull((Object)input.getDomainId(), (Object)"domain-id is null!");
            Preconditions.checkNotNull((Object)input.getSubDomainId(), (Object)"sub-domain-id is null!");
            Preconditions.checkNotNull((Object)input.getSourceWildcard(), (Object)"src-wildcard is null!");
            Preconditions.checkNotNull((Object)input.getGroupWildcard(), (Object)"group-wildcard is null!");
        }
        catch (NullPointerException e) {
            LOG.warn("NullPointerException: {}", (Throwable)e);
            return new CheckResult(true, e.getMessage());
        }
        return new CheckResult(false, "");
    }
}

