/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.XROSubobjectHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.XROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.XROSubobjectSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleXROSubobjectHandlerRegistry
implements XROSubobjectHandlerRegistry {
    private final HandlerRegistry<DataContainer, XROSubobjectParser, XROSubobjectSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerSubobjectParser(int subobjectType, XROSubobjectParser parser) {
        Preconditions.checkArgument((subobjectType >= 0 && subobjectType <= 65535 ? 1 : 0) != 0);
        return this.handlers.registerParser(subobjectType, (Object)parser);
    }

    public AutoCloseable registerSubobjectSerializer(Class<? extends SubobjectType> subobjectClass, XROSubobjectSerializer serializer) {
        return this.handlers.registerSerializer(subobjectClass, (Object)serializer);
    }

    @Override
    public XROSubobjectParser getSubobjectParser(int subobjectType) {
        Preconditions.checkArgument((subobjectType >= 0 && subobjectType <= 65535 ? 1 : 0) != 0);
        return (XROSubobjectParser)this.handlers.getParser(subobjectType);
    }

    @Override
    public XROSubobjectSerializer getSubobjectSerializer(SubobjectType subobject) {
        return (XROSubobjectSerializer)this.handlers.getSerializer(subobject.getImplementedInterface());
    }
}

