/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.TlvHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleTlvHandlerRegistry
implements TlvHandlerRegistry {
    private final HandlerRegistry<DataContainer, TlvParser, TlvSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerTlvParser(int tlvType, TlvParser parser) {
        Preconditions.checkArgument((tlvType >= 0 && tlvType < 65535 ? 1 : 0) != 0);
        return this.handlers.registerParser(tlvType, (Object)parser);
    }

    public AutoCloseable registerTlvSerializer(Class<? extends Tlv> tlvClass, TlvSerializer serializer) {
        return this.handlers.registerSerializer(tlvClass, (Object)serializer);
    }

    @Override
    public TlvParser getTlvParser(int tlvType) {
        return (TlvParser)this.handlers.getParser(tlvType);
    }

    @Override
    public TlvSerializer getTlvSerializer(Tlv tlv) {
        return (TlvSerializer)this.handlers.getSerializer(tlv.getImplementedInterface());
    }
}

