/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.RROSubobjectHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.record.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleRROSubobjectHandlerRegistry
implements RROSubobjectHandlerRegistry {
    private final HandlerRegistry<DataContainer, RROSubobjectParser, RROSubobjectSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerSubobjectParser(int subobjectType, RROSubobjectParser parser) {
        Preconditions.checkArgument((subobjectType >= 0 && subobjectType <= 65535 ? 1 : 0) != 0);
        return this.handlers.registerParser(subobjectType, (Object)parser);
    }

    @Override
    public RROSubobjectParser getSubobjectParser(int subobjectType) {
        Preconditions.checkArgument((subobjectType >= 0 && subobjectType <= 65535 ? 1 : 0) != 0);
        return (RROSubobjectParser)this.handlers.getParser(subobjectType);
    }

    public AutoCloseable registerSubobjectSerializer(Class<? extends SubobjectType> subobjectClass, RROSubobjectSerializer serializer) {
        return this.handlers.registerSerializer(subobjectClass, (Object)serializer);
    }

    @Override
    public RROSubobjectSerializer getSubobjectSerializer(SubobjectType subobject) {
        return (RROSubobjectSerializer)this.handlers.getSerializer(subobject.getImplementedInterface());
    }
}

