/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleObjectHandlerRegistry
implements ObjectHandlerRegistry {
    private final HandlerRegistry<DataContainer, ObjectParser, ObjectSerializer> handlers = new HandlerRegistry();

    private static int createKey(int objectClass, int objectType) {
        Preconditions.checkArgument((objectClass >= 0 && objectClass <= 255 ? 1 : 0) != 0);
        Preconditions.checkArgument((objectType >= 0 && objectType <= 15 ? 1 : 0) != 0);
        return objectClass << 4 | objectType;
    }

    public AutoCloseable registerObjectParser(int objectClass, int objectType, ObjectParser parser) {
        Preconditions.checkArgument((objectClass >= 0 && objectClass <= 255 ? 1 : 0) != 0, (String)"Illagal object class %s", (java.lang.Object[])new java.lang.Object[]{objectClass});
        Preconditions.checkArgument((objectType >= 0 && objectType <= 15 ? 1 : 0) != 0, (String)"Illegal object type %s", (java.lang.Object[])new java.lang.Object[]{objectType});
        return this.handlers.registerParser(SimpleObjectHandlerRegistry.createKey(objectClass, objectType), (java.lang.Object)parser);
    }

    public AutoCloseable registerObjectSerializer(Class<? extends Object> objClass, ObjectSerializer serializer) {
        return this.handlers.registerSerializer(objClass, (java.lang.Object)serializer);
    }

    @Override
    public ObjectParser getObjectParser(int objectClass, int objectType) {
        ObjectParser ret = (ObjectParser)this.handlers.getParser(SimpleObjectHandlerRegistry.createKey(objectClass, objectType));
        if (ret != null) {
            return ret;
        }
        boolean foundClass = false;
        return new ObjectParser(){

            @Override
            public Object parseObject(ObjectHeader header, byte[] buffer) {
                return new UnknownObject(PCEPErrors.UNRECOGNIZED_OBJ_CLASS);
            }
        };
    }

    @Override
    public ObjectSerializer getObjectSerializer(Object object) {
        return (ObjectSerializer)this.handlers.getSerializer(object.getImplementedInterface());
    }
}

