/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.MessageHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.MessageParser;
import org.opendaylight.protocol.pcep.spi.MessageSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleMessageHandlerRegistry
implements MessageHandlerRegistry {
    private final HandlerRegistry<DataContainer, MessageParser, MessageSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerMessageParser(int messageType, MessageParser parser) {
        Preconditions.checkArgument((messageType >= 0 && messageType <= 255 ? 1 : 0) != 0);
        return this.handlers.registerParser(messageType, (Object)parser);
    }

    public AutoCloseable registerMessageSerializer(Class<? extends Message> msgClass, MessageSerializer serializer) {
        return this.handlers.registerSerializer(msgClass, (Object)serializer);
    }

    @Override
    public MessageParser getMessageParser(int messageType) {
        Preconditions.checkArgument((messageType >= 0 && messageType <= 255 ? 1 : 0) != 0);
        return (MessageParser)this.handlers.getParser(messageType);
    }

    @Override
    public MessageSerializer getMessageSerializer(Message message) {
        return (MessageSerializer)this.handlers.getSerializer(message.getImplementedInterface());
    }
}

