/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.LabelHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.LabelParser;
import org.opendaylight.protocol.pcep.spi.LabelSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.label.subobject.LabelType;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class SimpleLabelHandlerRegistry
implements LabelHandlerRegistry {
    private final HandlerRegistry<DataContainer, LabelParser, LabelSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerLabelParser(int cType, LabelParser parser) {
        Preconditions.checkArgument((cType >= 0 && cType <= 255 ? 1 : 0) != 0);
        return this.handlers.registerParser(cType, (Object)parser);
    }

    public AutoCloseable registerLabelSerializer(Class<? extends LabelType> labelClass, LabelSerializer serializer) {
        return this.handlers.registerSerializer(labelClass, (Object)serializer);
    }

    @Override
    public LabelParser getLabelParser(int cType) {
        Preconditions.checkArgument((cType >= 0 && cType <= 255 ? 1 : 0) != 0);
        return (LabelParser)this.handlers.getParser(cType);
    }

    @Override
    public LabelSerializer getLabelSerializer(LabelType label) {
        return (LabelSerializer)this.handlers.getSerializer(label.getImplementedInterface());
    }
}

