/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.EROSubobjectHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public final class SimpleEROSubobjectHandlerRegistry
implements EROSubobjectHandlerRegistry {
    private final HandlerRegistry<DataContainer, EROSubobjectParser, EROSubobjectSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerSubobjectParser(int subobjectType, EROSubobjectParser parser) {
        Preconditions.checkArgument((subobjectType >= 0 && subobjectType <= 65535 ? 1 : 0) != 0);
        return this.handlers.registerParser(subobjectType, (Object)parser);
    }

    public AutoCloseable registerSubobjectSerializer(Class<? extends SubobjectType> subobjectClass, EROSubobjectSerializer serializer) {
        return this.handlers.registerSerializer(subobjectClass, (Object)serializer);
    }

    @Override
    public EROSubobjectParser getSubobjectParser(int subobjectType) {
        Preconditions.checkArgument((subobjectType >= 0 && subobjectType <= 65535 ? 1 : 0) != 0);
        return (EROSubobjectParser)this.handlers.getParser(subobjectType);
    }

    @Override
    public EROSubobjectSerializer getSubobjectSerializer(SubobjectType subobject) {
        return (EROSubobjectSerializer)this.handlers.getSerializer(subobject.getImplementedInterface());
    }
}

