/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCEPErrorMapping {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPErrorMapping.class);
    private static final PCEPErrorMapping INSTANCE = new PCEPErrorMapping();
    private final Map<PCEPErrors, PCEPErrorIdentifier> errorsMap = new HashMap<PCEPErrors, PCEPErrorIdentifier>();
    private final Map<PCEPErrorIdentifier, PCEPErrors> errorIdsMap = new HashMap<PCEPErrorIdentifier, PCEPErrors>();

    private PCEPErrorMapping() {
        this.fillIn();
    }

    private void fillIn() {
        this.fillIn(new PCEPErrorIdentifier(1, 1), PCEPErrors.NON_OR_INVALID_OPEN_MSG);
        this.fillIn(new PCEPErrorIdentifier(1, 2), PCEPErrors.NO_OPEN_BEFORE_EXP_OPENWAIT);
        this.fillIn(new PCEPErrorIdentifier(1, 3), PCEPErrors.NON_ACC_NON_NEG_SESSION_CHAR);
        this.fillIn(new PCEPErrorIdentifier(1, 4), PCEPErrors.NON_ACC_NEG_SESSION_CHAR);
        this.fillIn(new PCEPErrorIdentifier(1, 5), PCEPErrors.SECOND_OPEN_MSG);
        this.fillIn(new PCEPErrorIdentifier(1, 6), PCEPErrors.PCERR_NON_ACC_SESSION_CHAR);
        this.fillIn(new PCEPErrorIdentifier(1, 7), PCEPErrors.NO_MSG_BEFORE_EXP_KEEPWAIT);
        this.fillIn(new PCEPErrorIdentifier(1, 8), PCEPErrors.PCEP_VERSION_NOT_SUPPORTED);
        this.fillIn(new PCEPErrorIdentifier(2, 0), PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        this.fillIn(new PCEPErrorIdentifier(3, 1), PCEPErrors.UNRECOGNIZED_OBJ_CLASS);
        this.fillIn(new PCEPErrorIdentifier(3, 2), PCEPErrors.UNRECOGNIZED_OBJ_TYPE);
        this.fillIn(new PCEPErrorIdentifier(4, 1), PCEPErrors.NOT_SUPPORTED_OBJ_CLASS);
        this.fillIn(new PCEPErrorIdentifier(4, 2), PCEPErrors.NOT_SUPPORTED_OBJ_TYPE);
        this.fillIn(new PCEPErrorIdentifier(5, 1), PCEPErrors.C_BIT_SET);
        this.fillIn(new PCEPErrorIdentifier(5, 2), PCEPErrors.O_BIT_SET);
        this.fillIn(new PCEPErrorIdentifier(5, 3), PCEPErrors.OF_NOT_ALLOWED);
        this.fillIn(new PCEPErrorIdentifier(5, 4), PCEPErrors.OF_BIT_SET);
        this.fillIn(new PCEPErrorIdentifier(5, 5), PCEPErrors.GCO_NOT_ALLOWED);
        this.fillIn(new PCEPErrorIdentifier(5, 7), PCEPErrors.P2MP_COMPUTATION_NOT_ALLOWED);
        this.fillIn(new PCEPErrorIdentifier(6, 1), PCEPErrors.RP_MISSING);
        this.fillIn(new PCEPErrorIdentifier(6, 2), PCEPErrors.RRO_MISSING);
        this.fillIn(new PCEPErrorIdentifier(6, 3), PCEPErrors.END_POINTS_MISSING);
        this.fillIn(new PCEPErrorIdentifier(6, 8), PCEPErrors.LSP_MISSING);
        this.fillIn(new PCEPErrorIdentifier(6, 9), PCEPErrors.ERO_MISSING);
        this.fillIn(new PCEPErrorIdentifier(6, 10), PCEPErrors.SRP_MISSING);
        this.fillIn(new PCEPErrorIdentifier(6, 11), PCEPErrors.LSP_IDENTIFIERS_TLV_MISSING);
        this.fillIn(new PCEPErrorIdentifier(6, 13), PCEPErrors.LSP_CLEANUP_TLV_MISSING);
        this.fillIn(new PCEPErrorIdentifier(6, 14), PCEPErrors.SYMBOLIC_PATH_NAME_MISSING);
        this.fillIn(new PCEPErrorIdentifier(7, 0), PCEPErrors.SYNC_PATH_COMP_REQ_MISSING);
        this.fillIn(new PCEPErrorIdentifier(8, 0), PCEPErrors.UNKNOWN_REQ_REF);
        this.fillIn(new PCEPErrorIdentifier(9, 0), PCEPErrors.ATTEMPT_2ND_SESSION);
        this.fillIn(new PCEPErrorIdentifier(10, 1), PCEPErrors.P_FLAG_NOT_SET);
        this.fillIn(new PCEPErrorIdentifier(12, 1), PCEPErrors.UNSUPPORTED_CT);
        this.fillIn(new PCEPErrorIdentifier(12, 2), PCEPErrors.INVALID_CT);
        this.fillIn(new PCEPErrorIdentifier(12, 3), PCEPErrors.CT_AND_SETUP_PRIORITY_DO_NOT_FORM_TE_CLASS);
        this.fillIn(new PCEPErrorIdentifier(15, 1), PCEPErrors.INSUFFICIENT_MEMORY);
        this.fillIn(new PCEPErrorIdentifier(15, 2), PCEPErrors.GCO_NOT_SUPPORTED);
        this.fillIn(new PCEPErrorIdentifier(16, 1), PCEPErrors.CANNOT_SATISFY_P2MP_REQUEST_DUE_TO_INSUFFISIENT_MEMMORY);
        this.fillIn(new PCEPErrorIdentifier(16, 2), PCEPErrors.NOT_CAPPABLE_P2MP_COMPUTATION);
        this.fillIn(new PCEPErrorIdentifier(17, 1), PCEPErrors.P2MP_NOT_CAPPABLE_SATISFY_REQ_DUE_LT2);
        this.fillIn(new PCEPErrorIdentifier(17, 2), PCEPErrors.P2MP_NOT_CAPPABLE_SATISFY_REQ_DUE_LT3);
        this.fillIn(new PCEPErrorIdentifier(17, 3), PCEPErrors.P2MP_NOT_CAPPABLE_SATISFY_REQ_DUE_LT4);
        this.fillIn(new PCEPErrorIdentifier(17, 4), PCEPErrors.P2MP_NOT_CAPPABLE_SATISFY_REQ_DUE_INCONSISTENT_EP);
        this.fillIn(new PCEPErrorIdentifier(18, 1), PCEPErrors.P2MP_FRAGMENTATION_FAILRUE);
        this.fillIn(new PCEPErrorIdentifier(19, 1), PCEPErrors.UPDATE_REQ_FOR_NON_LSP);
        this.fillIn(new PCEPErrorIdentifier(19, 2), PCEPErrors.UPDATE_REQ_FOR_NO_STATEFUL);
        this.fillIn(new PCEPErrorIdentifier(19, 3), PCEPErrors.UNKNOWN_PLSP_ID);
        this.fillIn(new PCEPErrorIdentifier(19, 4), PCEPErrors.RESOURCE_LIMIT_EXCEEDED);
        this.fillIn(new PCEPErrorIdentifier(19, 6), PCEPErrors.LSP_LIMIT_EXCEEDED);
        this.fillIn(new PCEPErrorIdentifier(19, 7), PCEPErrors.DELEGATION_NON_REVOKABLE);
        this.fillIn(new PCEPErrorIdentifier(19, 8), PCEPErrors.NON_ZERO_PLSPID);
        this.fillIn(new PCEPErrorIdentifier(20, 1), PCEPErrors.CANNOT_PROCESS_STATE_REPORT);
        this.fillIn(new PCEPErrorIdentifier(20, 2), PCEPErrors.LSP_DB_VERSION_MISMATCH);
        this.fillIn(new PCEPErrorIdentifier(20, 3), PCEPErrors.DB_VERSION_TLV_MISSING_WHEN_SYNC_ALLOWED);
        this.fillIn(new PCEPErrorIdentifier(20, 5), PCEPErrors.CANNOT_COMPLETE_STATE_SYNC);
        this.fillIn(new PCEPErrorIdentifier(23, 1), PCEPErrors.USED_SYMBOLIC_PATH_NAME);
        this.fillIn(new PCEPErrorIdentifier(24, 1), PCEPErrors.LSP_UNACC_INST_PARAMS);
        this.fillIn(new PCEPErrorIdentifier(24, 2), PCEPErrors.LSP_INTERNAL_ERROR);
        this.fillIn(new PCEPErrorIdentifier(24, 3), PCEPErrors.LSP_RSVP_ERROR);
    }

    private void fillIn(PCEPErrorIdentifier identifier, PCEPErrors error) {
        this.errorsMap.put(error, identifier);
        this.errorIdsMap.put(identifier, error);
    }

    public PCEPErrorIdentifier getFromErrorsEnum(PCEPErrors error) {
        PCEPErrorIdentifier ei = this.errorsMap.get((Object)error);
        if (ei == null) {
            LOG.debug("Unknown PCEPErrors type: {}.", (Object)error);
            throw new NoSuchElementException("Unknown PCEPErrors type: " + (Object)((Object)error));
        }
        return ei;
    }

    public PCEPErrors getFromErrorIdentifier(PCEPErrorIdentifier identifier) {
        PCEPErrors e = this.errorIdsMap.get(identifier);
        if (e == null) {
            LOG.debug("Unknown error type/value combination: {}.", (Object)identifier);
            throw new NoSuchElementException("Unknown error type/value combination: " + identifier);
        }
        return e;
    }

    public static PCEPErrorMapping getInstance() {
        return INSTANCE;
    }

    public static final class PCEPErrorIdentifier {
        public short type;
        public short value;

        private PCEPErrorIdentifier(short type, short value) {
            this.type = type;
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.type;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PCEPErrorIdentifier other = (PCEPErrorIdentifier)obj;
            if (this.type != other.type) {
                return false;
            }
            return this.value == other.value;
        }

        public String toString() {
            return "type " + this.type + " value " + this.value;
        }
    }
}

