/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import com.google.common.primitives.UnsignedBytes;
import org.opendaylight.protocol.util.ByteArray;

public final class ObjectUtil {
    private static final int HEADER_SIZE = 4;
    private static final int OC_F_LENGTH = 1;
    private static final int OT_FLAGS_MF_LENGTH = 1;
    private static final int OBJ_LENGTH_F_LENGTH = 2;
    private static final int OC_F_OFFSET = 0;
    private static final int OT_FLAGS_MF_OFFSET = 1;
    private static final int OBJ_LENGTH_F_OFFSET = 2;
    private static final int OT_SF_LENGTH = 4;
    private static final int P_FLAG_OFFSET = 6;
    private static final int I_FLAG_OFFSET = 7;

    private ObjectUtil() {
    }

    public static byte[] formatSubobject(int objectType, int objectClass, Boolean processingRule, Boolean ignore, byte[] valueBytes) {
        byte[] bytes = new byte[4 + valueBytes.length];
        bytes[0] = UnsignedBytes.checkedCast((long)objectClass);
        bytes[1] = UnsignedBytes.checkedCast((long)(objectType << 4));
        if (processingRule != null && processingRule.booleanValue()) {
            bytes[1] = (byte)(bytes[1] | 2);
        }
        if (ignore != null && ignore.booleanValue()) {
            bytes[1] = (byte)(bytes[1] | 1);
        }
        System.arraycopy(ByteArray.intToBytes((int)(valueBytes.length + 4), (int)2), 0, bytes, 2, 2);
        System.arraycopy(valueBytes, 0, bytes, 4, valueBytes.length);
        return bytes;
    }
}

