/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectWithTlvsParser<T>
implements ObjectParser,
ObjectSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractObjectWithTlvsParser.class);
    private static final int TLV_TYPE_F_LENGTH = 2;
    private static final int TLV_LENGTH_F_LENGTH = 2;
    private static final int TLV_HEADER_LENGTH = 4;
    protected static final int PADDED_TO = 4;
    private final TlvHandlerRegistry tlvReg;

    protected AbstractObjectWithTlvsParser(TlvHandlerRegistry tlvReg) {
        this.tlvReg = (TlvHandlerRegistry)Preconditions.checkNotNull((Object)tlvReg);
    }

    protected final void parseTlvs(T builder, byte[] bytes) throws PCEPDeserializerException {
        int length;
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array is mandatory.");
        }
        if (bytes.length == 0) {
            return;
        }
        int type = 0;
        for (int byteOffset = 0; byteOffset < bytes.length; byteOffset += length + AbstractObjectWithTlvsParser.getPadding(4 + length, 4)) {
            type = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])bytes, (int)byteOffset, (int)2));
            length = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])bytes, (int)(byteOffset += 2), (int)2));
            byteOffset += 2;
            if (4 + length > bytes.length) {
                throw new PCEPDeserializerException("Wrong length specified. Passed: " + (4 + length) + "; Expected: <= " + (bytes.length - byteOffset) + ".");
            }
            byte[] tlvBytes = ByteArray.subByte((byte[])bytes, (int)byteOffset, (int)length);
            LOG.trace("Attempt to parse tlv from bytes: {}", (Object)ByteArray.bytesToHexString((byte[])tlvBytes));
            TlvParser parser = this.tlvReg.getTlvParser(type);
            if (parser != null) {
                Tlv tlv = parser.parseTlv(tlvBytes);
                LOG.trace("Tlv was parsed. {}", (Object)tlv);
                this.addTlv(builder, tlv);
                continue;
            }
            LOG.warn("Unknown TLV received. Type {}. Ignoring it.", (Object)type);
        }
    }

    protected final byte[] serializeTlv(Tlv tlv) {
        TlvSerializer serializer = this.tlvReg.getTlvSerializer(tlv);
        byte[] typeBytes = ByteArray.intToBytes((int)serializer.getType(), (int)2);
        byte[] valueBytes = serializer.serializeTlv(tlv);
        byte[] lengthBytes = ByteArray.intToBytes((int)valueBytes.length, (int)2);
        byte[] bytes = new byte[4 + valueBytes.length + AbstractObjectWithTlvsParser.getPadding(4 + valueBytes.length, 4)];
        int byteOffset = 0;
        System.arraycopy(typeBytes, 0, bytes, byteOffset, 2);
        System.arraycopy(lengthBytes, 0, bytes, byteOffset += 2, 2);
        System.arraycopy(valueBytes, 0, bytes, byteOffset += 2, valueBytes.length);
        return bytes;
    }

    public abstract void addTlv(T var1, Tlv var2);

    protected static int getPadding(int length, int padding) {
        return (padding - length % padding) % padding;
    }
}

