/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.MessageParser;
import org.opendaylight.protocol.pcep.spi.MessageSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectHandlerRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectHeaderImpl;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrorMapping;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcerrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.RequestCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.RequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.request.Rps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.request.RpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;

public abstract class AbstractMessageParser
implements MessageParser,
MessageSerializer {
    private static final int COMMON_OBJECT_HEADER_LENGTH = 4;
    private static final int OC_F_LENGTH = 1;
    private static final int OT_FLAGS_MF_LENGTH = 1;
    private static final int OBJ_LENGTH_F_LENGTH = 2;
    private static final int OT_SF_LENGTH = 4;
    private static final int FLAGS_SF_LENGTH = 4;
    private static final int OT_SF_OFFSET = 0;
    private static final int FLAGS_SF_OFFSET = 4;
    private static final int P_FLAG_OFFSET = 6;
    private static final int I_FLAG_OFFSET = 7;
    private final ObjectHandlerRegistry registry;

    protected AbstractMessageParser(ObjectHandlerRegistry registry) {
        this.registry = (ObjectHandlerRegistry)Preconditions.checkNotNull((java.lang.Object)registry);
    }

    protected byte[] serializeObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null object passed.");
        }
        ObjectSerializer serializer = this.registry.getObjectSerializer(object);
        return serializer.serializeObject(object);
    }

    private List<Object> parseObjects(byte[] bytes) throws PCEPDeserializerException {
        int offset = 0;
        ArrayList objs = Lists.newArrayList();
        while (bytes.length - offset > 0) {
            ObjectHeaderImpl header;
            int objLength;
            if (bytes.length - offset < 4) {
                throw new PCEPDeserializerException("Too few bytes in passed array. Passed: " + (bytes.length - offset) + " Expected: >= " + 4 + ".");
            }
            int objClass = UnsignedBytes.toInt((byte)bytes[offset]);
            int objType = UnsignedBytes.toInt((byte)ByteArray.copyBitsRange((byte)bytes[++offset], (int)0, (int)4));
            byte[] flagsBytes = new byte[]{ByteArray.copyBitsRange((byte)bytes[offset], (int)4, (int)4)};
            BitSet flags = ByteArray.bytesToBitSet((byte[])flagsBytes);
            if (bytes.length - ++offset < (objLength = ByteArray.bytesToInt((byte[])ByteArray.subByte((byte[])bytes, (int)offset, (int)2))) - 4) {
                throw new PCEPDeserializerException("Too few bytes in passed array. Passed: " + (bytes.length - offset) + " Expected: >= " + objLength + ".");
            }
            byte[] bytesToPass = ByteArray.subByte((byte[])bytes, (int)(offset += 2), (int)(objLength - 4));
            offset += objLength - 4;
            ObjectParser parser = (ObjectParser)Preconditions.checkNotNull((java.lang.Object)this.registry.getObjectParser(objClass, objType));
            Object o = parser.parseObject(header = new ObjectHeaderImpl(flags.get(6), flags.get(7)), bytesToPass);
            if (o == null) continue;
            objs.add(o);
        }
        return objs;
    }

    public static Message createErrorMsg(PCEPErrors e) {
        PCEPErrorMapping maping = PCEPErrorMapping.getInstance();
        return new PcerrBuilder().setPcerrMessage(new PcerrMessageBuilder().setErrors(Arrays.asList(new ErrorsBuilder().setErrorObject(new ErrorObjectBuilder().setType(Short.valueOf(maping.getFromErrorsEnum((PCEPErrors)e).type)).setValue(Short.valueOf(maping.getFromErrorsEnum((PCEPErrors)e).value)).build()).build())).build()).build();
    }

    public static Message createErrorMsg(PCEPErrors e, Rp rp) {
        PCEPErrorMapping maping = PCEPErrorMapping.getInstance();
        return new PcerrBuilder().setPcerrMessage(new PcerrMessageBuilder().setErrorType((ErrorType)new RequestCaseBuilder().setRequest(new RequestBuilder().setRps((List)Lists.newArrayList((java.lang.Object[])new Rps[]{new RpsBuilder().setRp(rp).build()})).build()).build()).setErrors(Arrays.asList(new ErrorsBuilder().setErrorObject(new ErrorObjectBuilder().setType(Short.valueOf(maping.getFromErrorsEnum((PCEPErrors)e).type)).setValue(Short.valueOf(maping.getFromErrorsEnum((PCEPErrors)e).value)).build()).build())).build()).build();
    }

    protected abstract Message validate(List<Object> var1, List<Message> var2) throws PCEPDeserializerException;

    @Override
    public final Message parseMessage(byte[] buffer, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkNotNull((java.lang.Object)buffer, (java.lang.Object)"Buffer may not be null");
        List<Object> objs = this.parseObjects(buffer);
        return this.validate(objs, errors);
    }
}

