/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.TablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.rib.tables.Routes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TablesBuilder
implements Builder<Tables> {
    private Class<? extends AddressFamily> _afi;
    private Attributes _attributes;
    private Routes _routes;
    private Class<? extends SubsequentAddressFamily> _safi;
    private TablesKey key;
    Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = Collections.emptyMap();

    public TablesBuilder() {
    }

    public TablesBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public TablesBuilder(Tables base) {
        Map aug;
        this.key = base.key();
        this._afi = base.getAfi();
        this._safi = base.getSafi();
        this._attributes = base.getAttributes();
        this._routes = base.getRoutes();
        if (base instanceof TablesImpl) {
            TablesImpl impl = (TablesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType]");
    }

    public TablesKey key() {
        return this.key;
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public Routes getRoutes() {
        return this._routes;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<Tables>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TablesBuilder withKey(TablesKey key) {
        this.key = key;
        return this;
    }

    public TablesBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public TablesBuilder setAttributes(Attributes value) {
        this._attributes = value;
        return this;
    }

    public TablesBuilder setRoutes(Routes value) {
        this._routes = value;
        return this;
    }

    public TablesBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public TablesBuilder addAugmentation(Class<? extends Augmentation<Tables>> augmentationType, Augmentation<Tables> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tables>>, Augmentation<Tables>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TablesBuilder removeAugmentation(Class<? extends Augmentation<Tables>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Tables build() {
        return new TablesImpl(this);
    }

    private static final class TablesImpl
    implements Tables {
        private final Class<? extends AddressFamily> _afi;
        private final Attributes _attributes;
        private final Routes _routes;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private final TablesKey key;
        private Map<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TablesImpl(TablesBuilder base) {
            this.key = base.key() != null ? base.key() : new TablesKey(base.getAfi(), base.getSafi());
            this._afi = this.key.getAfi();
            this._safi = this.key.getSafi();
            this._attributes = base.getAttributes();
            this._routes = base.getRoutes();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Tables> getImplementedInterface() {
            return Tables.class;
        }

        @Override
        public TablesKey key() {
            return this.key;
        }

        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        @Override
        public Attributes getAttributes() {
            return this._attributes;
        }

        @Override
        public Routes getRoutes() {
            return this._routes;
        }

        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public <E$$ extends Augmentation<Tables>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._afi);
            result = 31 * result + Objects.hashCode(this._attributes);
            result = 31 * result + Objects.hashCode(this._routes);
            result = 31 * result + Objects.hashCode(this._safi);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tables.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tables other = (Tables)obj;
            if (!Objects.equals(this._afi, other.getAfi())) {
                return false;
            }
            if (!Objects.equals(this._attributes, other.getAttributes())) {
                return false;
            }
            if (!Objects.equals(this._routes, other.getRoutes())) {
                return false;
            }
            if (!Objects.equals(this._safi, other.getSafi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TablesImpl otherImpl = (TablesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Tables>>, Augmentation<Tables>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Tables");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_afi", this._afi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_attributes", (Object)this._attributes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_routes", (Object)this._routes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_safi", this._safi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

