/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.RibId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.Rib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.RibKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.LocRib;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.rib.rev180329.bgp.rib.rib.Peer;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RibBuilder
implements Builder<Rib> {
    private RibId _id;
    private LocRib _locRib;
    private List<Peer> _peer;
    private RibKey key;
    Map<Class<? extends Augmentation<Rib>>, Augmentation<Rib>> augmentation = Collections.emptyMap();

    public RibBuilder() {
    }

    public RibBuilder(Rib base) {
        Map aug;
        this.key = base.key();
        this._id = base.getId();
        this._locRib = base.getLocRib();
        this._peer = base.getPeer();
        if (base instanceof RibImpl) {
            RibImpl impl = (RibImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Rib>>, Augmentation<Rib>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Rib>>, Augmentation<Rib>>(aug);
        }
    }

    public RibKey key() {
        return this.key;
    }

    public RibId getId() {
        return this._id;
    }

    public LocRib getLocRib() {
        return this._locRib;
    }

    public List<Peer> getPeer() {
        return this._peer;
    }

    public <E$$ extends Augmentation<Rib>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RibBuilder withKey(RibKey key) {
        this.key = key;
        return this;
    }

    public RibBuilder setId(RibId value) {
        this._id = value;
        return this;
    }

    public RibBuilder setLocRib(LocRib value) {
        this._locRib = value;
        return this;
    }

    public RibBuilder setPeer(List<Peer> values) {
        this._peer = values;
        return this;
    }

    public RibBuilder addAugmentation(Class<? extends Augmentation<Rib>> augmentationType, Augmentation<Rib> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Rib>>, Augmentation<Rib>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RibBuilder removeAugmentation(Class<? extends Augmentation<Rib>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Rib build() {
        return new RibImpl(this);
    }

    private static final class RibImpl
    implements Rib {
        private final RibId _id;
        private final LocRib _locRib;
        private final List<Peer> _peer;
        private final RibKey key;
        private Map<Class<? extends Augmentation<Rib>>, Augmentation<Rib>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        RibImpl(RibBuilder base) {
            this.key = base.key() != null ? base.key() : new RibKey(base.getId());
            this._id = this.key.getId();
            this._locRib = base.getLocRib();
            this._peer = base.getPeer();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Rib> getImplementedInterface() {
            return Rib.class;
        }

        @Override
        public RibKey key() {
            return this.key;
        }

        @Override
        public RibId getId() {
            return this._id;
        }

        @Override
        public LocRib getLocRib() {
            return this._locRib;
        }

        @Override
        public List<Peer> getPeer() {
            return this._peer;
        }

        public <E$$ extends Augmentation<Rib>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._locRib);
            result = 31 * result + Objects.hashCode(this._peer);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Rib.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Rib other = (Rib)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._locRib, other.getLocRib())) {
                return false;
            }
            if (!Objects.equals(this._peer, other.getPeer())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RibImpl otherImpl = (RibImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Rib>>, Augmentation<Rib>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Rib");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_locRib", (Object)this._locRib);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peer", this._peer);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

