/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.peer.rpc.rev180329;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.peer.rpc.rev180329.PeerRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.peer.rpc.rev180329.PeerReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.peer.rpc.rev180329.RouteRefreshRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RouteRefreshRequestInputBuilder
implements Builder<RouteRefreshRequestInput> {
    private Class<? extends AddressFamily> _afi;
    private PeerRef _peerRef;
    private Class<? extends SubsequentAddressFamily> _safi;
    Map<Class<? extends Augmentation<RouteRefreshRequestInput>>, Augmentation<RouteRefreshRequestInput>> augmentation = Collections.emptyMap();

    public RouteRefreshRequestInputBuilder() {
    }

    public RouteRefreshRequestInputBuilder(BgpTableType arg) {
        this._afi = arg.getAfi();
        this._safi = arg.getSafi();
    }

    public RouteRefreshRequestInputBuilder(PeerReference arg) {
        this._peerRef = arg.getPeerRef();
    }

    public RouteRefreshRequestInputBuilder(RouteRefreshRequestInput base) {
        Map aug;
        this._afi = base.getAfi();
        this._peerRef = base.getPeerRef();
        this._safi = base.getSafi();
        if (base instanceof RouteRefreshRequestInputImpl) {
            RouteRefreshRequestInputImpl impl = (RouteRefreshRequestInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RouteRefreshRequestInput>>, Augmentation<RouteRefreshRequestInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouteRefreshRequestInput>>, Augmentation<RouteRefreshRequestInput>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BgpTableType) {
            this._afi = ((BgpTableType)arg).getAfi();
            this._safi = ((BgpTableType)arg).getSafi();
            isValidArg = true;
        }
        if (arg instanceof PeerReference) {
            this._peerRef = ((PeerReference)arg).getPeerRef();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.peer.rpc.rev180329.PeerReference]");
    }

    public Class<? extends AddressFamily> getAfi() {
        return this._afi;
    }

    public PeerRef getPeerRef() {
        return this._peerRef;
    }

    public Class<? extends SubsequentAddressFamily> getSafi() {
        return this._safi;
    }

    public <E$$ extends Augmentation<RouteRefreshRequestInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RouteRefreshRequestInputBuilder setAfi(Class<? extends AddressFamily> value) {
        this._afi = value;
        return this;
    }

    public RouteRefreshRequestInputBuilder setPeerRef(PeerRef value) {
        this._peerRef = value;
        return this;
    }

    public RouteRefreshRequestInputBuilder setSafi(Class<? extends SubsequentAddressFamily> value) {
        this._safi = value;
        return this;
    }

    public RouteRefreshRequestInputBuilder addAugmentation(Class<? extends Augmentation<RouteRefreshRequestInput>> augmentationType, Augmentation<RouteRefreshRequestInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RouteRefreshRequestInput>>, Augmentation<RouteRefreshRequestInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RouteRefreshRequestInputBuilder removeAugmentation(Class<? extends Augmentation<RouteRefreshRequestInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RouteRefreshRequestInput build() {
        return new RouteRefreshRequestInputImpl(this);
    }

    private static final class RouteRefreshRequestInputImpl
    implements RouteRefreshRequestInput {
        private final Class<? extends AddressFamily> _afi;
        private final PeerRef _peerRef;
        private final Class<? extends SubsequentAddressFamily> _safi;
        private Map<Class<? extends Augmentation<RouteRefreshRequestInput>>, Augmentation<RouteRefreshRequestInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        RouteRefreshRequestInputImpl(RouteRefreshRequestInputBuilder base) {
            this._afi = base.getAfi();
            this._peerRef = base.getPeerRef();
            this._safi = base.getSafi();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<RouteRefreshRequestInput> getImplementedInterface() {
            return RouteRefreshRequestInput.class;
        }

        public Class<? extends AddressFamily> getAfi() {
            return this._afi;
        }

        @Override
        public PeerRef getPeerRef() {
            return this._peerRef;
        }

        public Class<? extends SubsequentAddressFamily> getSafi() {
            return this._safi;
        }

        public <E$$ extends Augmentation<RouteRefreshRequestInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._afi);
            result = 31 * result + Objects.hashCode(this._peerRef);
            result = 31 * result + Objects.hashCode(this._safi);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RouteRefreshRequestInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RouteRefreshRequestInput other = (RouteRefreshRequestInput)obj;
            if (!Objects.equals(this._afi, other.getAfi())) {
                return false;
            }
            if (!Objects.equals(this._peerRef, other.getPeerRef())) {
                return false;
            }
            if (!Objects.equals(this._safi, other.getSafi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RouteRefreshRequestInputImpl otherImpl = (RouteRefreshRequestInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RouteRefreshRequestInput>>, Augmentation<RouteRefreshRequestInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"RouteRefreshRequestInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_afi", this._afi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_peerRef", (Object)this._peerRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_safi", this._safi);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

