/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.trie;

import com.atlassian.clover.reporters.html.PackageInfoExt;
import com.atlassian.clover.util.trie.KeySequence;
import com.atlassian.clover.util.trie.Node;
import com.atlassian.clover.util.trie.NodeFactoryImpl;
import com.atlassian.clover.util.trie.NodeVisitor;
import com.atlassian.clover.util.trie.PrefixTree;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;

public class PackagePrefixTree
extends PrefixTree<String, PackageInfoExt> {
    private static final String EMPTY_KEY = "";

    public PackagePrefixTree() {
        super(NodeFactoryImpl.TREE_MAP_BACKED, EMPTY_KEY, null);
    }

    public void add(@NotNull String packageName, @Nullable PackageInfoExt value) {
        this.add(new PackageKeySequence(packageName), value);
    }

    public void compressTree() {
        NodeVisitor<String, PackageInfoExt> nodeCompressor = new NodeVisitor<String, PackageInfoExt>(){

            @Override
            public Node<String, PackageInfoExt> visit(@NotNull Node<String, PackageInfoExt> currentNode, int depth) {
                if (currentNode.children().size() == 1 && currentNode.getValue() == null) {
                    Node<String, PackageInfoExt> childNode = currentNode.children().values().iterator().next();
                    String mergedKey = String.valueOf(currentNode.getKey().isEmpty() ? PackagePrefixTree.EMPTY_KEY : String.valueOf(currentNode.getKey()) + ".") + childNode.getKey();
                    Node<String, PackageInfoExt> mergedNode = PackagePrefixTree.this.nodeFactory.createNode(mergedKey, childNode.getValue());
                    mergedNode.children().putAll(childNode.children());
                    return mergedNode;
                }
                return currentNode;
            }
        };
        this.rootNode = this.compressTree(this.rootNode, nodeCompressor);
    }

    public Node<String, PackageInfoExt> compressTree(Node<String, PackageInfoExt> rootNode, NodeVisitor<String, PackageInfoExt> nodeCompressor) {
        return this.rewriteTree(rootNode, nodeCompressor);
    }

    public static class PackageKeySequence
    extends KeySequence<String> {
        public PackageKeySequence(@NotNull String packageName) {
            super(PackageKeySequence.packageNameToSequence(packageName));
        }

        @NotNull
        protected static List<String> packageNameToSequence(@NotNull String packageName) {
            ArrayList<String> sequence = Lists.newArrayList();
            StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
            while (tokenizer.hasMoreTokens()) {
                sequence.add(tokenizer.nextToken());
            }
            return sequence;
        }
    }
}

