/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.trie;

import com.atlassian.clover.util.trie.Node;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeImpl<K, V>
implements Node<K, V> {
    @NotNull
    protected final Map<K, Node<K, V>> children;
    @NotNull
    private final K key;
    @Nullable
    private V value;

    public NodeImpl(@NotNull K key, @Nullable V value, @NotNull Map<K, Node<K, V>> children) {
        this.key = key;
        this.value = value;
        this.children = children;
    }

    @Override
    @NotNull
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(@Nullable V value) {
        this.value = value;
    }

    @Override
    @Nullable
    public Node<K, V> getChild(@NotNull K subKey) {
        return this.children.get(subKey);
    }

    @Override
    @NotNull
    public Node<K, V> addChild(@NotNull Node<K, V> subNode) {
        this.children.put(subNode.getKey(), subNode);
        return this.children.get(subNode.getKey());
    }

    @Override
    @NotNull
    public Map<K, Node<K, V>> children() {
        return this.children;
    }
}

