/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.json;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JSONReportUtils {
    public static Map<String, Number> collectColumnValuesFor(List columns, HasMetrics mInfo, HtmlRenderingSupportImpl mHelper) throws CloverException {
        Map<String, Number> columnValues = mHelper.collectColumnValues(columns, mInfo);
        BlockMetrics metrics = mHelper.metricsFor(mInfo);
        columnValues.put("Tests", metrics.getNumTests());
        columnValues.put("PassingTests", metrics.getNumTestPasses());
        columnValues.put("FailingTests", metrics.getNumTestFailures());
        columnValues.put("ErroneousTests", metrics.getNumTestErrors());
        columnValues.put("TestExecutionTime", metrics.getTestExecutionTime());
        columnValues.put("PcPassingTests", Float.valueOf(metrics.getPcTestPasses()));
        columnValues.put("PcFailingTests", Float.valueOf(metrics.getPcTestFailures()));
        columnValues.put("PcErroneousTests", Float.valueOf(metrics.getPcTestErrors()));
        return columnValues;
    }

    public static List getColumnNames(CloverReportConfig cfg) {
        List<Column> columns = cfg.isColumnsSet() ? cfg.getColumns().getProjectColumnsCopy() : Columns.getAllColumns();
        ArrayList<String> columnNames = new ArrayList<String>(columns.size() + 5);
        for (Column column : columns) {
            columnNames.add(column.getName());
        }
        columnNames.add("Tests");
        columnNames.add("PassingTests");
        columnNames.add("FailingTests");
        columnNames.add("ErroneousTests");
        columnNames.add("TestExecutionTime");
        columnNames.add("PcPassingTests");
        columnNames.add("PcFailingTests");
        columnNames.add("PcErroneousTests");
        return columnNames;
    }
}

