/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.org.apache.commons.lang3.StringUtils;
import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.BitSetCoverageProvider;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.util.CloverUtils;
import com.atlassian.clover.util.Formatting;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class RenderTestResultAction
implements Callable {
    private static final ThreadLocal<FullProjectInfo> REUSABLE_MODEL = new ThreadLocal();
    private static final ThreadLocal<FullProjectInfo> CONFIGURABLE_MODEL = new ThreadLocal();
    private static final Comparator<HasMetrics> TARGET_CLASS_COMPARATOR = new Comparator<HasMetrics>(){

        @Override
        public int compare(HasMetrics m, HasMetrics m1) {
            return Float.compare(m1.getMetrics().getPcCoveredElements(), m.getMetrics().getPcCoveredElements());
        }
    };
    private final HtmlRenderingSupportImpl renderingHelper;
    private final Current reportConfig;
    private final FullProjectInfo fullModel;
    private final TestCaseInfo testCaseInfo;
    private final VelocityContext velocity;
    private final CloverDatabase database;
    private final FullProjectInfo readOnlyModel;

    public RenderTestResultAction(TestCaseInfo testCaseInfo, HtmlRenderingSupportImpl renderingHelper, Current reportConfig, FullProjectInfo readOnlyModel, VelocityContext velocity, FullProjectInfo fullModel, CloverDatabase database) {
        this.renderingHelper = renderingHelper;
        this.reportConfig = reportConfig;
        this.readOnlyModel = readOnlyModel;
        this.testCaseInfo = testCaseInfo;
        this.velocity = velocity;
        this.fullModel = fullModel;
        this.database = database;
    }

    public Object call() throws Exception {
        if (REUSABLE_MODEL.get() == null) {
            REUSABLE_MODEL.set(this.readOnlyModel.copy());
        }
        if (CONFIGURABLE_MODEL.get() == null) {
            CONFIGURABLE_MODEL.set(this.readOnlyModel.copy());
        }
        FullFileInfo finfo = (FullFileInfo)this.testCaseInfo.getRuntimeType().getContainingFile();
        StringBuffer outname = this.renderingHelper.getTestFileName(this.testCaseInfo);
        File outfile = CloverUtils.createOutFile(finfo, outname.toString(), this.reportConfig.getOutFile());
        FullProjectInfo projectInfo = CONFIGURABLE_MODEL.get();
        CoverageData data = this.database.getCoverageData();
        projectInfo.setDataProvider(new BitSetCoverageProvider(data.getHitsFor(this.testCaseInfo), data));
        List<? extends BaseClassInfo> classes = this.getCoverageByTest(projectInfo);
        if (this.reportConfig.isShowUniqueCoverage()) {
            this.gatherUniquenessVariables(classes);
        } else {
            this.velocity.put("showUnique", Boolean.FALSE);
        }
        this.velocity.put("currentPageURL", outname);
        Collections.sort(classes, TARGET_CLASS_COMPARATOR);
        this.velocity.put("targetClasses", classes);
        this.velocity.put("test", this.testCaseInfo);
        this.velocity.put("topLevel", Boolean.TRUE);
        this.velocity.put("projectInfo", this.fullModel);
        this.velocity.put("hasResults", this.fullModel.hasTestResults());
        this.velocity.put("stringUtils", new StringUtils());
        this.velocity.put("renderUtil", this.renderingHelper);
        HtmlReportUtil.mergeTemplateToFile(outfile, this.velocity, "test-summary.vm");
        return null;
    }

    private void gatherUniquenessVariables(List<? extends BaseClassInfo> classes) {
        LinkedHashMap<String, ClassInfo> uniqueCoverageMap = new LinkedHashMap<String, ClassInfo>();
        float uniqueElementsHit = this.buildUniqueCoverageMap(this.testCaseInfo, uniqueCoverageMap);
        int totalElementsHit = 0;
        for (ClassInfo classInfo : classes) {
            totalElementsHit += classInfo.getMetrics().getNumCoveredElements();
        }
        float f = (float)totalElementsHit > 0.0f ? uniqueElementsHit / (float)totalElementsHit : 0.0f;
        String pcUniqueCoverage = Formatting.getPercentStr(f);
        this.velocity.put("showUnique", Boolean.TRUE);
        this.velocity.put("uniqueTargetClasses", uniqueCoverageMap);
        this.velocity.put("pcUniqueCoverage", pcUniqueCoverage);
    }

    private int buildUniqueCoverageMap(TestCaseInfo tci, Map<String, ClassInfo> uniqueCoverageMap) {
        FullProjectInfo projectInfo = this.createUniqueCoverageModel(tci);
        List<? extends BaseClassInfo> uniqueClassesCovered = this.getCoverageByTest(projectInfo);
        Collections.sort(uniqueClassesCovered, TARGET_CLASS_COMPARATOR);
        int uniqueElementsHit = 0;
        for (BaseClassInfo baseClassInfo : uniqueClassesCovered) {
            uniqueCoverageMap.put(baseClassInfo.getQualifiedName(), baseClassInfo);
            uniqueElementsHit += baseClassInfo.getMetrics().getNumCoveredElements();
        }
        return uniqueElementsHit;
    }

    private FullProjectInfo createUniqueCoverageModel(TestCaseInfo tci) {
        FullProjectInfo projectInfo = REUSABLE_MODEL.get();
        CoverageData data = this.database.getCoverageData();
        projectInfo.setDataProvider(new BitSetCoverageProvider(data.getUniqueHitsFor(tci), data));
        return projectInfo;
    }

    private List<? extends BaseClassInfo> getCoverageByTest(FullProjectInfo projectInfo) {
        return projectInfo.getClasses(new HasMetricsFilter(){

            @Override
            public boolean accept(HasMetrics hm) {
                return !((ClassInfo)hm).isTestClass() && hm.getMetrics().getNumCoveredElements() > 0;
            }
        });
    }
}

