/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.antlr.TokenStreamException;
import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.BitSetCoverageProvider;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.registry.FileElementVisitor;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.util.EntityVisitorUtils;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.JSONObjectFactory;
import com.atlassian.clover.reporters.html.source.SourceRenderHelper;
import com.atlassian.clover.reporters.json.JSONException;
import com.atlassian.clover.reporters.util.CloverChartFactory;
import com.atlassian.clover.util.CloverUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class RenderFileAction
implements Callable {
    protected static ThreadLocal<List<Column>> columnsTL;
    protected static ThreadLocal<ContextSet> contextSetTL;
    private static final Comparator TEST_METRICS_COMPARATOR;
    protected final FullFileInfo fileInfo;
    protected final HtmlRenderingSupportImpl renderingHelper;
    protected final Current reportConfig;
    protected final VelocityContext velocity;
    protected final CloverDatabase database;
    protected final FullProjectInfo fullModel;
    protected final Map<Integer, CloverChartFactory.ChartInfo> charts;
    protected List<TestCaseInfo>[] testLineInfo;

    static {
        TEST_METRICS_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object1) {
                BlockMetrics m = (BlockMetrics)((Map.Entry)object).getValue();
                BlockMetrics m1 = (BlockMetrics)((Map.Entry)object1).getValue();
                return (int)(1000.0f * (m1.getPcCoveredElements() - m.getPcCoveredElements()));
            }
        };
    }

    public RenderFileAction(FullFileInfo fileInfo, HtmlRenderingSupportImpl renderingHelper, Current report, VelocityContext velocity, CloverDatabase database, FullProjectInfo fullModel, Map<Integer, CloverChartFactory.ChartInfo> charts) {
        this.fileInfo = fileInfo;
        this.renderingHelper = renderingHelper;
        this.reportConfig = report;
        this.velocity = velocity;
        this.database = database;
        this.fullModel = fullModel;
        this.charts = charts;
    }

    public static void initThreadLocals() {
        columnsTL = new ThreadLocal();
        contextSetTL = new ThreadLocal();
    }

    public static void resetThreadLocals() {
        columnsTL = null;
        contextSetTL = null;
    }

    public Object call() throws Exception {
        if (columnsTL.get() == null) {
            columnsTL.set(this.reportConfig.getColumns().getMethodColumnsCopy());
        }
        if (contextSetTL.get() == null) {
            contextSetTL.set(this.database.getContextSet(this.reportConfig.getFormat().getFilter()));
        }
        HtmlReportUtil.addColumnsToContext(this.velocity, columnsTL.get(), this.fileInfo, this.fileInfo.getClasses());
        this.render();
        return null;
    }

    public void render() throws Exception {
        String srcname = this.fileInfo.getName();
        String basename = new File(srcname).getName();
        String outname = RenderFileAction.createOutFileName(basename);
        File outfile = CloverUtils.createOutFile(this.fileInfo, outname, this.reportConfig.getOutFile());
        String jsonOutFilename = String.valueOf(RenderFileAction.createOutFileBaseName(basename)) + "js";
        this.velocity.put("basename", basename);
        this.velocity.put("currentPageURL", outname);
        this.velocity.put("jsonFilename", jsonOutFilename);
        this.velocity.put("showLambdaFunctions", this.reportConfig.isShowLambdaFunctions());
        this.velocity.put("showInnerFunctions", this.reportConfig.isShowInnerFunctions());
        this.velocity.put("entityUtils", new EntityVisitorUtils());
        this.velocity.put("packageName", this.fileInfo.getContainingPackage().getName());
        try {
            this.insertLineInfos(this.insertSrcFileProperties(), this.testLineInfo);
        }
        catch (Exception e) {
            Logger.getInstance().error("Invalid Java source found or Clover failed to parse it: " + this.fileInfo.getPhysicalFile().getAbsolutePath());
            this.velocity.put("filename", this.fileInfo.getPhysicalFile().getAbsolutePath());
            this.velocity.put("message", e.getMessage());
            List<String> srclines = SourceRenderHelper.getSrcLines(this.fileInfo);
            this.velocity.put("srclines", srclines);
            HtmlReportUtil.mergeTemplateToFile(outfile, this.velocity, "src-file-error.vm");
            return;
        }
        this.velocity.put("chartInfo", CloverChartFactory.getChartForFile(this.fileInfo, this.charts));
        HtmlReportUtil.mergeTemplateToFile(outfile, this.velocity, "src-file.vm");
        HtmlReportUtil.mergeTemplateToFile(CloverUtils.createOutFile(this.fileInfo, jsonOutFilename, this.reportConfig.getOutFile()), this.velocity, "src-file-json.vm");
    }

    public FullFileInfo insertSrcFileProperties() throws JSONException {
        this.velocity.put("headerMetrics", this.fileInfo.getMetrics());
        this.velocity.put("headerMetricsRaw", this.fileInfo.getRawMetrics());
        this.velocity.put("fileInfo", this.fileInfo);
        FullProjectInfo projInfo = this.fullModel;
        this.velocity.put("projInfo", projInfo);
        this.velocity.put("cloverDb", this.database);
        HtmlReportUtil.addFilteredPercentageToContext(this.velocity, this.fileInfo);
        final HashMap<TestCaseInfo, BitSet> targetMethods = Maps.newHashMap();
        final HashMap<TestCaseInfo, BitSet> targetElements = Maps.newHashMap();
        HashMap testMetrics = Maps.newHashMap();
        Set<TestCaseInfo> testHits = this.database.getTestHits(this.fileInfo);
        FullFileInfo fcopy = this.fileInfo.copy((FullPackageInfo)this.fileInfo.getContainingPackage(), HasMetricsFilter.ACCEPT_ALL);
        HashSet<TestCaseInfo> testSet = Sets.newHashSet();
        final List[] testLineInfo = new ArrayList[fcopy.getLineCount() + 1];
        for (final TestCaseInfo tci : testHits) {
            testSet.clear();
            testSet.add(tci);
            CoverageData data = this.database.getCoverageData();
            fcopy.setDataProvider(new BitSetCoverageProvider(data.getHitsFor(testSet, fcopy), data));
            testMetrics.put(tci, fcopy.getMetrics());
            fcopy.visitElements(new FileElementVisitor(){

                @Override
                public void visitClass(ClassInfo info) {
                }

                @Override
                public void visitMethod(MethodInfo info) {
                    if (info.getHitCount() > 0) {
                        this.updateTestLineInfo(info);
                        BitSet set = (BitSet)targetMethods.get(tci);
                        if (set == null) {
                            set = new BitSet();
                            targetMethods.put(tci, set);
                        }
                        set.set(info.getStartLine());
                    }
                }

                @Override
                public void visitStatement(StatementInfo info) {
                    this.visitNode(info);
                }

                @Override
                public void visitBranch(BranchInfo info) {
                    this.visitNode(info);
                }

                private void visitNode(ElementInfo info) {
                    if (info.getHitCount() > 0) {
                        this.updateTestLineInfo(info);
                        BitSet set = (BitSet)targetElements.get(tci);
                        if (set == null) {
                            set = new BitSet();
                            targetElements.put(tci, set);
                        }
                        set.set(info.getStartLine());
                    }
                }

                private void updateTestLineInfo(SourceInfo r) {
                    int sl = r.getStartLine();
                    ArrayList tests = testLineInfo[sl];
                    if (tests == null) {
                        testLineInfo[sl] = tests = Lists.newArrayList();
                    }
                    if (!this.isSetForThisTest(targetElements, sl) && !this.isSetForThisTest(targetMethods, sl)) {
                        tests.add(tci);
                    }
                }

                private boolean isSetForThisTest(Map<TestCaseInfo, BitSet> m, int i) {
                    BitSet bsc = m.get(tci);
                    return bsc != null && bsc.get(i);
                }
            });
        }
        this.testLineInfo = testLineInfo;
        LinkedHashMap<TestCaseInfo, BlockMetrics> orderedTestMetrics = new LinkedHashMap<TestCaseInfo, BlockMetrics>(testMetrics.size());
        LinkedList testMetricList = Lists.newLinkedList(testMetrics.entrySet());
        Collections.sort(testMetricList, TEST_METRICS_COMPARATOR);
        List sublist = this.reportConfig.getMaxTestsPerFile() >= 0 && !testMetricList.isEmpty() && testMetricList.size() > this.reportConfig.getMaxTestsPerFile() ? testMetricList.subList(0, this.reportConfig.getMaxTestsPerFile()) : testMetricList;
        for (Map.Entry entry : sublist) {
            orderedTestMetrics.put((TestCaseInfo)entry.getKey(), (BlockMetrics)entry.getValue());
        }
        this.velocity.put("testMetrics", orderedTestMetrics);
        this.velocity.put("numTargetMethods", targetMethods.size());
        this.velocity.put("testsPerFile", this.reportConfig.getMaxTestsPerFile());
        this.velocity.put("jsonTestTargets", JSONObjectFactory.getJSONTestTargets(targetMethods, targetElements));
        this.velocity.put("jsonPageData", JSONObjectFactory.getJSONPageData(this.fileInfo));
        if (sublist.size() < testMetricList.size()) {
            this.velocity.put("numTestsHidden", testMetricList.size() - sublist.size());
        }
        return fcopy;
    }

    private void insertLineInfos(FullFileInfo fcopy, List[] testLineInfo) throws TokenStreamException {
        new SourceRenderHelper(this.database, this.reportConfig, this.renderingHelper).insertLineInfosForFile(fcopy, this.velocity, this.getContextSet(), "&#160;", testLineInfo);
    }

    protected ContextSet getContextSet() {
        return contextSetTL.get();
    }

    static String createOutFileName(String basename) {
        return String.valueOf(RenderFileAction.createOutFileBaseName(basename)) + "html";
    }

    protected static String createOutFileBaseName(String basename) {
        return basename.substring(0, basename.lastIndexOf(".") + 1);
    }
}

