/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.filters;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.BaseInvertableFilter;
import com.atlassian.clover.registry.entities.FullFileInfo;
import java.util.List;

public class FileSetFilter
extends BaseInvertableFilter {
    private List sourceFiles;

    public FileSetFilter(List sourceFiles) {
        this(sourceFiles, false);
    }

    FileSetFilter(List sourceFiles, boolean inverted) {
        super(inverted);
        this.sourceFiles = sourceFiles;
    }

    @Override
    public FileSetFilter invert() {
        return new FileSetFilter(this.sourceFiles, !this.isInverted());
    }

    @Override
    public boolean accept(HasMetrics hm) {
        if (hm instanceof FullFileInfo) {
            FullFileInfo fileInfo = (FullFileInfo)hm;
            return this.isInverted() ^ this.sourceFiles.contains(fileInfo.getPhysicalFile());
        }
        return true;
    }
}

