/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.console;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.command.ArgProcessor;
import com.atlassian.clover.api.command.HelpBuilder;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.LineInfo;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.registry.metrics.ProjectMetrics;
import com.atlassian.clover.reporters.CloverReporter;
import com.atlassian.clover.reporters.CommandLineArgProcessors;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.console.ConsoleReporterArgProcessors;
import com.atlassian.clover.reporters.console.ConsoleReporterConfig;
import com.atlassian.clover.util.Color;
import com.atlassian.clover.util.Formatting;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openclover.util.Lists;

public class ConsoleReporter
extends CloverReporter {
    private static final List<ArgProcessor<Current>> mandatoryArgProcessors = Collections.singletonList(CommandLineArgProcessors.InitString);
    private static final List<ArgProcessor<Current>> optionalArgProcessors = Lists.newArrayList(ConsoleReporterArgProcessors.CodeTypes, ConsoleReporterArgProcessors.Level, CommandLineArgProcessors.SourcePath, CommandLineArgProcessors.Span, CommandLineArgProcessors.ShowInnerFunctions, CommandLineArgProcessors.ShowLambdaFunctions, CommandLineArgProcessors.Title, ConsoleReporterArgProcessors.UnitTests);
    private static final List<ArgProcessor<Current>> allArgProcessors = Lists.join(mandatoryArgProcessors, optionalArgProcessors);
    private static final Logger LOG = Logger.getInstance();
    private final ConsoleReporterConfig cfg;

    public ConsoleReporter(ConsoleReporterConfig cfg) throws CloverException {
        super(cfg.getCoverageDatabase(), cfg);
        this.cfg = cfg;
    }

    public void report(PrintWriter out, CloverDatabase db) {
        out.print("Clover Coverage Report");
        if (this.cfg.getTitle() != null) {
            out.println(" - " + this.cfg.getTitle());
        } else {
            out.println();
        }
        out.println("Coverage Timestamp: " + new Date(db.getRecordingTimestamp()));
        out.println("Report for code   : " + (Object)((Object)this.cfg.getCodeType()));
        List<? extends PackageInfo> packages = db.getModel(this.cfg.getCodeType()).getAllPackages();
        if (this.cfg.getLevel().isShowPackages()) {
            out.println();
            out.println("Package Summary - ");
        }
        for (PackageInfo packageInfo : packages) {
            FullPackageInfo pkg = (FullPackageInfo)packageInfo;
            if (this.cfg.getPackageSet() != null && !this.cfg.getPackageSet().contains(pkg.getName())) continue;
            if (this.cfg.getLevel().isShowPackages()) {
                out.println(String.valueOf(pkg.getName()) + ": " + Formatting.getPercentStr(pkg.getMetrics().getPcCoveredElements()));
            }
            List<? extends FileInfo> fileInfos = pkg.getFiles();
            for (FileInfo fileInfo : fileInfos) {
                LineInfo[] lines;
                FullFileInfo fInfo = (FullFileInfo)fileInfo;
                if (this.cfg.getLevel().isShowClasses()) {
                    out.println("---------------------------------------");
                    out.println("File: " + fInfo.getPackagePath());
                    List<? extends ClassInfo> classes = fInfo.getClasses();
                    for (ClassInfo classInfo : classes) {
                        ClassMetrics metrics = (ClassMetrics)classInfo.getMetrics();
                        out.println("Package: " + classInfo.getPackage().getName());
                        ConsoleReporter.printMetricsSummary(out, "Class: " + classInfo.getName(), metrics, this.cfg);
                    }
                }
                if (!this.cfg.getLevel().isShowMethods() && !this.cfg.getLevel().isShowStatements()) continue;
                LineInfo[] lineInfoArray = lines = fInfo.getLineInfo(this.cfg.isShowLambdaFunctions(), this.cfg.isShowInnerFunctions());
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    LineInfo lineInfo = lineInfoArray[n2];
                    if (lineInfo != null) {
                        if (this.cfg.getLevel().isShowMethods()) {
                            this.reportMethodsForLine(out, fInfo, lineInfo);
                        }
                        if (this.cfg.getLevel().isShowStatements()) {
                            this.reportStatementsForLine(out, fInfo, lineInfo);
                            this.reportBranchesForLine(out, fInfo, lineInfo);
                        }
                    }
                    ++n2;
                }
            }
        }
        out.println();
        out.println();
        ProjectMetrics projectMetrics = (ProjectMetrics)db.getModel(this.cfg.getCodeType()).getMetrics();
        ConsoleReporter.printMetricsSummary(out, "Coverage Overview -", projectMetrics, this.cfg);
        out.flush();
    }

    protected void reportMethodsForLine(PrintWriter out, FullFileInfo fInfo, LineInfo info) {
        FullMethodInfo[] starts = info.getMethodStarts();
        if (starts.length > 0) {
            FullMethodInfo[] fullMethodInfoArray = starts;
            int n = starts.length;
            int n2 = 0;
            while (n2 < n) {
                FullMethodInfo start = fullMethodInfoArray[n2];
                if (start.getHitCount() == 0) {
                    out.println(String.valueOf(fInfo.getPhysicalFile().getAbsolutePath()) + ":" + start.getStartLine() + ":" + start.getStartColumn() + ":" + start.getSimpleName() + ": method not entered.");
                }
                ++n2;
            }
        }
    }

    protected void reportStatementsForLine(PrintWriter out, FullFileInfo fInfo, LineInfo info) {
        FullStatementInfo[] stmts = info.getStatements();
        if (stmts.length > 0) {
            FullStatementInfo[] fullStatementInfoArray = stmts;
            int n = stmts.length;
            int n2 = 0;
            while (n2 < n) {
                FullStatementInfo stmt = fullStatementInfoArray[n2];
                if (stmt.getHitCount() == 0) {
                    out.println(String.valueOf(fInfo.getPhysicalFile().getAbsolutePath()) + ":" + stmt.getStartLine() + ":" + stmt.getStartColumn() + ": statement not executed.");
                }
                ++n2;
            }
        }
    }

    protected void reportBranchesForLine(PrintWriter out, FullFileInfo fInfo, LineInfo info) {
        FullBranchInfo[] branches = info.getBranches();
        if (branches.length > 0) {
            FullBranchInfo[] fullBranchInfoArray = branches;
            int n = branches.length;
            int n2 = 0;
            while (n2 < n) {
                FullBranchInfo branch = fullBranchInfoArray[n2];
                String prefix = String.valueOf(fInfo.getPhysicalFile().getAbsolutePath()) + ":" + branch.getStartLine() + ":" + branch.getStartColumn() + ": ";
                if (!branch.isInstrumented()) {
                    out.println(String.valueOf(prefix) + "was not instumented, due to assignment in expression.");
                } else if (branch.getTrueHitCount() == 0 && branch.getFalseHitCount() == 0) {
                    out.println(String.valueOf(prefix) + "branch not evaluated.");
                } else if (branch.getTrueHitCount() == 0) {
                    out.println(String.valueOf(prefix) + "true branch never taken.");
                } else if (branch.getFalseHitCount() == 0) {
                    out.println(String.valueOf(prefix) + "false branch never taken.");
                }
                ++n2;
            }
        }
    }

    @Override
    protected void validate() throws CloverException {
        super.validate();
    }

    static void printMetricsSummary(PrintWriter out, String title, ClassMetrics metrics, ConsoleReporterConfig cfg) {
        out.println(title);
        out.println("Coverage:-");
        String methodSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredMethods(), metrics.getNumMethods(), metrics.getPcCoveredMethods());
        String stmtSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredStatements(), metrics.getNumStatements(), metrics.getPcCoveredStatements());
        String branchSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredBranches(), metrics.getNumBranches(), metrics.getPcCoveredBranches());
        String totalSummary = Color.make(Formatting.getPercentStr(metrics.getPcCoveredElements())).b().toString();
        out.print("      Methods: " + methodSummary);
        ConsoleReporter.printPcBar(out, methodSummary, metrics.getPcCoveredMethods());
        out.print("   Statements: " + stmtSummary);
        ConsoleReporter.printPcBar(out, stmtSummary, metrics.getPcCoveredStatements());
        out.print("     Branches: " + branchSummary);
        ConsoleReporter.printPcBar(out, branchSummary, metrics.getPcCoveredBranches());
        out.print("        Total: " + totalSummary);
        ConsoleReporter.printPcBar(out, totalSummary, metrics.getPcCoveredElements());
        out.println("Complexity:-");
        out.println("   Avg Method: " + Formatting.format3d(metrics.getAvgMethodComplexity()));
        out.println("      Density: " + Formatting.format3d(metrics.getComplexityDensity()));
        out.println("        Total: " + metrics.getComplexity());
        if (cfg != null && cfg.isShowUnitTests()) {
            out.println("Tests:-");
            out.println("    Available: " + metrics.getNumTests());
            out.println("     Executed: " + metrics.getNumTestsRun());
            out.println("       Passed: " + metrics.getNumTestPasses());
            out.println("       Failed: " + metrics.getNumTestFailures());
            out.println("       Errors: " + metrics.getNumTestErrors());
        }
    }

    private static void printPcBar(PrintWriter out, String summary, float amt) {
        int padLen = 32 - summary.length();
        out.print(String.format("%" + padLen + "s", " "));
        int pc = (int)(amt * 80.0f);
        int i = 0;
        while (i <= 80) {
            if (i < pc) {
                out.print(Color.make(" ").bg().green());
            } else {
                out.print(Color.make(" ").bg().red());
            }
            ++i;
        }
        out.println();
    }

    private static String infoSummaryString(int covered, int total, float percent) {
        StringBuilder buf = new StringBuilder();
        buf.append(covered).append("/").append(total);
        buf.append(" (").append(Color.make(Formatting.getPercentStr(percent)).b()).append(")");
        return buf.toString();
    }

    public static void main(String[] args) {
        ConsoleReporter.loadLicense();
        System.exit(ConsoleReporter.runReport(args));
    }

    public static int runReport(String[] args) {
        ConsoleReporterConfig config = ConsoleReporter.processArgs(args);
        if (ConsoleReporter.canProceedWithReporting(config)) {
            try {
                return new ConsoleReporter(config).execute();
            }
            catch (Exception e) {
                Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    public static ConsoleReporterConfig processArgs(String[] args) {
        ConsoleReporterConfig cfg = new ConsoleReporterConfig();
        cfg.setFormat(Format.DEFAULT_TEXT);
        try {
            int i = 0;
            while (i < args.length) {
                for (ArgProcessor<Current> argProcessor : allArgProcessors) {
                    if (!argProcessor.matches(args, i)) continue;
                    i = argProcessor.process(args, i, cfg);
                }
                ++i;
            }
            if (!cfg.validate()) {
                ConsoleReporter.usage(cfg.getValidationFailureReason());
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ConsoleReporter.usage("Missing a parameter.");
            return null;
        }
        return cfg;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println(HelpBuilder.buildHelp(ConsoleReporter.class, mandatoryArgProcessors, optionalArgProcessors));
        System.err.println();
    }

    @Override
    protected int executeImpl() {
        this.report(new PrintWriter(System.out), this.database);
        return 0;
    }
}

