/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.reporters.ColumnFormat;

public abstract class Column {
    protected ColumnFormat formatter;
    private String format;
    private String scope;
    protected ColumnData data;
    private float min = Float.NEGATIVE_INFINITY;
    private float max = Float.POSITIVE_INFINITY;
    static final String ALERT_STYLE = "thresholdAlert";

    public Column() {
    }

    public Column(Column col) {
        if (col.format != null) {
            this.setFormat(col.format);
        }
        this.setMin(col.min);
        this.setMax(col.max);
        this.scope = col.scope;
    }

    public abstract Column copy();

    public void setFormat(String format) {
        this.formatter = ColumnFormat.Factory.createFormat(format);
        this.format = format;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public String getStyle() {
        return this.formatter.isWithinThreshold(this.data, this.min, this.max) ? "" : ALERT_STYLE;
    }

    public ColumnFormat getFormat() {
        return this.formatter;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public void setCustomClass(String customClass) {
        this.data.setCustomClass(customClass);
    }

    public String render() {
        return this.formatter.format(this.data);
    }

    public Number getNumber() {
        return this.formatter.formatNumber(this.data);
    }

    public ColumnData getColumnData() {
        return this.data;
    }

    public String sortValue() {
        return this.formatter.sortValue(this.data);
    }

    public abstract void init(BlockMetrics var1) throws CloverException;

    public void reset() {
        this.data = null;
    }

    public String getName() {
        String[] className = this.getClass().getName().split("\\$");
        return className[className.length - 1];
    }

    public abstract String getTitle(BlockMetrics var1);

    public String getTitle() {
        return this.getTitle(null);
    }

    public String getHelp() {
        return null;
    }

    public static class ColumnData {
        private float value;
        private String customClass = "";

        protected ColumnData(float value) {
            this.value = value;
        }

        public float getValue() {
            return this.value;
        }

        public String getCustomClass() {
            return this.customClass;
        }

        public void setCustomClass(String customClass) {
            this.customClass = customClass;
        }
    }

    public static class PcColumnData
    extends ColumnData {
        private float pcValue;
        private boolean empty;
        private String customPositiveClass = "";
        private String customNegativeClass = "";

        public PcColumnData(int value, boolean empty) {
            super(value);
            this.empty = empty;
        }

        public PcColumnData(int value, float pcValue) {
            super(value);
            this.pcValue = pcValue;
            this.empty = pcValue < 0.0f;
        }

        public PcColumnData(int value, float pcValue, boolean empty) {
            super(value);
            this.pcValue = pcValue;
            this.empty = empty;
        }

        public float getPcValue() {
            return this.pcValue;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public String getCustomPositiveClass() {
            return this.customPositiveClass;
        }

        public String getCustomNegativeClass() {
            return this.customNegativeClass;
        }

        public void setCustomPositiveClass(String className) {
            this.customPositiveClass = className;
        }

        public void setCustomNegativeClass(String className) {
            this.customNegativeClass = className;
        }
    }
}

