/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.api.instrumentation.ConcurrentInstrumentationException;
import com.atlassian.clover.api.registry.CloverRegistryException;
import com.atlassian.clover.registry.NoSuchRegistryException;
import com.atlassian.clover.registry.ReadOnlyRegistryException;
import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.registry.format.InaccessibleRegFileException;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.atlassian.clover.registry.format.RegContents;
import com.atlassian.clover.registry.format.RegContentsConsumer;
import com.atlassian.clover.registry.format.RegFile;
import com.atlassian.clover.registry.format.RegHeader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import org.openclover.util.Lists;

public class UpdatableRegFile
extends RegFile<UpdatableRegFile> {
    private final RegHeader header;

    public UpdatableRegFile(File file) throws IOException, NoSuchRegistryException, InaccessibleRegFileException, RegistryFormatException {
        this(UpdatableRegFile.ensureFileAccessible(file), RegHeader.readFrom(file));
    }

    UpdatableRegFile(File file, RegHeader header) throws NoSuchRegistryException, InaccessibleRegFileException {
        super(UpdatableRegFile.ensureFileAccessible(file));
        this.header = header;
    }

    private long calcMinSessionPosition() {
        return this.header.getCoverageLocation() == -1L ? 308L : this.header.getCoverageLocation();
    }

    public RegHeader getHeader() {
        return this.header;
    }

    private RegContents startReading() throws IOException {
        return new RegContents(new RandomAccessFile(this.getFile(), "r"), this.header.getCoverageLocation(), this.header.getLastSessionLocation(), this.calcMinSessionPosition());
    }

    public void readContents(RegContentsConsumer consumer) throws IOException, CloverRegistryException {
        try (RegContents contents = this.startReading();){
            consumer.consume(contents);
        }
    }

    @Override
    public UpdatableRegFile saveImpl(List<? extends RegistryUpdate> deltas) throws IOException, CloverRegistryException {
        if (deltas.size() == 0) {
            throw new IllegalArgumentException("At least one registry update is required");
        }
        if (this.header.getAccessMode() == RegAccessMode.READONLY) {
            throw new ReadOnlyRegistryException();
        }
        File registryFile = this.getFile();
        Throwable throwable = null;
        Object var4_5 = null;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(registryFile, "rw");){
            FileChannel channel = randomAccessFile.getChannel();
            LinkedList sessions = Lists.newLinkedList();
            RegHeader currentHeader = RegHeader.readFrom(this.getFile().getAbsolutePath(), channel);
            if (currentHeader.getVersion() != this.header.getVersion()) {
                throw new ConcurrentInstrumentationException("The on-disk registry version (" + currentHeader.getVersion() + ") differs from the in-memory version (" + this.header.getVersion() + ")");
            }
            int maxSlotLength = this.header.getSlotCount();
            long latestVersion = System.currentTimeMillis();
            channel.position(this.header.getLastSessionLocation() + 1L);
            for (RegistryUpdate registryUpdate : deltas) {
                latestVersion = registryUpdate.getVersion();
                maxSlotLength = Math.max(maxSlotLength, registryUpdate.getSlotCount());
                InstrSessionSegment session = new InstrSessionSegment(registryUpdate.getVersion(), registryUpdate.getStartTs(), registryUpdate.getEndTs(), this.toRecords(registryUpdate.getFileInfos()), registryUpdate.getContextStore());
                session.write(channel);
                sessions.add(session);
            }
            RegHeader regHeader = new RegHeader(this.header.getAccessMode(), latestVersion, maxSlotLength, this.header.getCoverageLocation(), channel.position() - 1L, this.getName());
            channel.position(0L);
            regHeader.write(channel);
            registryFile.setLastModified(latestVersion);
            return new UpdatableRegFile(this.getFile(), regHeader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getName() {
        return this.header.getName();
    }

    public long getVersion() {
        return this.header.getVersion();
    }

    @Override
    public RegAccessMode getAccessMode() {
        return this.header.getAccessMode();
    }

    public int getSlotCount() {
        return this.header.getSlotCount();
    }

    private static File ensureFileAccessible(File file) throws NoSuchRegistryException, InaccessibleRegFileException {
        File absFile = file.getAbsoluteFile();
        if (!absFile.exists()) {
            throw new NoSuchRegistryException("Clover registry file: ${file} does not exist. Please ensure Clover has instrumented your source files. You may need to remove existing .class files for this to occur.", absFile);
        }
        if (!absFile.isFile()) {
            throw new InaccessibleRegFileException("Clover registry file: " + absFile.getAbsolutePath() + " is not a file.");
        }
        if (!absFile.canRead()) {
            throw new InaccessibleRegFileException("Clover registry file: " + absFile.getAbsolutePath() + " can not be read by Clover. Please ensure read/write access is granted to this file.");
        }
        return absFile;
    }

    @Override
    public boolean isAppendable() {
        try {
            return RegHeader.readFrom(this.getFile()).getVersion() == this.header.getVersion();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

