/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.api.registry.CloverRegistryException;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.format.FileInfoRecord;
import com.atlassian.clover.registry.format.RegAccessMode;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openclover.util.Lists;

public abstract class RegFile<CDR extends RegFile> {
    private final File file;
    private final AtomicBoolean saved = new AtomicBoolean(false);

    public RegFile(File file) {
        this.file = file;
    }

    public final CDR save(List<? extends RegistryUpdate> deltas) throws IOException, CloverRegistryException {
        if (!this.saved.getAndSet(true)) {
            return this.saveImpl(deltas);
        }
        throw new IllegalStateException("Registry file already committed to disk");
    }

    public final CDR save(RegistryUpdate delta) throws IOException, CloverRegistryException {
        return this.save(Collections.singletonList(delta));
    }

    protected abstract CDR saveImpl(List<? extends RegistryUpdate> var1) throws IOException, CloverRegistryException;

    public abstract String getName();

    public File getFile() {
        return this.file;
    }

    protected List<FileInfoRecord> toRecords(Iterable<FullFileInfo> fileInfos) {
        LinkedList<FileInfoRecord> recs = Lists.newLinkedList();
        for (FullFileInfo fileInfo : fileInfos) {
            recs.add(new FileInfoRecord(fileInfo));
        }
        return recs;
    }

    public abstract RegAccessMode getAccessMode();

    public abstract boolean isAppendable();
}

