/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsNode;
import com.atlassian.clover.registry.metrics.PackageMetrics;
import com.atlassian.clover.registry.metrics.ProjectMetrics;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class PackageFragment
implements HasMetricsNode {
    private FullProjectInfo containingProject;
    private PackageFragment parent;
    private List orderedKids;
    private Map<String, PackageFragment> children;
    private BlockMetrics rawMetrics;
    private BlockMetrics metrics;
    private FullPackageInfo concretePackage;
    private String qualifiedName;
    private String name;
    private Comparator orderby;

    public PackageFragment(PackageFragment parent, FullProjectInfo containingProject, String fqn, String name) {
        this.parent = parent;
        this.containingProject = containingProject;
        this.qualifiedName = fqn;
        this.name = name;
    }

    void addChild(PackageFragment pkg) {
        if (this.children == null) {
            this.children = Maps.newTreeMap();
        }
        this.children.put(pkg.getName(), pkg);
    }

    public PackageFragment[] getChildren() {
        if (this.children != null) {
            return this.children.values().toArray(new PackageFragment[0]);
        }
        return new PackageFragment[0];
    }

    public FullPackageInfo getConcretePackage() {
        return this.concretePackage;
    }

    public void setConcretePackage(FullPackageInfo concretePackage) {
        this.concretePackage = concretePackage;
    }

    public boolean isConcrete() {
        return this.concretePackage != null;
    }

    public PackageFragment getParent() {
        return this.parent;
    }

    public FullProjectInfo getContainingProject() {
        return this.containingProject;
    }

    public String getQualifiedName() {
        return this.isConcrete() ? this.concretePackage.getName() : this.qualifiedName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return !(this.children != null && this.children.size() != 0 || this.concretePackage != null && !this.concretePackage.isEmpty());
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    @Override
    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public PackageFragment getChild(String name) {
        if (this.children != null) {
            return this.children.get(name);
        }
        return null;
    }

    @Override
    public String getChildType() {
        return this.isConcrete() ? this.concretePackage.getChildType() : "package";
    }

    @Override
    public int getNumChildren() {
        int kids = 0;
        if (this.children != null) {
            if (this.orderedKids == null) {
                this.buildOrderedChildList();
            }
            kids += this.orderedKids.size();
        }
        if (this.isConcrete()) {
            kids += this.concretePackage.getNumChildren();
        }
        return kids;
    }

    @Override
    public HasMetricsNode getChild(int i) {
        int offset = 0;
        if (this.children != null) {
            if (this.orderedKids == null) {
                this.buildOrderedChildList();
            }
            if (i < this.orderedKids.size()) {
                return (HasMetricsNode)this.orderedKids.get(i);
            }
            offset = this.orderedKids.size();
        }
        if (this.isConcrete()) {
            return this.concretePackage.getChild(i - offset);
        }
        return null;
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        if (child instanceof PackageFragment && this.children != null) {
            if (this.orderedKids == null) {
                this.buildOrderedChildList();
            }
            return this.orderedKids.indexOf(child);
        }
        if (child instanceof ClassInfo && this.isConcrete()) {
            return this.concretePackage.getIndexOfChild(child);
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.orderedKids = null;
    }

    private void buildOrderedChildList() {
        this.orderedKids = Lists.newArrayList(this.children.values());
        if (this.orderby != null) {
            Collections.sort(this.orderedKids, this.orderby);
        }
    }

    private ProjectMetrics calcMetrics(boolean filter) {
        ProjectMetrics metrics = new ProjectMetrics(this);
        if (this.isConcrete()) {
            if (!filter) {
                metrics.add((PackageMetrics)this.concretePackage.getRawMetrics());
            } else {
                metrics.add((PackageMetrics)this.concretePackage.getMetrics());
            }
            metrics.setNumPackages(1);
        }
        if (this.children != null) {
            for (PackageFragment pkgFrag : this.children.values()) {
                if (!filter) {
                    metrics.add((ProjectMetrics)pkgFrag.getRawMetrics());
                    continue;
                }
                metrics.add((ProjectMetrics)pkgFrag.getMetrics());
            }
        }
        return metrics;
    }
}

