/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.api.registry.ProjectInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.registry.CachingInfo;
import com.atlassian.clover.registry.FileInfoVisitor;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Lists;

public class BaseProjectInfo
implements ProjectInfo,
CachingInfo {
    protected String name;
    protected Map<String, BasePackageInfo> packages;
    protected long version;
    protected Map<String, BaseClassInfo> classLookup;
    protected Map<String, BaseFileInfo> fileLookup;
    protected BlockMetrics rawMetrics;
    protected BlockMetrics metrics;
    protected ContextSet contextFilter;

    public BaseProjectInfo(String name, long version) {
        this.name = name;
        this.version = version;
        this.packages = new LinkedHashMap<String, BasePackageInfo>();
    }

    public BaseProjectInfo(String name) {
        this(name, System.currentTimeMillis());
    }

    @Override
    @NotNull
    public List<? extends PackageInfo> getAllPackages() {
        return Lists.newArrayList(this.packages.values());
    }

    public void addPackage(BasePackageInfo pkg) {
        this.packages.put(pkg.getName(), pkg);
    }

    public BasePackageInfo getDefaultPackage() {
        return this.packages.get("default-pkg");
    }

    public BasePackageInfo getNamedPackage(String name) {
        if (name == null || name.length() == 0 || "default-pkg".equals(name)) {
            return this.getDefaultPackage();
        }
        return this.packages.get(name);
    }

    @Override
    public PackageInfo findPackage(String name) {
        throw new UnsupportedOperationException("Use FullProjectInfo");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEmpty() {
        return this.packages.isEmpty();
    }

    @Override
    public ClassInfo findClass(String fqcn) {
        if (this.classLookup == null) {
            this.buildClassLookupMap();
        }
        return this.classLookup.get(fqcn);
    }

    @Override
    public FileInfo findFile(String pkgPath) {
        if (this.fileLookup == null) {
            this.buildFileLookupMap();
        }
        return this.fileLookup.get(pkgPath);
    }

    public List<? extends BaseClassInfo> getClasses(HasMetricsFilter filter) {
        if (this.classLookup == null) {
            this.buildClassLookupMap();
        }
        ArrayList result = Lists.newArrayList();
        for (BaseClassInfo classInfo : this.classLookup.values()) {
            if (!filter.accept(classInfo)) continue;
            result.add(classInfo);
        }
        return result;
    }

    public List getFiles(HasMetricsFilter filter) {
        if (this.fileLookup == null) {
            this.buildFileLookupMap();
        }
        ArrayList result = Lists.newArrayList();
        for (BaseFileInfo fileInfo : this.fileLookup.values()) {
            if (!filter.accept(fileInfo)) continue;
            result.add(fileInfo);
        }
        return result;
    }

    public List<BasePackageInfo> getPackages(HasMetricsFilter filter) {
        ArrayList<BasePackageInfo> result = Lists.newArrayList();
        for (BasePackageInfo packageInfo : this.packages.values()) {
            if (!filter.accept(packageInfo)) continue;
            result.add(packageInfo);
        }
        return result;
    }

    private void buildClassLookupMap() {
        final LinkedHashMap<String, BaseClassInfo> tmpClassLookup = new LinkedHashMap<String, BaseClassInfo>();
        this.visitFiles(new FileInfoVisitor(){

            @Override
            public void visitFileInfo(BaseFileInfo file) {
                for (ClassInfo classInfo : file.getClasses()) {
                    BaseClassInfo info = (BaseClassInfo)classInfo;
                    tmpClassLookup.put(info.getQualifiedName(), info);
                }
            }
        });
        this.classLookup = tmpClassLookup;
    }

    private void buildFileLookupMap() {
        final LinkedHashMap<String, BaseFileInfo> tmpFileLookup = new LinkedHashMap<String, BaseFileInfo>();
        this.visitFiles(new FileInfoVisitor(){

            @Override
            public void visitFileInfo(BaseFileInfo file) {
                tmpFileLookup.put(file.getPackagePath(), file);
            }
        });
        this.fileLookup = tmpFileLookup;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    @Override
    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public ContextSet getContextFilter() {
        return this.contextFilter;
    }

    public void setContextFilter(ContextSet filter) {
        this.contextFilter = filter;
        this.metrics = null;
    }

    @Override
    public void visit(EntityVisitor entityVisitor) {
        entityVisitor.visitProject(this);
    }

    public void visitFiles(FileInfoVisitor visitor) {
        for (BasePackageInfo pkgInfo : this.packages.values()) {
            pkgInfo.visitFiles(visitor);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void invalidateCaches() {
        this.classLookup = null;
        this.fileLookup = null;
        this.rawMetrics = null;
        this.metrics = null;
    }
}

