/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry;

import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import java.util.List;

public class FullProjectUpdate
implements RegistryUpdate {
    private final FullProjectInfo proj;
    private final ContextStore ctxStore;
    private final long startTs;
    private final long endTs;

    public FullProjectUpdate(FullProjectInfo proj, ContextStore ctxStore, long startTs, long endTs) {
        this.proj = proj;
        this.ctxStore = ctxStore;
        this.startTs = startTs;
        this.endTs = endTs;
    }

    @Override
    public long getVersion() {
        return this.proj.getVersion();
    }

    @Override
    public long getStartTs() {
        return this.startTs;
    }

    @Override
    public long getEndTs() {
        return this.endTs;
    }

    @Override
    public int getSlotCount() {
        return this.proj.getDataLength();
    }

    @Override
    public List<FullFileInfo> getFileInfos() {
        return this.proj.getFiles(HasMetricsFilter.ACCEPT_ALL);
    }

    @Override
    public ContextStore getContextStore() {
        return this.ctxStore;
    }
}

