/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry;

import com.atlassian.clover.CoverageData;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ProgressListener;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.instrumentation.ConcurrentInstrumentationException;
import com.atlassian.clover.api.instrumentation.InstrumentationSession;
import com.atlassian.clover.api.registry.CloverRegistryException;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.instr.InstrumentationSessionImpl;
import com.atlassian.clover.registry.CorruptedRegistryException;
import com.atlassian.clover.registry.EmptyProjectUpdate;
import com.atlassian.clover.registry.FullProjectUpdate;
import com.atlassian.clover.registry.InstrumentationTarget;
import com.atlassian.clover.registry.NoSuchRegistryException;
import com.atlassian.clover.registry.ProjectView;
import com.atlassian.clover.registry.RegistryUpdate;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.format.CoverageSegment;
import com.atlassian.clover.registry.format.FileInfoRecord;
import com.atlassian.clover.registry.format.FreshRegFile;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.atlassian.clover.registry.format.RegContents;
import com.atlassian.clover.registry.format.RegContentsConsumer;
import com.atlassian.clover.registry.format.RegFile;
import com.atlassian.clover.registry.format.UpdatableRegFile;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.util.CloverUtils;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class Clover2Registry
implements InstrumentationTarget {
    private final ProjectView.Original model;
    private final LinkedList<InstrumentationInfo> instrumentationHistory;
    private final List<InstrumentationSessionImpl.Update> updatesToSave;
    private volatile RegFile regFile;
    private ContextStore contexts;
    private CoverageData coverageData;

    public Clover2Registry(File regFile, String name) {
        this(regFile, RegAccessMode.READWRITE, name);
    }

    public Clover2Registry(File regFile, RegAccessMode accessMode, String name) {
        this(new FreshRegFile(regFile, accessMode, name), new FullProjectInfo(name), new ArrayList<InstrumentationInfo>(), new ContextStore());
    }

    Clover2Registry(RegFile regFile, FullProjectInfo model, List<InstrumentationInfo> instrumentationHistory, ContextStore contexts) {
        this.regFile = regFile;
        this.model = new ProjectView.Original(model);
        this.instrumentationHistory = Lists.newLinkedList(instrumentationHistory);
        this.contexts = contexts;
        this.updatesToSave = new CopyOnWriteArrayList<InstrumentationSessionImpl.Update>();
    }

    public Clover2Registry copyForBackgroundCoverageLoad() {
        return new Clover2Registry(this.regFile, this.model.getProject().copy(), this.instrumentationHistory, this.contexts);
    }

    public static Clover2Registry fromInitString(String initstring, String name) throws CloverException {
        File regFile = new File(initstring);
        Clover2Registry reg = Clover2Registry.fromFile(regFile);
        if (reg == null) {
            reg = new Clover2Registry(regFile, name);
        }
        return reg;
    }

    public static Clover2Registry fromFile(File registryFile) throws CloverException {
        return Clover2Registry.fromFile(registryFile, null, null);
    }

    public static Clover2Registry fromFile(File registryFile, final HasMetricsFilter filter, ProgressListener progressListener) throws CloverException {
        try {
            final UpdatableRegFile regFile = new UpdatableRegFile(registryFile);
            final LinkedList instrHistory = Lists.newLinkedList();
            final FullProjectInfo projInfo = new FullProjectInfo(regFile.getName(), regFile.getVersion());
            final HashMap fileInfos = Maps.newHashMap();
            final long version = regFile.getVersion();
            final Clover2Registry[] resultReg = new Clover2Registry[1];
            regFile.readContents(new RegContentsConsumer(){

                @Override
                public void consume(RegContents contents) {
                    ContextStore ctxStore = null;
                    for (InstrSessionSegment sessionSegment : contents.getSessions()) {
                        ctxStore = ctxStore == null ? sessionSegment.getCtxStore() : ctxStore;
                        Collection<FileInfoRecord> fileInfoRecs = sessionSegment.getFileInfoRecords();
                        instrHistory.add(new InstrumentationInfo(sessionSegment.getVersion(), sessionSegment.getStartTs(), sessionSegment.getEndTs()));
                        Clover2Registry.buildModel(version, filter, projInfo, fileInfos, sessionSegment, fileInfoRecs);
                    }
                    Clover2Registry.recreateDataIndicesAndLengths(regFile, projInfo);
                    Clover2Registry reg = new Clover2Registry(regFile, projInfo, instrHistory, ctxStore);
                    CoverageSegment coverage = contents.getCoverage();
                    if (coverage != null) {
                        CoverageData covData = new CoverageData(reg.getVersion(), coverage.getHitCounts(), coverage.getPerTestCoverage());
                        reg.setCoverageData(covData);
                        reg.getProject().setDataProvider(covData);
                    }
                    resultReg[0] = reg;
                }
            });
            return resultReg[0];
        }
        catch (IOException | RuntimeException e) {
            Logger.getInstance().debug("Exception reading registry file " + registryFile.getAbsolutePath(), e);
            throw new CorruptedRegistryException(registryFile.getAbsolutePath(), e);
        }
        catch (NoSuchRegistryException noSuchRegistryException) {
            return null;
        }
    }

    private static void buildModel(long version, HasMetricsFilter filter, FullProjectInfo projInfo, Map<String, FullFileInfo> fileInfos, InstrSessionSegment sessionSegment, Collection<FileInfoRecord> fileInfoRecs) {
        class FosterPackageInfo
        extends BasePackageInfo {
            public String fosterName;

            FosterPackageInfo(FullProjectInfo fullProjectInfo) {
                super(fullProjectInfo, "");
            }

            @Override
            public String getName() {
                return this.fosterName;
            }

            @Override
            public String getPath() {
                return CloverUtils.packageNameToPath(this.fosterName, this.isDefault());
            }

            @Override
            public boolean isDefault() {
                return FosterPackageInfo.isDefaultName(this.fosterName);
            }

            public FullFileInfo adopt(String fosterName, FullFileInfo fileInfo) {
                this.fosterName = fosterName;
                fileInfo.setContainingPackage(this);
                return fileInfo;
            }
        }
        FosterPackageInfo surrogatePackage = new FosterPackageInfo(projInfo);
        for (FileInfoRecord fileInfoRec : fileInfoRecs) {
            String pkgName = fileInfoRec.getPackageName();
            String filePath = String.valueOf(fileInfoRec.getName()) + "@" + pkgName;
            if (!fileInfos.containsKey(filePath)) {
                FullFileInfo fileInfo = surrogatePackage.adopt(pkgName, fileInfoRec.getFileInfo());
                if (filter != null && !filter.accept(fileInfo)) continue;
                fileInfos.put(filePath, fileInfo);
                fileInfo.addVersion(version);
                FullPackageInfo pkgInfo = (FullPackageInfo)projInfo.getNamedPackage(pkgName);
                if (pkgInfo == null) {
                    pkgInfo = new FullPackageInfo(projInfo, pkgName, Integer.MAX_VALUE);
                    projInfo.addPackage(pkgInfo);
                }
                pkgInfo.addFile(fileInfo);
                continue;
            }
            fileInfos.get(filePath).addVersion(sessionSegment.getVersion());
        }
    }

    private static void recreateDataIndicesAndLengths(UpdatableRegFile regFile, FullProjectInfo projInfo) {
        int projLen = Integer.MIN_VALUE;
        for (FullPackageInfo fullPackageInfo : projInfo.getAllPackages()) {
            int pkgStartIdx = Integer.MAX_VALUE;
            int pkgEndIdx = Integer.MIN_VALUE;
            for (FullFileInfo fullFileInfo : fullPackageInfo.getFiles()) {
                pkgStartIdx = Math.min(pkgStartIdx, fullFileInfo.getDataIndex());
                pkgEndIdx = Math.max(pkgEndIdx, fullFileInfo.getDataIndex() + fullFileInfo.getDataLength());
            }
            fullPackageInfo.setDataIndex(pkgStartIdx);
            fullPackageInfo.setDataLength(pkgEndIdx - pkgStartIdx);
            projLen = Math.max(projLen, pkgEndIdx);
        }
        projInfo.setDataLength(Math.max(projLen, regFile.getSlotCount()));
    }

    public static Clover2Registry createOrLoad(File registryFile, String projectName) throws IOException, CloverException {
        Clover2Registry registry;
        if (registryFile.exists()) {
            Logger.getInstance().info("Updating existing database at '" + registryFile + "'.");
            registry = Clover2Registry.fromFile(registryFile);
        } else {
            Logger.getInstance().info("Creating new database at '" + registryFile + "'.");
            File parentDir = registryFile.getParentFile();
            if (parentDir != null) {
                parentDir.mkdirs();
            }
            registry = new Clover2Registry(registryFile, projectName);
        }
        return registry;
    }

    public RegFile saveAndOverwriteFile() throws IOException, CloverRegistryException {
        return this.saveAndOverwriteFile(this.model.getProject(), this.instrumentationHistory, this.contexts, this.coverageData);
    }

    protected RegFile saveAndOverwriteFile(FullProjectInfo project, List<InstrumentationInfo> instrumentationHistory, ContextStore contexts, CoverageData coverageData) throws IOException, CloverRegistryException {
        long startTs;
        FreshRegFile regFile = new FreshRegFile(this.regFile, coverageData);
        LinkedList updates = Lists.newLinkedList();
        int i = 0;
        while (i < instrumentationHistory.size() - 1) {
            InstrumentationInfo instrInfo = instrumentationHistory.get(i);
            updates.add(new EmptyProjectUpdate(instrInfo.getVersion(), instrInfo.getStartTS(), instrInfo.getEndTS(), project.getDataLength()));
            ++i;
        }
        long endTs = startTs = System.currentTimeMillis();
        if (!instrumentationHistory.isEmpty()) {
            startTs = instrumentationHistory.get(instrumentationHistory.size() - 1).getStartTS();
            endTs = instrumentationHistory.get(instrumentationHistory.size() - 1).getEndTS();
        }
        updates.add(new FullProjectUpdate(project, contexts, startTs, endTs));
        this.regFile = regFile.save(updates);
        return regFile;
    }

    public RegFile saveAndAppendToFile() throws IOException, CloverRegistryException {
        if (this.regFile.isAppendable()) {
            this.regFile = this.regFile.save(this.updatesToSave);
        } else {
            this.saveAndOverwriteFile();
        }
        this.updatesToSave.clear();
        return this.regFile;
    }

    public UpdatableRegFile applyAndAppendToFile(UpdatableRegFile regFile, InstrumentationSessionImpl.Update update) throws IOException, CloverRegistryException {
        return (UpdatableRegFile)regFile.save(this.applyUpdate(regFile.getVersion(), update));
    }

    @Override
    public RegistryUpdate applyUpdate(long expectedVersion, InstrumentationSessionImpl.Update update) throws ConcurrentInstrumentationException {
        this.model.applyUpdate(expectedVersion, update);
        this.instrumentationHistory.addFirst(new InstrumentationInfo(update.getVersion(), update.getStartTs(), update.getEndTs()));
        this.updatesToSave.add(update);
        return update;
    }

    public ProjectView.Filtered newProjectView(HasMetricsFilter.Invertable filter) {
        return this.model.newProjection(filter);
    }

    public InstrumentationSession startInstr() throws CloverException {
        return this.startInstr(null);
    }

    public InstrumentationSession startInstr(String encoding) throws CloverException {
        return new InstrumentationSessionImpl(this, encoding);
    }

    public boolean fileExists() {
        return this.regFile.getFile().exists();
    }

    public boolean isOutOfDate() {
        File file = this.getRegistryFile();
        return file.lastModified() == 0L || FileUtils.getInstance().compareLastModified(this.getVersion(), file) < 0;
    }

    public File getRegistryFile() {
        return this.regFile.getFile();
    }

    public String getProjectName() {
        return this.model.getProject().getName();
    }

    public void setProjectName(String name) {
        this.model.getProject().setName(name);
    }

    public long getVersion() {
        return this.model.getVersion();
    }

    public long getFirstVersion() {
        return this.instrumentationHistory.isEmpty() ? this.getVersion() : this.instrumentationHistory.get(this.instrumentationHistory.size() - 1).getVersion();
    }

    public void setVersion(long version) {
        this.model.setVersion(version);
    }

    public ProjectView.Original getModel() {
        return this.model;
    }

    public boolean isReadOnly() {
        return this.regFile.getAccessMode() == RegAccessMode.READONLY;
    }

    public void setCoverageData(CoverageData data) {
        this.coverageData = data;
    }

    public CoverageData getCoverageData() {
        return this.coverageData;
    }

    public int getDataLength() {
        return this.model.getProject().getDataLength();
    }

    public FullProjectInfo getProject() {
        return this.model.getProject();
    }

    public List getInstrHistory() {
        return this.instrumentationHistory;
    }

    public ContextStore getContextStore() {
        return this.contexts;
    }

    public void setContextStore(ContextStore contexts) {
        this.contexts = contexts;
    }

    public String getInitstring() {
        return this.getRegistryFile().getAbsolutePath();
    }

    public long getPastInstrTimestamp(int numPastInstrs) {
        long msec = 0L;
        if (!this.instrumentationHistory.isEmpty()) {
            ListIterator<InstrumentationInfo> history = this.instrumentationHistory.listIterator(this.instrumentationHistory.size() - 1);
            while (numPastInstrs-- > 0 && history.hasPrevious()) {
                msec = history.previous().getEndTS();
            }
        }
        return msec;
    }

    public void resolve(Path sourcePath) {
        this.model.resolve(sourcePath);
    }

    public static class InstrumentationInfo {
        private long startTS = 0L;
        private long endTS = 0L;
        private long version = 0L;

        public InstrumentationInfo(long version, long startTS, long endTS) {
            this.version = version;
            this.startTS = startTS;
            this.endTS = endTS;
        }

        public InstrumentationInfo(long startTS) {
            this.startTS = startTS;
        }

        public long getStartTS() {
            return this.startTS;
        }

        public void setStartTS(long startTS) {
            this.startTS = startTS;
        }

        public long getEndTS() {
            return this.endTS;
        }

        public void setEndTS(long endTS) {
            this.endTS = endTS;
        }

        public long getVersion() {
            return this.version;
        }

        public String toString() {
            return "InstrumentationInfo{startTS=" + this.startTS + ", endTS=" + this.endTS + ", version=" + this.version + '}';
        }
    }
}

