/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.recorder.BaseCoverageRecording;
import com.atlassian.clover.recorder.GlobalCoverageRecordingTranscript;
import com.atlassian.clover.util.CoverageUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class FileBasedCoverageRecordingTranscript
extends BaseCoverageRecording
implements GlobalCoverageRecordingTranscript {
    protected int[] hitCounts;
    protected long coverageSum;

    public FileBasedCoverageRecordingTranscript(BaseCoverageRecording.Header header, File fileOnDisk) {
        super(header, fileOnDisk);
    }

    @Override
    public long getCoverageSum() {
        return this.coverageSum;
    }

    @Override
    public void read(DataInputStream in, CoverageDataSpec spec) throws IOException {
        AtomicLong sum = new AtomicLong(0L);
        this.hitCounts = CoverageUtils.readCoverageAndSumCoverage(in, sum);
        this.coverageSum = sum.longValue();
    }

    @Override
    public int get(int slotIndex) {
        return this.hitCounts[slotIndex];
    }

    @Override
    public int getCount() {
        return this.hitCounts.length;
    }

    @Override
    public int addTo(int[] coverage) {
        int max = Math.min(this.hitCounts.length, coverage.length);
        int i = 0;
        while (i < max) {
            int n = i;
            coverage[n] = coverage[n] + this.hitCounts[i];
            ++i;
        }
        return max;
    }

    public String toString() {
        return "FileBasedCoverageRecordingTranscript[header=" + this.header + ", coverageSum=" + this.coverageSum + ", hitCounts.length=" + (this.hitCounts == null ? null : Integer.valueOf(this.hitCounts.length)) + ']';
    }
}

