/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.optimization;

import clover.it.unimi.dsi.fastutil.objects.Object2LongMap;
import clover.it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.optimization.Messages;
import com.atlassian.clover.optimization.OptimizationSession;
import com.atlassian.clover.optimization.TestMethodCall;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.CoverageDataRange;
import com.atlassian.clover.registry.FileInfoVisitor;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com_atlassian_clover.CloverVersionInfo;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class Snapshot
implements Serializable {
    private static final long serialVersionUID = 6684083217918243192L;
    public static final long UNKNOWN_DURATION = Long.MIN_VALUE;
    private final String cloverVersionInfo = CloverVersionInfo.formatVersionInfo();
    private final Set<Long> dbVersions = new LinkedHashSet<Long>();
    private final String initString;
    private final Map<String, Set<TestMethodCall>> testLookup;
    private final Object2LongMap durationsForTests;
    private final Set<TestMethodCall> failingTests;
    private final Map<TestMethodCall, Map<String, SourceState>> perTestSourceStates;
    private long avgSetupTeardownDuration;
    private transient File location;
    private static boolean DEBUG;

    public Snapshot(CloverDatabase db, File locationTosnapshot) {
        this.initString = db.getInitstring();
        this.testLookup = Maps.newHashMap();
        this.perTestSourceStates = Maps.newHashMap();
        this.durationsForTests = new Object2LongOpenHashMap(){
            private static final long serialVersionUID = 6851581250481388361L;

            @Override
            public long defaultReturnValue() {
                return Long.MIN_VALUE;
            }
        };
        this.failingTests = Sets.newHashSet();
        this.location = locationTosnapshot;
        this.updateFor(db);
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public void updateFor(CloverDatabase db) {
        long updateStart = System.currentTimeMillis();
        TestRunTimings testTimings = this.updateFailedTestsAndTestDurations(db);
        if (this.isFirstUpdate()) {
            this.avgSetupTeardownDuration = this.calcAvgSetupTeardownDuration(testTimings);
        }
        this.calcHits(db);
        Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - updateStart) + "ms to " + (this.isFirstUpdate() ? "initialise" : "update") + " the snapshot");
        this.pushVersion(db);
    }

    private void pushVersion(CloverDatabase db) {
        this.dbVersions.add(db.getRegistry().getVersion());
    }

    private boolean isFirstUpdate() {
        return this.dbVersions.size() == 0;
    }

    private TestRunTimings updateFailedTestsAndTestDurations(CloverDatabase db) {
        long earliestStart = Long.MAX_VALUE;
        long latestEnd = 0L;
        long totalTestTime = 0L;
        long started = System.currentTimeMillis();
        int testCount = 0;
        Set<TestCaseInfo> allTestCaseInfos = db.getCoverageData().getTests();
        for (TestCaseInfo tci : allTestCaseInfos) {
            ++testCount;
            long duration = tci.getEndTime() - tci.getStartTime();
            totalTestTime += duration;
            earliestStart = Math.min(earliestStart, tci.getStartTime());
            latestEnd = Math.max(latestEnd, tci.getEndTime());
            this.updatePerTestInfo(db, tci, duration);
        }
        Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - started) + "ms to process all test durations");
        if (testCount == 0) {
            Logger.getInstance().verbose("No test results found in the Clover database. Please ensure the source files containing test classes have been instrumented by Clover and the tests have been run.");
        } else {
            Logger.getInstance().verbose("Number of test results found in the model: " + testCount);
        }
        return new TestRunTimings(earliestStart, latestEnd, totalTestTime);
    }

    public void updatePerTestInfo(CloverDatabase db, TestCaseInfo tci, long duration) {
        TestMethodCall testCall = TestMethodCall.createFor(db.getFullModel(), tci);
        if (testCall != null) {
            this.addToTestlookup(testCall.getSourceMethodName(), testCall);
            if (testCall.isInheritedCall()) {
                this.addToTestlookup(testCall.getRuntimeMethodName(), testCall);
            }
            this.addToTestlookup(testCall.getPackagePath(), testCall);
            this.addToTestlookup(tci.getRuntimeTypeName(), testCall);
            if (tci.isSuccess()) {
                this.failingTests.remove(testCall);
            } else {
                this.failingTests.add(testCall);
            }
            if (DEBUG) {
                Logger.getInstance().debug("Duration for individual test '" + testCall + "' = " + duration);
            }
            this.durationsForTests.put(testCall, duration);
        }
    }

    private void addToTestlookup(String key, TestMethodCall testCall) {
        Set<TestMethodCall> tests = this.testLookup.get(key);
        tests = tests == null ? Sets.newHashSet() : tests;
        tests.add(testCall);
        this.testLookup.put(key, tests);
    }

    private void addToStates(TestMethodCall test, String path, SourceState state) {
        Map<String, SourceState> perTestMap = this.perTestSourceStates.get(test);
        if (perTestMap == null) {
            perTestMap = Maps.newHashMap();
            this.perTestSourceStates.put(test, perTestMap);
        }
        perTestMap.put(path, state);
    }

    private void calcHits(final CloverDatabase db) {
        long started = System.currentTimeMillis();
        db.getFullModel().visitFiles(new FileInfoVisitor(){

            @Override
            public void visitFileInfo(BaseFileInfo file) {
                String packagePath = file.getPackagePath();
                SourceState sourceState = new SourceState(file.getChecksum(), file.getFilesize());
                Set testsForFile = Snapshot.this.testsFor(db.getFullModel(), db.getTestHits((CoverageDataRange)((Object)file)));
                for (TestMethodCall test : testsForFile) {
                    Snapshot.this.addToStates(test, packagePath, sourceState);
                }
            }
        });
        Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - started) + "ms to correlate source files paths with test hits");
    }

    private long calcAvgSetupTeardownDuration(TestRunTimings timings) {
        long duration = 0L;
        if (this.durationsForTests.size() > 1 && timings.totalTestTime > 0L && timings.latestEnd > timings.earliestStart) {
            long firstToLastTestDuration = timings.latestEnd - timings.earliestStart;
            Logger.getInstance().verbose("Measured first-to-last test duration = " + firstToLastTestDuration + "ms");
            Logger.getInstance().verbose("Aggregate test duration = " + timings.totalTestTime + "ms");
            Logger.getInstance().verbose("Number of test methods = " + this.durationsForTests.size());
            duration = Math.max(0L, (firstToLastTestDuration - timings.totalTestTime) / (long)(this.durationsForTests.size() - 1));
        }
        Logger.getInstance().debug("Calculated average per-test setup/teardown cost = " + duration + "ms");
        return duration;
    }

    private Set<TestMethodCall> testsFor(FullProjectInfo project, Collection<TestCaseInfo> tcis) {
        HashSet<TestMethodCall> tests = Sets.newHashSet();
        for (TestCaseInfo tci : tcis) {
            Set<TestMethodCall> testsForName;
            String testName = TestMethodCall.getSourceMethodNameFor(tci, project);
            Set<TestMethodCall> set = testsForName = testName == null ? null : this.testLookup.get(testName);
            if (testsForName == null) continue;
            tests.addAll(testsForName);
        }
        return tests;
    }

    public void store() throws IOException {
        if (!this.location.exists()) {
            if (this.location.getParentFile() != null && !this.location.getParentFile().exists()) {
                this.location.getParentFile().mkdirs();
            }
            this.location.createNewFile();
        }
        ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(this.location.toPath(), new OpenOption[0]));
        oos.writeObject(this);
        oos.close();
    }

    public static Snapshot generateFor(CloverDatabase db) {
        return new Snapshot(db, new File(Snapshot.fileNameForInitString(db.getInitstring())));
    }

    public static Snapshot generateFor(CloverDatabase db, String location) {
        return new Snapshot(db, new File(location));
    }

    public static Snapshot generateFor(String initString, String snapshotPath, CoverageDataSpec spec) throws CloverException {
        return new Snapshot(CloverDatabase.loadWithCoverage(initString, spec), new File(snapshotPath));
    }

    public static Snapshot generateFor(String initString) throws CloverException {
        return new Snapshot(CloverDatabase.loadWithCoverage(initString, new CoverageDataSpec()), Snapshot.fileForInitString(initString));
    }

    public static Snapshot loadFor(String initString) {
        return Snapshot.loadFrom(Snapshot.fileNameForInitString(initString));
    }

    public static Snapshot loadFrom(String path) {
        return Snapshot.loadFromFile(new File(path));
    }

    public static Snapshot loadFrom(File file) {
        return Snapshot.loadFromFile(file);
    }

    public static Snapshot loadFromFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                    long start = System.currentTimeMillis();
                    Snapshot snapshot = (Snapshot)ois.readObject();
                    Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - start) + "ms to load the snapshot file");
                    snapshot.location = file;
                    return snapshot;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InvalidClassException e) {
                Logger.getInstance().debug("Failed to load snapshot file at " + file.getAbsolutePath(), e);
                Logger.getInstance().warn("Failed to load snapshot file at " + file.getAbsolutePath() + " because it is no longer valid for this version of Clover");
            }
            catch (Exception e) {
                Logger.getInstance().debug("Failed to load snapshot file at " + file.getAbsolutePath(), e);
                Logger.getInstance().warn("Failed to load snapshot file at " + file.getAbsolutePath());
            }
        } else {
            Logger.getInstance().verbose("Snapshot file at " + file.getAbsolutePath() + " exists / is file / can read: " + file.exists() + " / " + file.isFile() + " / " + file.canRead() + " / ");
        }
        return null;
    }

    public boolean delete() {
        return this.location.exists() && this.location.delete();
    }

    public Set<String> getFailingTestPaths() {
        return this.pathsFor(this.failingTests);
    }

    private boolean isChangedFile(SourceState fileReference, FileInfo file) {
        return fileReference != null && file instanceof FullFileInfo && ((FullFileInfo)file).changedFrom(fileReference.checksum, fileReference.filesize);
    }

    private Set<String> pathsFor(Set<TestMethodCall> tests) {
        HashSet<String> paths = new HashSet<String>(tests.size());
        for (TestMethodCall testReference : tests) {
            paths.add(testReference.getPackagePath());
        }
        return paths;
    }

    public static String fileNameForInitString(String initString) {
        return String.valueOf(initString) + ".snapshot";
    }

    public static File fileForInitString(String initString) {
        return new File(Snapshot.fileNameForInitString(initString));
    }

    public File getLocation() {
        return this.location;
    }

    public int getDbVersionCount() {
        return this.dbVersions.size();
    }

    public String getCloverVersionInfo() {
        return this.cloverVersionInfo;
    }

    public String getInitString() {
        return this.initString;
    }

    public Set<Long> getDbVersions() {
        return this.dbVersions;
    }

    long calculateDurationOf(Set<TestMethodCall> tests) {
        long duration = 0L;
        for (TestMethodCall test : tests) {
            long testFileDuration = this.durationsForTests.getLong(test);
            if (testFileDuration == Long.MIN_VALUE) continue;
            duration += testFileDuration;
        }
        return duration + (long)tests.size() * this.avgSetupTeardownDuration;
    }

    public boolean isTooStale(int maxOptimizedBuilds) {
        StringBuffer reason = new StringBuffer();
        boolean tooStale = this.isTooStale(maxOptimizedBuilds, reason);
        if (DEBUG) {
            Logger.getInstance().info(reason.toString());
        }
        return tooStale;
    }

    public boolean isTooStale(int maxOptimizedBuilds, StringBuffer reason) {
        if (!this.cloverVersionInfo.equals(CloverVersionInfo.formatVersionInfo())) {
            reason.append(Messages.noOptimizationBecauseOldVersion(this.cloverVersionInfo));
            return true;
        }
        if (this.getDbVersionCount() - 1 >= maxOptimizedBuilds) {
            reason.append(Messages.noOptimizationBecauseInaccurate(maxOptimizedBuilds, this.getDbVersionCount()));
            return true;
        }
        return false;
    }

    long getMostRecentDbVersion() {
        long version = 0L;
        for (Long dbVersion : this.dbVersions) {
            if (dbVersion <= version) continue;
            version = dbVersion;
        }
        return version;
    }

    boolean isTestAffectedByChanges(TestMethodCall test, Clover2Registry registry, OptimizationSession session) {
        boolean isAffected;
        Map<String, SourceState> perTestStates = this.perTestSourceStates.get(test);
        boolean bl = isAffected = perTestStates == null || this.hasChanges(test, perTestStates, registry, session);
        if (DEBUG) {
            if (perTestStates == null) {
                Logger.getInstance().info("Test " + test + " has no recorded coverage");
            } else {
                Logger.getInstance().info("Test " + test + " was affected by changed source: " + isAffected);
            }
        }
        return isAffected;
    }

    private boolean hasChanges(TestMethodCall testMethod, Map<String, SourceState> perTestStates, Clover2Registry registry, OptimizationSession session) {
        for (Map.Entry<String, SourceState> fileState : perTestStates.entrySet()) {
            FileInfo fileInfo = registry.getProject().findFile(fileState.getKey());
            if (fileInfo != null && !this.isChangedFile(fileState.getValue(), fileInfo)) continue;
            if (DEBUG) {
                if (fileInfo == null) {
                    Logger.getInstance().info("Source file " + fileState.getKey() + " covered by test " + testMethod + " not found in model");
                } else {
                    Logger.getInstance().info("Source file " + fileState.getKey() + " covered by test " + testMethod + " changed (was: " + fileState.getValue() + " now: " + new SourceState(fileInfo.getChecksum(), fileInfo.getFilesize()) + ")");
                }
            }
            if (fileInfo != null) {
                session.addModifiedPath(fileState.getKey());
            }
            return true;
        }
        if (DEBUG) {
            Logger.getInstance().info("Test " + testMethod + " has no coverage or no source it covered has changed");
        }
        return false;
    }

    Set<TestMethodCall> lookupTests(String name) {
        return this.testLookup.get(name);
    }

    Set<TestMethodCall> getFailingTests() {
        return this.failingTests;
    }

    Map<String, Set<TestMethodCall>> getTestLookup() {
        return this.testLookup;
    }

    Map<String, Collection<TestMethodCall>> getFile2TestsMap() {
        HashMap<String, Collection<TestMethodCall>> result = Maps.newHashMap();
        for (Map.Entry<TestMethodCall, Map<String, SourceState>> mapEntry : this.perTestSourceStates.entrySet()) {
            TestMethodCall test = mapEntry.getKey();
            Map<String, SourceState> value = mapEntry.getValue();
            for (String filePath : value.keySet()) {
                HashSet tests = (HashSet)result.get(filePath);
                if (tests == null) {
                    tests = Sets.newHashSet();
                    result.put(filePath, tests);
                }
                tests.add(test);
            }
        }
        return result;
    }

    private static final class SourceState
    implements Serializable {
        private static final long serialVersionUID = -3186007190113270192L;
        private final long checksum;
        private final long filesize;

        SourceState(long checksum, long filesize) {
            this.checksum = checksum;
            this.filesize = filesize;
        }

        public String toString() {
            return "SourceState{checksum=" + this.checksum + ", filesize=" + this.filesize + '}';
        }
    }

    private static final class TestRunTimings {
        private final long earliestStart;
        private final long latestEnd;
        private final long totalTestTime;

        private TestRunTimings(long earliestStart, long latestEnd, long totalTestTime) {
            this.earliestStart = earliestStart;
            this.latestEnd = latestEnd;
            this.totalTestTime = totalTestTime;
        }
    }
}

