/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.instr.java.LambdaExpressionEntryEmitter;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.spi.lang.LanguageConstruct;

public class LambdaExpressionExitEmitter
extends Emitter {
    private LambdaExpressionEntryEmitter entryEmitter;

    public LambdaExpressionExitEmitter(LambdaExpressionEntryEmitter entryEmitter, int endLine, int endColumn) {
        super(endLine, endColumn);
        this.entryEmitter = entryEmitter;
    }

    @Override
    protected void init(InstrumentationState state) {
        if (this.entryEmitter.method != null) {
            FullStatementInfo statementInfo = state.getSession().addStatement(this.getElementContext(), new FixedSourceRegion(this.entryEmitter.getBodyStartLine(), this.entryEmitter.getBodyStartColumn(), this.getLine(), this.getColumn()), 0, LanguageConstruct.Builtin.STATEMENT);
            state.getSession().exitMethod(this.getLine(), this.getColumn());
            boolean classInstrStrategy = state.getCfg().isClassInstrStrategy();
            if (classInstrStrategy) {
                this.setInstr("," + statementInfo.getDataIndex() + ")");
            }
        }
    }
}

