/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.antlr.LLkParser;
import clover.antlr.NoViableAltException;
import clover.antlr.ParserSharedInputState;
import clover.antlr.RecognitionException;
import clover.antlr.SemanticException;
import clover.antlr.Token;
import clover.antlr.TokenBuffer;
import clover.antlr.TokenStream;
import clover.antlr.TokenStreamException;
import clover.antlr.collections.impl.BitSet;
import com.atlassian.clover.Contract;
import com.atlassian.clover.Logger;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.instr.java.ArmInstrEmitter;
import com.atlassian.clover.instr.java.AutoCloseableEmitter;
import com.atlassian.clover.instr.java.CaseExpressionEntryEmitter;
import com.atlassian.clover.instr.java.CaseExpressionExitEmitter;
import com.atlassian.clover.instr.java.CaseThrowExpressionEntryEmitter;
import com.atlassian.clover.instr.java.CaseThrowExpressionExitEmitter;
import com.atlassian.clover.instr.java.ClassEntryNode;
import com.atlassian.clover.instr.java.ClassExitNode;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.CloverTokenStreamFilter;
import com.atlassian.clover.instr.java.ContextSetAndComplexity;
import com.atlassian.clover.instr.java.ContextTreeNode;
import com.atlassian.clover.instr.java.DirectedFlushEmitter;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.EndBoolInstrEmitter;
import com.atlassian.clover.instr.java.ExpressionInfo;
import com.atlassian.clover.instr.java.FileStructureInfo;
import com.atlassian.clover.instr.java.FlagDeclEmitter;
import com.atlassian.clover.instr.java.FlaggedInstrEmitter;
import com.atlassian.clover.instr.java.JavaTokenTypes;
import com.atlassian.clover.instr.java.LambdaBlockEntryEmitter;
import com.atlassian.clover.instr.java.LambdaBlockExitEmitter;
import com.atlassian.clover.instr.java.LambdaExprToBlockBodyEntryEmitter;
import com.atlassian.clover.instr.java.LambdaExprToBlockExitEmitter;
import com.atlassian.clover.instr.java.LambdaExprToBlockStartEntryEmitter;
import com.atlassian.clover.instr.java.LambdaExpressionEntryEmitter;
import com.atlassian.clover.instr.java.LambdaExpressionExitEmitter;
import com.atlassian.clover.instr.java.LambdaUtil;
import com.atlassian.clover.instr.java.MethodEntryInstrEmitter;
import com.atlassian.clover.instr.java.MethodExitInstrEmitter;
import com.atlassian.clover.instr.java.MethodRegistrationNode;
import com.atlassian.clover.instr.java.MethodSignatureExt;
import com.atlassian.clover.instr.java.RecorderInstrEmitter;
import com.atlassian.clover.instr.java.RewriteLambdaToBlockMatcher;
import com.atlassian.clover.instr.java.SimpleEmitter;
import com.atlassian.clover.instr.java.StartBoolInstrEmitter;
import com.atlassian.clover.instr.java.StatementInstrEmitter;
import com.atlassian.clover.instr.java.TokenListUtil;
import com.atlassian.clover.registry.AnnotationValueCollection;
import com.atlassian.clover.registry.entities.AnnotationImpl;
import com.atlassian.clover.registry.entities.ArrayAnnotationValue;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.Modifiers;
import com.atlassian.clover.registry.entities.Parameter;
import com.atlassian.clover.registry.entities.StringifiedAnnotationValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaRecognizer
extends LLkParser
implements JavaTokenTypes {
    private static final Logger LOG = Logger.getInstance();
    private ContextTreeNode currentContextTreeNode;
    private boolean topLevelClass = true;
    private CloverTokenStreamFilter mFilter;
    private LinkedList<String> classnameList = new LinkedList();
    private boolean constExpr = false;
    private JavaInstrumentationConfig cfg;
    private FileStructureInfo fileInfo;
    private ClassEntryNode currentTopLevelClassEntry;
    private Emitter suppressWarningsInstr = null;
    private boolean existingFallthroughSuppression = false;
    private int ltCounter = 0;
    private int lambdaCounter = 0;
    private final Deque<Deque<String>> identifiersStack = new ArrayDeque<Deque<String>>();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "NUM_INT", "CHAR_LITERAL", "STRING_LITERAL", "NUM_FLOAT", "NUM_LONG", "NUM_DOUBLE", "\"abstract\"", "\"assert\"", "\"boolean\"", "\"break\"", "\"byte\"", "\"case\"", "\"catch\"", "\"char\"", "\"class\"", "\"continue\"", "\"default\"", "\"do\"", "\"double\"", "\"else\"", "\"enum\"", "\"extends\"", "\"final\"", "\"finally\"", "\"float\"", "\"for\"", "\"if\"", "\"implements\"", "\"import\"", "\"instanceof\"", "\"int\"", "\"interface\"", "\"long\"", "\"native\"", "\"new\"", "\"package\"", "\"private\"", "\"protected\"", "\"public\"", "\"return\"", "\"short\"", "\"static\"", "\"strictfp\"", "\"super\"", "\"switch\"", "\"synchronized\"", "\"this\"", "\"throw\"", "\"throws\"", "\"transient\"", "\"try\"", "\"void\"", "\"volatile\"", "\"while\"", "\"const\"", "\"goto\"", "\"true\"", "\"false\"", "\"null\"", "NON_SEALED", "QUESTION", "LPAREN", "RPAREN", "LBRACK", "RBRACK", "LCURLY", "RCURLY", "COLON", "METHOD_REF", "COMMA", "ASSIGN", "EQUAL", "LNOT", "BNOT", "NOT_EQUAL", "DIV", "DIV_ASSIGN", "PLUS", "PLUS_ASSIGN", "INC", "MINUS", "MINUS_ASSIGN", "DEC", "STAR", "STAR_ASSIGN", "MOD", "MOD_ASSIGN", "SR", "SR_ASSIGN", "BSR", "BSR_ASSIGN", "GE", "GT", "SL", "SL_ASSIGN", "LE", "LT", "BXOR", "BXOR_ASSIGN", "BOR", "BOR_ASSIGN", "LOR", "BAND", "BAND_ASSIGN", "LAND", "SEMI", "LAMBDA", "AT", "WS", "SL_COMMENT", "ML_COMMENT", "STRING_LITERAL_SINGLE_LINE", "STRING_LITERAL_TEXT_BLOCK", "ESC", "BACKSLASH", "VOCAB", "IDENT", "INT_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL", "HEX_FLOAT_LITERAL", "DEC_DIGIT", "BIN_DIGIT", "HEX_DIGIT", "DEC_INT", "HEX_INT", "BIN_INT", "ELLIPSIS", "DOT", "FLOAT_SUFFIX", "EXPONENT", "BINARY_EXPONENT", "IdentifierStart", "IdentifierPart", "BLOCK", "MODIFIERS", "OBJBLOCK", "SLIST", "CTOR_DEF", "METHOD_DEF", "VARIABLE_DEF", "INSTANCE_INIT", "STATIC_INIT", "TYPE", "CLASS_DEF", "INTERFACE_DEF", "PACKAGE_DEF", "ARRAY_DECLARATOR", "EXTENDS_CLAUSE", "IMPLEMENTS_CLAUSE", "PARAMETERS", "PARAMETER_DEF", "LABELED_STAT", "TYPECAST", "INDEX_OP", "POST_INC", "POST_DEC", "METHOD_CALL", "EXPR", "ARRAY_INIT", "UNARY_MINUS", "UNARY_PLUS", "CASE_GROUP", "ELIST", "FOR_INIT", "FOR_CONDITION", "FOR_ITERATOR", "EMPTY_STAT", "SUPER_CTOR_CALL", "CTOR_CALL"};
    public static final BitSet _tokenSet_0 = new BitSet(JavaRecognizer.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(JavaRecognizer.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(JavaRecognizer.mk_tokenSet_2());

    public JavaRecognizer(CloverTokenStreamFilter filter, JavaInstrumentationConfig cfg, FileStructureInfo fileInfo, ContextTreeNode contextTreeRoot) {
        this(filter);
        this.mFilter = filter;
        this.cfg = cfg;
        this.fileInfo = fileInfo;
        this.currentContextTreeNode = contextTreeRoot;
        this.pushHeadIdentifierStack();
    }

    private ClassEntryNode enterClass(Modifiers mods, CloverToken tok, boolean aIsInterface, boolean aIsEnum, boolean isAnnotation) {
        return this.enterClass(null, mods, tok, aIsInterface, aIsEnum, isAnnotation, null);
    }

    private ClassEntryNode enterClass(Map<String, List<String>> tags, Modifiers mods, CloverToken tok, boolean aIsInterface, boolean aIsEnum, boolean isAnnotation, String superclass) {
        String classname = tok.getText();
        int startLine = tok.getLine();
        int startCol = tok.getColumn();
        this.classnameList.add(classname);
        String fullName = this.getClassname(this.classnameList);
        ClassEntryNode node = new ClassEntryNode(tags, mods, fullName, this.fileInfo.getPackageName(), superclass, this.getCurrentContext(), startLine, startCol, this.topLevelClass, aIsInterface, aIsEnum, isAnnotation);
        tok.addPreEmitter(node);
        if (this.topLevelClass) {
            this.currentTopLevelClassEntry = node;
        }
        return node;
    }

    private void pushIdentifierToHeadStack(String ident) {
        this.headIdentifiersStack().push(ident);
    }

    private Deque<String> headIdentifiersStack() {
        return this.identifiersStack.getFirst();
    }

    private void popHeadIdentifierStack() {
        this.identifiersStack.pollFirst();
    }

    private void pushHeadIdentifierStack() {
        this.identifiersStack.push(new ArrayDeque());
    }

    private void exitClass(CloverToken t, ClassEntryNode entry) {
        Contract.pre(this.classnameList.size() > 0);
        this.classnameList.removeLast();
        t.addPreEmitter(new ClassExitNode(entry, this.getClassname(this.classnameList), t.getLine(), t.getColumn() + t.getText().length()));
    }

    private String getClassname(List<String> classList) {
        String fullName = "";
        String sep = "";
        for (String className : classList) {
            fullName = String.valueOf(fullName) + sep + className;
            sep = ".";
        }
        return fullName;
    }

    private void enterContext(int newContext) {
        this.currentContextTreeNode = this.currentContextTreeNode.enterContext(newContext);
    }

    private ContextSet getCurrentContext() {
        return this.currentContextTreeNode.getContext();
    }

    private void exitContext() {
        this.currentContextTreeNode = this.currentContextTreeNode.exitContext();
    }

    private void instrStaticRecorderMember(boolean isEnum) {
        if (this.currentTopLevelClassEntry != null && this.currentTopLevelClassEntry.getRecorderInsertPoint() != null) {
            RecorderInstrEmitter recorderInstr = new RecorderInstrEmitter(isEnum);
            this.currentTopLevelClassEntry.setRecorderInstrEmitter(recorderInstr);
            if (isEnum) {
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPreEmitter(new SimpleEmitter(";"));
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPreEmitter(recorderInstr);
            } else {
                this.currentTopLevelClassEntry.getRecorderInsertPoint().addPostEmitter(recorderInstr);
            }
        }
    }

    private void instrSuppressWarnings(CloverToken instrPoint) {
        if (!this.existingFallthroughSuppression && this.fileInfo.isSuppressFallthroughWarnings()) {
            if (this.suppressWarningsInstr == null) {
                instrPoint.addPreEmitter(new SimpleEmitter("@" + this.cfg.getJavaLangPrefix() + "SuppressWarnings({\"fallthrough\"}) "));
            }
        } else if (this.suppressWarningsInstr != null) {
            this.suppressWarningsInstr.setEnabled(false);
        }
    }

    private void setRecorderMemberInsertPoint(ClassEntryNode node, CloverToken insertPoint) {
        if (this.topLevelClass) {
            node.setRecorderInsertPoint(insertPoint);
            this.topLevelClass = false;
        }
    }

    private MethodEntryInstrEmitter instrEnterMethod(MethodSignature sig, CloverToken start, CloverToken leftCurly, CloverToken skip) {
        CloverToken instrPoint = skip == null ? leftCurly : skip;
        MethodRegistrationNode reg = new MethodRegistrationNode(this.getCurrentContext(), sig, start.getLine(), start.getColumn());
        leftCurly.addPreEmitter(reg);
        MethodEntryInstrEmitter ret = new MethodEntryInstrEmitter(reg);
        instrPoint.addPostEmitter(ret);
        instrPoint.addPostEmitter(new DirectedFlushEmitter());
        return ret;
    }

    private MethodEntryInstrEmitter instrEnterMethod(MethodSignature sig, CloverToken start, CloverToken leftCurly) {
        return this.instrEnterMethod(sig, start, leftCurly, null);
    }

    private void instrExitMethod(MethodEntryInstrEmitter entryEmitter, CloverToken tok) {
        tok.addPreEmitter(new MethodExitInstrEmitter(entryEmitter, tok.getLine(), tok.getColumn() + tok.getText().length()));
    }

    private LambdaBlockEntryEmitter instrEnterLambdaBlock(MethodSignature lambdaSignature, CloverToken leftCurly) {
        if (this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL || this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL_BUT_REFERENCE || this.cfg.getInstrumentLambda() == LambdaInstrumentation.BLOCK) {
            LambdaBlockEntryEmitter emitter = new LambdaBlockEntryEmitter(lambdaSignature, leftCurly.getLine(), leftCurly.getColumn());
            leftCurly.addPostEmitter(emitter);
            return emitter;
        }
        return null;
    }

    private void instrExitLambdaBlock(LambdaBlockEntryEmitter entryEmitter, CloverToken rightCurly) {
        if (this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL || this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL_BUT_REFERENCE || this.cfg.getInstrumentLambda() == LambdaInstrumentation.BLOCK) {
            rightCurly.addPreEmitter(new LambdaBlockExitEmitter(entryEmitter, rightCurly.getLine(), rightCurly.getColumn() + rightCurly.getText().length()));
        }
    }

    private LambdaExpressionEntryEmitter instrEnterLambdaExpression(MethodSignature lambdaSignature, CloverToken lambdaStart, CloverToken bodyStart, CloverToken classCastStart, CloverToken classCastEnd) {
        if (this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL || this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL_BUT_REFERENCE || this.cfg.getInstrumentLambda() == LambdaInstrumentation.EXPRESSION) {
            String classCast = "";
            if (classCastStart != null && classCastEnd != null && classCastStart != classCastEnd) {
                classCast = TokenListUtil.getNormalisedSequence(classCastStart, classCastEnd);
            }
            LambdaExpressionEntryEmitter emitter = new LambdaExpressionEntryEmitter(lambdaSignature, classCast, lambdaStart.getLine(), lambdaStart.getColumn(), bodyStart.getLine(), bodyStart.getColumn());
            lambdaStart.addPreEmitter(emitter);
            return emitter;
        }
        return null;
    }

    private void instrExitLambdaExpression(LambdaExpressionEntryEmitter entryEmitter, CloverToken tok) {
        if (this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL || this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL_BUT_REFERENCE || this.cfg.getInstrumentLambda() == LambdaInstrumentation.EXPRESSION) {
            tok.addPostEmitter(new LambdaExpressionExitEmitter(entryEmitter, tok.getLine(), tok.getColumn() + tok.getText().length()));
        }
    }

    private LambdaExpressionEntryEmitter instrEnterLambdaMethodReference(MethodSignature lambdaSignature, CloverToken methodReferenceStart, CloverToken classCastStart, CloverToken classCastEnd) {
        if (this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL) {
            String classCast = "";
            if (classCastStart != null && classCastEnd != null && classCastStart != classCastEnd) {
                classCast = TokenListUtil.getNormalisedSequence(classCastStart, classCastEnd);
            }
            LambdaExpressionEntryEmitter emitter = new LambdaExpressionEntryEmitter(lambdaSignature, classCast, methodReferenceStart.getLine(), methodReferenceStart.getColumn(), methodReferenceStart.getLine(), methodReferenceStart.getColumn());
            methodReferenceStart.addPreEmitter(emitter);
            return emitter;
        }
        return null;
    }

    private void instrExitMethodReference(LambdaExpressionEntryEmitter entryEmitter, CloverToken tok) {
        if (this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL) {
            tok.addPostEmitter(new LambdaExpressionExitEmitter(entryEmitter, tok.getLine(), tok.getColumn() + tok.getText().length()));
        }
    }

    private LambdaExprToBlockStartEntryEmitter instrEnterLambdaExprToBlockExpression(MethodSignature lambdaSignature, CloverToken lambdaStart, CloverToken bodyStart) {
        if (this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL || this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL_BUT_REFERENCE || this.cfg.getInstrumentLambda() == LambdaInstrumentation.EXPRESSION) {
            LambdaExprToBlockStartEntryEmitter startEmitter = new LambdaExprToBlockStartEntryEmitter(lambdaSignature, lambdaStart.getLine(), lambdaStart.getColumn());
            LambdaExprToBlockBodyEntryEmitter bodyEmitter = new LambdaExprToBlockBodyEntryEmitter(startEmitter, bodyStart.getLine(), bodyStart.getColumn());
            lambdaStart.addPreEmitter(startEmitter);
            bodyStart.addPreEmitter(bodyEmitter);
            return startEmitter;
        }
        return null;
    }

    private void instrExitLambdaExprToBlockExpression(LambdaExprToBlockStartEntryEmitter entryEmitter, CloverToken tok) {
        if (this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL || this.cfg.getInstrumentLambda() == LambdaInstrumentation.ALL_BUT_REFERENCE || this.cfg.getInstrumentLambda() == LambdaInstrumentation.EXPRESSION) {
            tok.addPostEmitter(new LambdaExprToBlockExitEmitter(entryEmitter, tok.getLine(), tok.getColumn() + tok.getText().length()));
        }
    }

    private CaseExpressionEntryEmitter instrEnterCaseExpression(CloverToken insertionPoint, CloverToken endToken, ContextSet context, int complexity) {
        CaseExpressionEntryEmitter entryEmitter = new CaseExpressionEntryEmitter(context, insertionPoint.getLine(), insertionPoint.getColumn(), endToken.getLine(), endToken.getColumn(), complexity);
        insertionPoint.addPostEmitter(entryEmitter);
        return entryEmitter;
    }

    private void instrExitCaseExpression(CaseExpressionEntryEmitter entryEmitter, CloverToken insertionPoint) {
        insertionPoint.addPreEmitter(new CaseExpressionExitEmitter(entryEmitter));
    }

    private CaseThrowExpressionEntryEmitter instrEnterCaseThrowExpression(CloverToken insertionPoint, CloverToken endToken, ContextSet context, int complexity) {
        CaseThrowExpressionEntryEmitter entryEmitter = new CaseThrowExpressionEntryEmitter(context, insertionPoint.getLine(), insertionPoint.getColumn(), endToken.getLine(), endToken.getColumn(), complexity);
        insertionPoint.addPostEmitter(entryEmitter);
        return entryEmitter;
    }

    private void instrExitCaseThrowExpression(CaseThrowExpressionEntryEmitter entryEmitter, CloverToken insertionPoint) {
        insertionPoint.addPostEmitter(new CaseThrowExpressionExitEmitter(entryEmitter));
    }

    private CloverToken maybeAddFlushInstr(CloverToken last) {
        last.addPostEmitter(new DirectedFlushEmitter());
        return last;
    }

    private FlagDeclEmitter declareFlagBefore(CloverToken tok) {
        FlagDeclEmitter flag = new FlagDeclEmitter();
        tok.addPreEmitter(flag);
        return flag;
    }

    private CloverToken instrInlineAfter(CloverToken instr, CloverToken start, CloverToken end, int complexity) {
        if (this.cfg.isStatementInstrEnabled()) {
            instr.addPostEmitter(new StatementInstrEmitter(this.getCurrentContext(), start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length(), complexity));
            instr.addPostEmitter(new DirectedFlushEmitter());
            this.fileInfo.addStatementMarker(start, end);
        }
        return instr;
    }

    private CloverToken instrInlineAfter(CloverToken tok, CloverToken start, CloverToken end, FlagDeclEmitter flag, int complexity) {
        if (this.cfg.isStatementInstrEnabled()) {
            tok.addPostEmitter(new FlaggedInstrEmitter(flag, new StatementInstrEmitter(this.getCurrentContext(), start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length(), complexity)));
            this.fileInfo.addStatementMarker(start, end);
        }
        return tok;
    }

    private CloverToken instrInlineBefore(CloverToken start, CloverToken end, ContextSet context, int complexity) {
        if (this.cfg.isStatementInstrEnabled()) {
            start.addPreEmitter(new StatementInstrEmitter(context, start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length(), complexity));
        }
        return start;
    }

    private void insertAutoCloseableClassDecl(CloverToken tryBlock) {
        if (this.cfg.isStatementInstrEnabled()) {
            tryBlock.addPreEmitter(new AutoCloseableEmitter());
        }
    }

    private void instrArmDecl(CloverToken start, CloverToken end, ContextSet context) {
        if (this.cfg.isStatementInstrEnabled()) {
            start.addPreEmitter(new ArmInstrEmitter(context, start.getLine(), start.getColumn(), end.getLine(), end.getColumn() + end.getText().length(), 1));
        }
    }

    private void addCloseBraceAfter(CloverToken tok) {
        CloverToken closeBrace = new CloverToken(70, "}");
        closeBrace.setLine(tok.getLine());
        closeBrace.setColumn(tok.getColumn());
        closeBrace.setPrev(tok);
        closeBrace.setNext(tok.getNext());
        tok.setNext(closeBrace);
    }

    private void addOpenBraceAfter(CloverToken tok) {
        CloverToken openBrace = new CloverToken(69, "{");
        openBrace.setLine(tok.getLine());
        openBrace.setColumn(tok.getColumn());
        openBrace.setPrev(tok);
        openBrace.setNext(tok.getNext());
        tok.setNext(openBrace);
    }

    private CloverToken instrBoolExpr(CloverToken begin, CloverToken end) {
        ExpressionInfo expr;
        if (this.cfg.isStatementInstrEnabled() && !(expr = ExpressionInfo.fromTokens(begin, end)).isConstant()) {
            begin.addPreEmitter(new StartBoolInstrEmitter(expr));
            end.addPreEmitter(new EndBoolInstrEmitter(this.getCurrentContext(), begin.getLine(), begin.getColumn() - 1, end.getLine(), end.getColumn() + end.getText().length(), expr));
        }
        return end;
    }

    private boolean maybeEnterDeprecated(CloverToken startOfBlock) {
        Map<String, List<String>> tags = TokenListUtil.getJDocTagsAndValuesOnBlock(startOfBlock);
        boolean deprecated = tags.containsKey("deprecated");
        if (deprecated) {
            this.enterContext(16);
        }
        return deprecated;
    }

    private boolean maybeEnterDeprecated(Map tags, Modifiers mods) {
        boolean deprecated;
        boolean bl = deprecated = tags.containsKey("deprecated") || mods.containsAnnotation("Deprecated");
        if (deprecated) {
            this.enterContext(16);
        }
        return deprecated;
    }

    private void maybeExitDeprecated(boolean dep) {
        if (dep) {
            this.exitContext();
        }
    }

    private boolean isCurrentKeyword(String keyword) throws TokenStreamException {
        return this.LT(0).getText().equals(keyword);
    }

    private boolean isNextKeyword(String keyword) throws TokenStreamException {
        return this.LT(1).getText().equals(keyword);
    }

    private boolean isNextKeyword(String firstKeyword, String secondKeyword) throws TokenStreamException {
        return this.LT(1).getText().equals(firstKeyword) && this.LT(2).getText().equals(secondKeyword);
    }

    private CloverToken lt(int i) throws TokenStreamException {
        return (CloverToken)this.LT(i);
    }

    private CloverToken ct(Token token) {
        return (CloverToken)token;
    }

    protected JavaRecognizer(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public JavaRecognizer(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected JavaRecognizer(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public JavaRecognizer(TokenStream lexer) {
        this(lexer, 2);
    }

    public JavaRecognizer(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final void moduleDeclarationPredicate() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 111) {
            this.annotation();
        }
        if (this.LA(1) == 120 && this.LA(2) == 120 && this.isNextKeyword("open", "module")) {
            this.match(120);
            this.match(120);
        } else if (this.LA(1) == 120 && this.LA(2) == 120 && this.isNextKeyword("module")) {
            this.match(120);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.identifier();
        this.match(69);
    }

    protected final AnnotationImpl annotation() throws RecognitionException, TokenStreamException {
        AnnotationImpl anno = this.annotation2(false);
        return anno;
    }

    public final String identifier() throws RecognitionException, TokenStreamException {
        Token i1 = null;
        Token i2 = null;
        StringBuffer buf = new StringBuffer();
        String str = null;
        i1 = this.LT(1);
        this.match(120);
        if (this.inputState.guessing == 0) {
            buf.append(i1.getText());
        }
        while (this.LA(1) == 133) {
            this.match(133);
            if (this.inputState.guessing == 0) {
                buf.append('.');
            }
            i2 = this.LT(1);
            this.match(120);
            if (this.inputState.guessing != 0) continue;
            buf.append(i2.getText());
        }
        if (this.inputState.guessing == 0) {
            str = buf.toString();
        }
        return str;
    }

    public final void moduleDeclaration() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 111) {
            this.annotation();
        }
        if (this.LA(1) == 120 && this.LA(2) == 120 && this.isNextKeyword("open")) {
            this.match(120);
        } else if (this.LA(1) != 120 || this.LA(2) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (!this.isNextKeyword("module")) {
            throw new SemanticException(" isNextKeyword(\"module\") ");
        }
        this.match(120);
        this.identifier();
        this.match(69);
        while (this.LA(1) == 120) {
            this.moduleDirective();
        }
        this.match(70);
    }

    public final void moduleDirective() throws RecognitionException, TokenStreamException {
        boolean synPredMatched14 = false;
        if (this.LA(1) == 120 && (this.LA(2) == 45 || this.LA(2) == 120)) {
            int _m14 = this.mark();
            synPredMatched14 = true;
            ++this.inputState.guessing;
            try {
                this.requiresDirective();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched14 = false;
            }
            this.rewind(_m14);
            --this.inputState.guessing;
        }
        if (synPredMatched14) {
            this.requiresDirective();
        } else {
            boolean synPredMatched16 = false;
            if (this.LA(1) == 120 && this.LA(2) == 120) {
                int _m16 = this.mark();
                synPredMatched16 = true;
                ++this.inputState.guessing;
                try {
                    this.exportsDirective();
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched16 = false;
                }
                this.rewind(_m16);
                --this.inputState.guessing;
            }
            if (synPredMatched16) {
                this.exportsDirective();
            } else {
                boolean synPredMatched18 = false;
                if (this.LA(1) == 120 && this.LA(2) == 120) {
                    int _m18 = this.mark();
                    synPredMatched18 = true;
                    ++this.inputState.guessing;
                    try {
                        this.opensDirective();
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched18 = false;
                    }
                    this.rewind(_m18);
                    --this.inputState.guessing;
                }
                if (synPredMatched18) {
                    this.opensDirective();
                } else {
                    boolean synPredMatched20 = false;
                    if (this.LA(1) == 120 && this.LA(2) == 120) {
                        int _m20 = this.mark();
                        synPredMatched20 = true;
                        ++this.inputState.guessing;
                        try {
                            this.usesDirective();
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched20 = false;
                        }
                        this.rewind(_m20);
                        --this.inputState.guessing;
                    }
                    if (synPredMatched20) {
                        this.usesDirective();
                    } else {
                        boolean synPredMatched22 = false;
                        if (this.LA(1) == 120 && this.LA(2) == 120) {
                            int _m22 = this.mark();
                            synPredMatched22 = true;
                            ++this.inputState.guessing;
                            try {
                                this.providesDirective();
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched22 = false;
                            }
                            this.rewind(_m22);
                            --this.inputState.guessing;
                        }
                        if (synPredMatched22) {
                            this.providesDirective();
                        } else {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                }
            }
        }
    }

    public final void requiresDirective() throws RecognitionException, TokenStreamException {
        if (!this.isNextKeyword("requires")) {
            throw new SemanticException(" isNextKeyword(\"requires\") ");
        }
        this.match(120);
        if (this.LA(1) == 120 && this.LA(2) == 120 && this.isNextKeyword("transitive")) {
            this.match(120);
        } else if (this.LA(1) == 45) {
            this.match(45);
        } else if (this.LA(1) != 120 || this.LA(2) != 109 && this.LA(2) != 133) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.identifier();
        this.match(109);
    }

    public final void exportsDirective() throws RecognitionException, TokenStreamException {
        if (!this.isNextKeyword("exports")) {
            throw new SemanticException(" isNextKeyword(\"exports\") ");
        }
        this.match(120);
        this.identifier();
        if (this.LA(1) == 120 && this.isNextKeyword("to")) {
            this.match(120);
            this.identifier();
            while (this.LA(1) == 73) {
                this.match(73);
                this.identifier();
            }
        } else if (this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(109);
    }

    public final void opensDirective() throws RecognitionException, TokenStreamException {
        if (!this.isNextKeyword("opens")) {
            throw new SemanticException(" isNextKeyword(\"opens\") ");
        }
        this.match(120);
        this.identifier();
        if (this.LA(1) == 120 && this.isNextKeyword("to")) {
            this.match(120);
            this.identifier();
            while (this.LA(1) == 73) {
                this.match(73);
                this.identifier();
            }
        } else if (this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(109);
    }

    public final void usesDirective() throws RecognitionException, TokenStreamException {
        if (!this.isNextKeyword("uses")) {
            throw new SemanticException(" isNextKeyword(\"uses\") ");
        }
        this.match(120);
        this.identifier();
        this.match(109);
    }

    public final void providesDirective() throws RecognitionException, TokenStreamException {
        if (!this.isNextKeyword("provides")) {
            throw new SemanticException(" isNextKeyword(\"provides\") ");
        }
        this.match(120);
        this.identifier();
        if (!this.isNextKeyword("with")) {
            throw new SemanticException(" isNextKeyword(\"with\") ");
        }
        this.match(120);
        this.identifier();
        while (this.LA(1) == 73) {
            this.match(73);
            this.identifier();
        }
        this.match(109);
    }

    public final void compilationUnit() throws RecognitionException, TokenStreamException {
        boolean synPredMatched40 = false;
        if ((this.LA(1) == 39 || this.LA(1) == 111) && this.LA(2) == 120) {
            int _m40 = this.mark();
            synPredMatched40 = true;
            ++this.inputState.guessing;
            try {
                this.packageDefinition();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched40 = false;
            }
            this.rewind(_m40);
            --this.inputState.guessing;
        }
        if (synPredMatched40) {
            this.packageDefinition();
        } else if (this.LA(1) != 1 && this.LA(1) != 10 && this.LA(1) != 18 && this.LA(1) != 24 && this.LA(1) != 26 && this.LA(1) != 32 && this.LA(1) != 35 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 63 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 1 && this.LA(2) != 10 && this.LA(2) != 18 && this.LA(2) != 24 && this.LA(2) != 26 && this.LA(2) != 35 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 109 && this.LA(2) != 111 && this.LA(2) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 32) {
            this.importDefinition();
        }
        boolean synPredMatched45 = false;
        if ((this.LA(1) == 111 || this.LA(1) == 120) && this.LA(2) == 120) {
            int _m45 = this.mark();
            synPredMatched45 = true;
            ++this.inputState.guessing;
            try {
                this.moduleDeclarationPredicate();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched45 = false;
            }
            this.rewind(_m45);
            --this.inputState.guessing;
        }
        if (synPredMatched45) {
            this.moduleDeclaration();
        } else if (!(this.LA(1) != 1 && this.LA(1) != 10 && this.LA(1) != 18 && this.LA(1) != 24 && this.LA(1) != 26 && this.LA(1) != 35 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 63 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 1 && this.LA(2) != 10 && this.LA(2) != 18 && this.LA(2) != 24 && this.LA(2) != 26 && this.LA(2) != 35 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 109 && this.LA(2) != 111 && this.LA(2) != 120)) {
            while (this.LA(1) == 10 || this.LA(1) == 18 || this.LA(1) == 24 || this.LA(1) == 26 || this.LA(1) == 35 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 63 || this.LA(1) == 109 || this.LA(1) == 111 || this.LA(1) == 120) {
                this.typeDefinition(false);
                if (this.inputState.guessing != 0) continue;
                this.topLevelClass = true;
                this.existingFallthroughSuppression = false;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(1);
    }

    public final void packageDefinition() throws RecognitionException, TokenStreamException {
        String pn = "";
        while (this.LA(1) == 111) {
            this.annotation();
        }
        this.match(39);
        pn = this.identifier();
        this.match(109);
        if (this.inputState.guessing == 0) {
            this.fileInfo.setPackageName(pn);
        }
    }

    public final void importDefinition() throws RecognitionException, TokenStreamException {
        this.match(32);
        if (this.LA(1) == 45) {
            this.match(45);
        } else if (this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.identifierStar();
        this.match(109);
    }

    public final void typeDefinition(boolean nested) throws RecognitionException, TokenStreamException {
        CloverToken first = null;
        Modifiers mods = null;
        boolean synPredMatched56 = false;
        if (this.LA(1) == 10 || this.LA(1) == 18 || this.LA(1) == 24 || this.LA(1) == 26 || this.LA(1) == 35 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 63 || this.LA(1) == 111 || this.LA(1) == 120) {
            int _m56 = this.mark();
            synPredMatched56 = true;
            ++this.inputState.guessing;
            try {
                this.classOrInterfaceModifiers(false);
                if (this.LA(1) == 18) {
                    this.match(18);
                } else if (this.LA(1) == 35) {
                    this.match(35);
                } else if (this.LA(1) == 111) {
                    this.match(111);
                    this.match(35);
                } else if (this.LA(1) == 24) {
                    this.match(24);
                } else if (!this.isCurrentKeyword("record")) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            catch (RecognitionException recognitionException) {
                synPredMatched56 = false;
            }
            this.rewind(_m56);
            --this.inputState.guessing;
        }
        if (synPredMatched56) {
            if (this.inputState.guessing == 0) {
                this.pushHeadIdentifierStack();
                first = this.lt(1);
            }
            mods = this.classOrInterfaceModifiers(!nested);
            this.typeDefinition2(mods, first, nested);
        } else if (this.LA(1) == 109) {
            this.match(109);
            if (this.inputState.guessing == 0) {
                this.popHeadIdentifierStack();
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void identifierStar() throws RecognitionException, TokenStreamException {
        this.match(120);
        while (this.LA(1) == 133 && this.LA(2) == 120) {
            this.match(133);
            this.match(120);
        }
        if (this.LA(1) == 133) {
            this.match(133);
            this.match(87);
        } else if (this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final Modifiers classOrInterfaceModifiers(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Modifiers mods = new Modifiers();
        long m = 0L;
        AnnotationImpl ann = null;
        while (true) {
            if (!(this.LA(1) != 10 && this.LA(1) != 26 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 63 && this.LA(1) != 120 || this.LA(2) != 10 && this.LA(2) != 18 && this.LA(2) != 24 && this.LA(2) != 26 && this.LA(2) != 35 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 63 && this.LA(2) != 111 && this.LA(2) != 120)) {
                m = this.classOrInterfaceModifier();
                if (this.inputState.guessing != 0) continue;
                mods.setMask(mods.getMask() | m);
                continue;
            }
            if (this.LA(1) != 111 || this.LA(2) != 120) break;
            ann = this.annotation2(instrSuppressWarnings);
            if (this.inputState.guessing != 0) continue;
            mods.addAnnotation(ann);
        }
        return mods;
    }

    public final void typeDefinition2(Modifiers mods, CloverToken first, boolean nested) throws RecognitionException, TokenStreamException {
        boolean isEnum = false;
        if (this.LA(1) == 18) {
            this.classDefinition(mods);
        } else {
            boolean synPredMatched60 = false;
            if (this.LA(1) == 120) {
                int _m60 = this.mark();
                synPredMatched60 = true;
                ++this.inputState.guessing;
                try {
                    if (!this.isCurrentKeyword("record")) {
                        throw new SemanticException(" isCurrentKeyword(\"record\") ");
                    }
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched60 = false;
                }
                this.rewind(_m60);
                --this.inputState.guessing;
            }
            if (synPredMatched60) {
                this.recordDefinition(mods);
            } else if (this.LA(1) == 35) {
                this.interfaceDefinition(mods);
            } else if (this.LA(1) == 24) {
                this.enumDefinition(mods);
                if (this.inputState.guessing == 0) {
                    isEnum = true;
                }
            } else if (this.LA(1) == 111) {
                this.annotationTypeDeclaration(mods);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0 && !nested) {
            this.instrStaticRecorderMember(isEnum);
            this.instrSuppressWarnings(first);
        }
    }

    public final String classDefinition(Modifiers mods) throws RecognitionException, TokenStreamException {
        Token id = null;
        CloverToken first = this.lt(0);
        Map<String, List<String>> tags = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        String superclass = null;
        ClassEntryNode classEntry = null;
        String classname = null;
        this.match(18);
        if (this.inputState.guessing == 0) {
            tags = TokenListUtil.getJDocTagsAndValuesOnBlock(first);
            deprecated = this.maybeEnterDeprecated(first);
        }
        id = this.LT(1);
        this.match(120);
        if (this.LA(1) == 100) {
            this.typeParameters();
        } else if (this.LA(1) != 25 && this.LA(1) != 31 && this.LA(1) != 69 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        superclass = this.superClassClause();
        this.implementsClause();
        this.permitsClause(mods);
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass(tags, mods, this.ct(id), false, false, false, superclass);
        }
        endOfBlock = this.classBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            classname = id.getText();
        }
        return classname;
    }

    public final String recordDefinition(Modifiers mods) throws RecognitionException, TokenStreamException {
        Token id = null;
        CloverToken first = this.lt(0);
        Map<String, List<String>> tags = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        String superclass = null;
        ClassEntryNode classEntry = null;
        String recordName = null;
        if ((mods.getMask() & 0x800000000L) == 0L) {
            throw new SemanticException(" (mods.getMask() & com.atlassian.clover.registry.entities.ModifierExt.RECORD) != 0 ");
        }
        if (this.inputState.guessing == 0) {
            tags = TokenListUtil.getJDocTagsAndValuesOnBlock(first);
            deprecated = this.maybeEnterDeprecated(first);
        }
        id = this.LT(1);
        this.match(120);
        this.match(65);
        this.parameterDeclarationList();
        this.match(66);
        superclass = this.superClassClause();
        this.implementsClause();
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass(tags, mods, this.ct(id), false, false, false, superclass);
        }
        endOfBlock = this.classBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            recordName = id.getText();
        }
        return recordName;
    }

    public final String interfaceDefinition(Modifiers mods) throws RecognitionException, TokenStreamException {
        Token id = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        this.match(35);
        if (this.inputState.guessing == 0) {
            deprecated = this.maybeEnterDeprecated(this.lt(0));
        }
        id = this.LT(1);
        this.match(120);
        if (this.LA(1) == 100) {
            this.typeParameters();
        } else if (this.LA(1) != 25 && this.LA(1) != 69 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass(mods, this.ct(id), true, false, false);
        }
        this.interfaceExtends();
        this.permitsClause(mods);
        endOfBlock = this.classBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            name = id.getText();
        }
        return name;
    }

    public final String enumDefinition(Modifiers mods) throws RecognitionException, TokenStreamException {
        Token id = null;
        boolean deprecated = false;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        this.match(24);
        if (this.inputState.guessing == 0) {
            deprecated = this.maybeEnterDeprecated(this.lt(0));
        }
        id = this.LT(1);
        this.match(120);
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass(mods, this.ct(id), false, true, false);
        }
        this.implementsClause();
        endOfBlock = this.enumBlock(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            this.maybeExitDeprecated(deprecated);
            name = id.getText();
        }
        return name;
    }

    public final String annotationTypeDeclaration(Modifiers mods) throws RecognitionException, TokenStreamException {
        Token id = null;
        CloverToken endOfBlock = null;
        ClassEntryNode classEntry = null;
        String name = null;
        this.match(111);
        this.match(35);
        id = this.LT(1);
        this.match(120);
        if (this.inputState.guessing == 0) {
            classEntry = this.enterClass(mods, this.ct(id), false, false, true);
        }
        endOfBlock = this.annotationTypeBody(classEntry);
        if (this.inputState.guessing == 0) {
            this.exitClass(endOfBlock, classEntry);
            name = id.getText();
        }
        return name;
    }

    public final int declaration() throws RecognitionException, TokenStreamException {
        this.fieldModifiers(false);
        this.typeSpec();
        int complexity = this.variableDefinitions();
        return complexity;
    }

    public final Modifiers fieldModifiers(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Modifiers mods = new Modifiers();
        long m = 0L;
        AnnotationImpl ann = null;
        while (true) {
            if (this.LA(1) == 26 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 45 || this.LA(1) == 53 || this.LA(1) == 56) {
                m = this.fieldModifier();
                if (this.inputState.guessing != 0) continue;
                mods.setMask(mods.getMask() | m);
                continue;
            }
            if (this.LA(1) != 111 || this.LA(2) != 120) break;
            ann = this.annotation2(instrSuppressWarnings);
            if (this.inputState.guessing != 0) continue;
            mods.addAnnotation(ann);
        }
        return mods;
    }

    public final String typeSpec() throws RecognitionException, TokenStreamException {
        String spec;
        while (this.LA(1) == 111 && this.LA(2) == 120) {
            this.annotation();
        }
        if (this.LA(1) == 111 || this.LA(1) == 120) {
            spec = this.classTypeSpec();
        } else if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 44 || this.LA(1) == 55) {
            spec = this.builtInTypeSpec();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return spec;
    }

    public final int variableDefinitions() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = 0;
        complexity = this.variableDeclarator();
        while (this.LA(1) == 73) {
            this.match(73);
            tmpComplexity = this.variableDeclarator();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final String classTypeSpec() throws RecognitionException, TokenStreamException {
        String arrayOpt = "";
        String typeSpec = this.classOrInterfaceType();
        arrayOpt = this.arraySpecOpt();
        if (this.inputState.guessing == 0) {
            typeSpec = String.valueOf(typeSpec) + arrayOpt;
        }
        return typeSpec;
    }

    public final String builtInTypeSpec() throws RecognitionException, TokenStreamException {
        String arrayOpt = "";
        String spec = this.builtInType();
        arrayOpt = this.arraySpecOpt();
        if (this.inputState.guessing == 0) {
            spec = String.valueOf(spec) + arrayOpt;
        }
        return spec;
    }

    public final String arraySpecOpt() throws RecognitionException, TokenStreamException {
        String brackets = "";
        while (!(this.LA(1) != 67 && this.LA(1) != 111 || this.LA(2) != 68 && this.LA(2) != 120)) {
            while (this.LA(1) == 111) {
                this.annotation();
            }
            this.match(67);
            this.match(68);
            if (this.inputState.guessing != 0) continue;
            brackets = String.valueOf(brackets) + "[]";
        }
        return brackets;
    }

    public final String classOrInterfaceType() throws RecognitionException, TokenStreamException {
        CloverToken first = null;
        CloverToken last = null;
        String type = null;
        if (this.inputState.guessing == 0) {
            first = this.lt(1);
        }
        while (this.LA(1) == 111) {
            this.annotation();
        }
        this.match(120);
        if (this.LA(1) == 100) {
            this.typeArguments();
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 25 && this.LA(1) != 28 && this.LA(1) != 31 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 55 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 69 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 78 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 85 && this.LA(1) != 88 && this.LA(1) != 90 && this.LA(1) != 91 && this.LA(1) != 92 && this.LA(1) != 93 && this.LA(1) != 94 && this.LA(1) != 96 && this.LA(1) != 98 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 106 && this.LA(1) != 107 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 && this.LA(1) != 132 && this.LA(1) != 133) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 133 && this.LA(2) == 120) {
            this.match(133);
            this.match(120);
            if (this.LA(1) == 100) {
                this.typeArguments();
                continue;
            }
            if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 25 || this.LA(1) == 28 || this.LA(1) == 31 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 55 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 69 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 78 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 85 || this.LA(1) == 88 || this.LA(1) == 90 || this.LA(1) == 91 || this.LA(1) == 92 || this.LA(1) == 93 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 98 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 104 || this.LA(1) == 105 || this.LA(1) == 106 || this.LA(1) == 107 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 111 || this.LA(1) == 120 || this.LA(1) == 132 || this.LA(1) == 133) continue;
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            last = this.lt(0);
            type = TokenListUtil.getNormalisedSequence(first, last);
        }
        return type;
    }

    public final void typeArguments() throws RecognitionException, TokenStreamException {
        int currentLtLevel = 0;
        if (this.inputState.guessing == 0) {
            currentLtLevel = this.ltCounter;
        }
        this.match(100);
        if (this.inputState.guessing == 0) {
            ++this.ltCounter;
        }
        if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 64 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 25 && this.LA(2) != 28 && this.LA(2) != 31 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 55 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 78 && this.LA(2) != 80 && this.LA(2) != 82 && this.LA(2) != 85 && this.LA(2) != 88 && this.LA(2) != 90 && this.LA(2) != 91 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 96 && this.LA(2) != 98 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 132 && this.LA(2) != 133)) {
            this.singleTypeArgument();
            while (this.LA(1) == 73 && (this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 44 || this.LA(2) == 55 || this.LA(2) == 64 || this.LA(2) == 111 || this.LA(2) == 120)) {
                this.match(73);
                this.singleTypeArgument();
            }
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 25 && this.LA(1) != 28 && this.LA(1) != 31 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 55 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 69 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 78 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 85 && this.LA(1) != 88 && this.LA(1) != 90 && this.LA(1) != 91 && this.LA(1) != 92 && this.LA(1) != 93 && this.LA(1) != 94 && this.LA(1) != 96 && this.LA(1) != 98 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 106 && this.LA(1) != 107 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 && this.LA(1) != 132 && this.LA(1) != 133 || !_tokenSet_0.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (!(this.LA(1) != 91 && this.LA(1) != 93 && this.LA(1) != 96 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 25 && this.LA(2) != 28 && this.LA(2) != 31 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 55 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 78 && this.LA(2) != 80 && this.LA(2) != 82 && this.LA(2) != 85 && this.LA(2) != 88 && this.LA(2) != 90 && this.LA(2) != 91 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 96 && this.LA(2) != 98 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 132 && this.LA(2) != 133)) {
            this.typeArgumentsEnd();
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 25 && this.LA(1) != 28 && this.LA(1) != 31 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 55 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 69 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 78 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 85 && this.LA(1) != 88 && this.LA(1) != 90 && this.LA(1) != 91 && this.LA(1) != 92 && this.LA(1) != 93 && this.LA(1) != 94 && this.LA(1) != 96 && this.LA(1) != 98 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 106 && this.LA(1) != 107 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 && this.LA(1) != 132 && this.LA(1) != 133 || !_tokenSet_0.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (currentLtLevel == 0 && this.ltCounter != currentLtLevel) {
            throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void singleTypeArgument() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 111 && this.LA(2) == 120) {
            this.annotation();
        }
        if (this.LA(1) == 111 || this.LA(1) == 120) {
            this.classTypeSpec();
        } else if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 44 || this.LA(1) == 55) {
            this.builtInTypeSpec();
        } else {
            if (this.LA(1) != 64) throw new NoViableAltException(this.LT(1), this.getFilename());
            this.match(64);
        }
        if (!(this.LA(1) != 25 && this.LA(1) != 47 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 44 && this.LA(2) != 55 && this.LA(2) != 64 && this.LA(2) != 111 && this.LA(2) != 120)) {
            if (this.LA(1) == 25) {
                this.match(25);
            } else {
                if (this.LA(1) != 47) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(47);
            }
            while (this.LA(1) == 111 && this.LA(2) == 120) {
                this.annotation();
            }
            if (this.LA(1) == 111 || this.LA(1) == 120) {
                this.classTypeSpec();
                return;
            } else if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 44 || this.LA(1) == 55) {
                this.builtInTypeSpec();
                return;
            } else {
                if (this.LA(1) != 64) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(64);
            }
            return;
        } else {
            if ((this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 25 || this.LA(1) == 28 || this.LA(1) == 31 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 55 || this.LA(1) == 64 || this.LA(1) == 65 || this.LA(1) == 66 || this.LA(1) == 67 || this.LA(1) == 68 || this.LA(1) == 69 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 72 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 78 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 85 || this.LA(1) == 88 || this.LA(1) == 90 || this.LA(1) == 91 || this.LA(1) == 92 || this.LA(1) == 93 || this.LA(1) == 94 || this.LA(1) == 96 || this.LA(1) == 98 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 104 || this.LA(1) == 105 || this.LA(1) == 106 || this.LA(1) == 107 || this.LA(1) == 108 || this.LA(1) == 109 || this.LA(1) == 111 || this.LA(1) == 120 || this.LA(1) == 132 || this.LA(1) == 133) && _tokenSet_0.member(this.LA(2))) return;
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    protected final void typeArgumentsEnd() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 96) {
            this.match(96);
            if (this.inputState.guessing == 0) {
                --this.ltCounter;
            }
        } else if (this.LA(1) == 91) {
            this.match(91);
            if (this.inputState.guessing == 0) {
                this.ltCounter -= 2;
            }
        } else if (this.LA(1) == 93) {
            this.match(93);
            if (this.inputState.guessing == 0) {
                this.ltCounter -= 3;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final String builtInType() throws RecognitionException, TokenStreamException {
        String type = "";
        if (this.LA(1) == 55) {
            this.match(55);
        } else if (this.LA(1) == 12) {
            this.match(12);
        } else if (this.LA(1) == 14) {
            this.match(14);
        } else if (this.LA(1) == 17) {
            this.match(17);
        } else if (this.LA(1) == 44) {
            this.match(44);
        } else if (this.LA(1) == 34) {
            this.match(34);
        } else if (this.LA(1) == 28) {
            this.match(28);
        } else if (this.LA(1) == 36) {
            this.match(36);
        } else if (this.LA(1) == 22) {
            this.match(22);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            type = this.LT(0).getText();
        }
        return type;
    }

    public final void type() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 111 && this.LA(2) == 120) {
            this.annotation();
        }
        if (this.LA(1) == 111 || this.LA(1) == 120) {
            this.classOrInterfaceType();
        } else if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 44 || this.LA(1) == 55) {
            this.builtInType();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final long classOrInterfaceModifier() throws RecognitionException, TokenStreamException {
        long m = 0L;
        if (this.LA(1) == 40) {
            this.match(40);
            if (this.inputState.guessing == 0) {
                m = 2L;
            }
        } else if (this.LA(1) == 41) {
            this.match(41);
            if (this.inputState.guessing == 0) {
                m = 4L;
            }
        } else if (this.LA(1) == 42) {
            this.match(42);
            if (this.inputState.guessing == 0) {
                m = 1L;
            }
        } else if (this.LA(1) == 10) {
            this.match(10);
            if (this.inputState.guessing == 0) {
                m = 1024L;
            }
        } else if (this.LA(1) == 26) {
            this.match(26);
            if (this.inputState.guessing == 0) {
                m = 16L;
            }
        } else if (this.LA(1) == 45) {
            this.match(45);
            if (this.inputState.guessing == 0) {
                m = 8L;
            }
        } else if (this.LA(1) == 46) {
            this.match(46);
            if (this.inputState.guessing == 0) {
                m = 2048L;
            }
        } else if (this.LA(1) == 63) {
            this.match(63);
            if (this.inputState.guessing == 0) {
                m = 0x400000000L;
            }
        } else if (this.LA(1) == 120 && (this.LA(2) == 10 || this.LA(2) == 18 || this.LA(2) == 24 || this.LA(2) == 26 || this.LA(2) == 35 || this.LA(2) == 40 || this.LA(2) == 41 || this.LA(2) == 42 || this.LA(2) == 45 || this.LA(2) == 46 || this.LA(2) == 63 || this.LA(2) == 111 || this.LA(2) == 120) && this.isNextKeyword("sealed")) {
            this.match(120);
            if (this.inputState.guessing == 0) {
                m = 0x200000000L;
            }
        } else if (this.LA(1) == 120 && (this.LA(2) == 10 || this.LA(2) == 18 || this.LA(2) == 24 || this.LA(2) == 26 || this.LA(2) == 35 || this.LA(2) == 40 || this.LA(2) == 41 || this.LA(2) == 42 || this.LA(2) == 45 || this.LA(2) == 46 || this.LA(2) == 63 || this.LA(2) == 111 || this.LA(2) == 120) && this.isNextKeyword("record")) {
            this.match(120);
            if (this.inputState.guessing == 0) {
                m = 0x800000000L;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return m;
    }

    protected final AnnotationImpl annotation2(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Token lparen = null;
        boolean isSuppressWarnings = false;
        CloverToken ident = null;
        boolean hasArgs = false;
        String annotationName = null;
        AnnotationImpl anno = new AnnotationImpl();
        this.match(111);
        annotationName = this.identifier();
        if (this.inputState.guessing == 0) {
            ident = this.lt(0);
            isSuppressWarnings = instrSuppressWarnings && "SuppressWarnings".equals(annotationName);
            anno.setName(annotationName);
        }
        if (this.LA(1) == 65 && this.LA(2) == 66) {
            lparen = this.LT(1);
            this.match(65);
            this.match(66);
        } else {
            boolean synPredMatched530 = false;
            if (this.LA(1) == 65 && this.LA(2) == 120) {
                int _m530 = this.mark();
                synPredMatched530 = true;
                ++this.inputState.guessing;
                try {
                    this.match(65);
                    this.match(120);
                    this.match(74);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched530 = false;
                }
                this.rewind(_m530);
                --this.inputState.guessing;
            }
            if (synPredMatched530) {
                this.match(65);
                this.annMemberValuePair(anno, isSuppressWarnings);
                while (this.LA(1) == 73) {
                    this.match(73);
                    this.annMemberValuePair(anno, false);
                }
                this.match(66);
                if (this.inputState.guessing == 0) {
                    hasArgs = true;
                }
            } else if (this.LA(1) == 65 && (this.LA(2) == 4 || this.LA(2) == 5 || this.LA(2) == 6 || this.LA(2) == 7 || this.LA(2) == 8 || this.LA(2) == 9 || this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 38 || this.LA(2) == 44 || this.LA(2) == 47 || this.LA(2) == 48 || this.LA(2) == 50 || this.LA(2) == 55 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 65 || this.LA(2) == 69 || this.LA(2) == 76 || this.LA(2) == 77 || this.LA(2) == 81 || this.LA(2) == 83 || this.LA(2) == 84 || this.LA(2) == 86 || this.LA(2) == 111 || this.LA(2) == 120)) {
                this.match(65);
                this.annMemberValue2(anno, "value", isSuppressWarnings, true);
                this.match(66);
                if (this.inputState.guessing == 0) {
                    hasArgs = true;
                }
            } else if (this.LA(1) != 10 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 18 && this.LA(1) != 20 && this.LA(1) != 22 && this.LA(1) != 24 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 35 && this.LA(1) != 36 && this.LA(1) != 37 && this.LA(1) != 39 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 49 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 63 && this.LA(1) != 64 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 70 && this.LA(1) != 73 && this.LA(1) != 100 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0 && isSuppressWarnings && !hasArgs) {
            this.suppressWarningsInstr = new SimpleEmitter("{\"fallthrough\"}");
            SimpleEmitter openParen = new SimpleEmitter("(");
            SimpleEmitter closeParen = new SimpleEmitter(")");
            CloverToken instrPoint = this.ct(lparen);
            if (instrPoint == null) {
                instrPoint = ident;
                this.suppressWarningsInstr.addDependent(openParen);
                this.suppressWarningsInstr.addDependent(closeParen);
                instrPoint.addPostEmitter(openParen);
            }
            instrPoint.addPostEmitter(this.suppressWarningsInstr);
            if (lparen == null) {
                instrPoint.addPostEmitter(closeParen);
            }
        }
        return anno;
    }

    public final int fieldModifier() throws RecognitionException, TokenStreamException {
        int m = 0;
        if (this.LA(1) == 40) {
            this.match(40);
            if (this.inputState.guessing == 0) {
                m = 2;
            }
        } else if (this.LA(1) == 41) {
            this.match(41);
            if (this.inputState.guessing == 0) {
                m = 4;
            }
        } else if (this.LA(1) == 42) {
            this.match(42);
            if (this.inputState.guessing == 0) {
                m = 1;
            }
        } else if (this.LA(1) == 26) {
            this.match(26);
            if (this.inputState.guessing == 0) {
                m = 16;
            }
        } else if (this.LA(1) == 45) {
            this.match(45);
            if (this.inputState.guessing == 0) {
                m = 8;
            }
        } else if (this.LA(1) == 53) {
            this.match(53);
            if (this.inputState.guessing == 0) {
                m = 128;
            }
        } else if (this.LA(1) == 56) {
            this.match(56);
            if (this.inputState.guessing == 0) {
                m = 64;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return m;
    }

    public final MethodSignatureExt methodSignature(Map tags, CloverToken first, boolean isPredicate) throws RecognitionException, TokenStreamException {
        Token methodName = null;
        Modifiers mods = null;
        boolean deprecated = false;
        String typeParam = null;
        String returnType = "";
        Parameter[] parameters = null;
        String brackets = "";
        String[] throwsTypes = null;
        MethodSignatureExt signatureExt = MethodSignatureExt.of(null, null, null);
        mods = this.methodModifiers(false);
        if (this.inputState.guessing == 0 && !isPredicate) {
            deprecated = this.maybeEnterDeprecated(tags, mods);
        }
        if (this.LA(1) == 100) {
            typeParam = this.typeParameters();
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 111 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        returnType = this.typeSpec();
        methodName = this.LT(1);
        this.match(120);
        this.match(65);
        parameters = this.parameterDeclarationList();
        this.match(66);
        brackets = this.declaratorBrackets();
        if (this.LA(1) == 52) {
            throwsTypes = this.throwsClause();
        } else if (this.LA(1) != 69 && this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            CloverToken endSig = this.lt(0);
            MethodSignature signature = new MethodSignature(first, this.ct(methodName), endSig, tags, mods, methodName.getText(), typeParam, String.valueOf(returnType) + brackets, parameters, throwsTypes);
            signatureExt = MethodSignatureExt.of(signature, endSig, deprecated);
        }
        return signatureExt;
    }

    public final Modifiers methodModifiers(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Modifiers mods = new Modifiers();
        long m = 0L;
        AnnotationImpl ann = null;
        while (true) {
            if (this.LA(1) == 10 || this.LA(1) == 20 || this.LA(1) == 26 || this.LA(1) == 37 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 49) {
                m = this.methodModifier();
                if (this.inputState.guessing != 0) continue;
                mods.setMask(mods.getMask() | m);
                continue;
            }
            if (this.LA(1) != 111 || this.LA(2) != 120) break;
            ann = this.annotation2(instrSuppressWarnings);
            if (this.inputState.guessing != 0) continue;
            mods.addAnnotation(ann);
        }
        return mods;
    }

    public final String typeParameters() throws RecognitionException, TokenStreamException {
        int currentLtLevel = 0;
        CloverToken start = this.lt(1);
        String asString = null;
        if (this.inputState.guessing == 0) {
            currentLtLevel = this.ltCounter;
        }
        this.match(100);
        if (this.inputState.guessing == 0) {
            ++this.ltCounter;
        }
        this.typeParameter();
        while (this.LA(1) == 73) {
            this.match(73);
            this.typeParameter();
        }
        if (this.LA(1) == 91 || this.LA(1) == 93 || this.LA(1) == 96) {
            this.typeArgumentsEnd();
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 25 && this.LA(1) != 28 && this.LA(1) != 31 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 69 && this.LA(1) != 111 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (currentLtLevel == 0 && this.ltCounter != currentLtLevel) {
            throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
        }
        if (this.inputState.guessing == 0) {
            asString = TokenListUtil.getNormalisedSequence(start, this.lt(0));
        }
        return asString;
    }

    public final Parameter[] parameterDeclarationList() throws RecognitionException, TokenStreamException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter param = null;
        Parameter[] params = new Parameter[]{};
        if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 26 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 44 || this.LA(1) == 55 || this.LA(1) == 111 || this.LA(1) == 120) {
            param = this.parameterDeclaration();
            if (this.inputState.guessing == 0) {
                parameters.add(param);
            }
            while (this.LA(1) == 73) {
                this.match(73);
                param = this.parameterDeclaration();
                if (this.inputState.guessing != 0) continue;
                parameters.add(param);
            }
        } else if (this.LA(1) != 66) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            params = parameters.toArray(new Parameter[parameters.size()]);
        }
        return params;
    }

    public final String declaratorBrackets() throws RecognitionException, TokenStreamException {
        String brackets = "";
        while (this.LA(1) == 67 || this.LA(1) == 111) {
            while (this.LA(1) == 111) {
                this.annotation();
            }
            this.match(67);
            this.match(68);
            if (this.inputState.guessing != 0) continue;
            brackets = String.valueOf(brackets) + "[]";
        }
        return brackets;
    }

    public final String[] throwsClause() throws RecognitionException, TokenStreamException {
        ArrayList<String> throwsList = new ArrayList<String>();
        String[] throwsTypes = null;
        this.match(52);
        while (this.LA(1) == 111) {
            this.annotation();
        }
        String id = this.identifier();
        if (this.inputState.guessing == 0) {
            throwsList.add(id);
        }
        while (this.LA(1) == 73) {
            this.match(73);
            while (this.LA(1) == 111) {
                this.annotation();
            }
            id = this.identifier();
            if (this.inputState.guessing != 0) continue;
            throwsList.add(id);
        }
        if (this.inputState.guessing == 0) {
            throwsTypes = throwsList.toArray(new String[throwsList.size()]);
        }
        return throwsTypes;
    }

    public final MethodSignatureExt standardConstructorSignature(Map tags, CloverToken first, boolean isPredicate) throws RecognitionException, TokenStreamException {
        Token constructorName = null;
        Modifiers mods = null;
        boolean deprecated = false;
        Parameter[] params = null;
        String[] throwsTypes = null;
        MethodSignatureExt signatureExt = MethodSignatureExt.of(null, null, null);
        mods = this.constructorModifiers(false);
        if (this.inputState.guessing == 0 && !isPredicate) {
            deprecated = this.maybeEnterDeprecated(tags, mods);
        }
        if (this.LA(1) == 100) {
            this.typeParameters();
        } else if (this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        constructorName = this.LT(1);
        this.match(120);
        this.match(65);
        params = this.parameterDeclarationList();
        this.match(66);
        if (this.LA(1) == 52) {
            throwsTypes = this.throwsClause();
        } else if (this.LA(1) != 69) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            CloverToken endSig = this.lt(0);
            MethodSignature signature = new MethodSignature(first, this.ct(constructorName), endSig, tags, mods, constructorName.getText(), null, null, params, throwsTypes);
            signatureExt = MethodSignatureExt.of(signature, endSig, deprecated);
        }
        return signatureExt;
    }

    public final Modifiers constructorModifiers(boolean instrSuppressWarnings) throws RecognitionException, TokenStreamException {
        Modifiers mods = new Modifiers();
        long m = 0L;
        AnnotationImpl ann = null;
        while (true) {
            if (this.LA(1) >= 40 && this.LA(1) <= 42) {
                m = this.constructorModifier();
                if (this.inputState.guessing != 0) continue;
                mods.setMask(mods.getMask() | m);
                continue;
            }
            if (this.LA(1) != 111) break;
            ann = this.annotation2(instrSuppressWarnings);
            if (this.inputState.guessing != 0) continue;
            mods.addAnnotation(ann);
        }
        return mods;
    }

    public final MethodSignatureExt compactConstructorSignature(Map tags, CloverToken first, boolean isPredicate) throws RecognitionException, TokenStreamException {
        Token constructorName = null;
        Modifiers mods = null;
        boolean deprecated = false;
        MethodSignatureExt signatureExt = MethodSignatureExt.of(null, null, null);
        mods = this.constructorModifiers(false);
        if (this.inputState.guessing == 0 && !isPredicate) {
            deprecated = this.maybeEnterDeprecated(tags, mods);
        }
        if (this.LA(1) == 100) {
            this.typeParameters();
        } else if (this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        constructorName = this.LT(1);
        this.match(120);
        if (this.inputState.guessing == 0) {
            CloverToken endSig = this.lt(0);
            MethodSignature signature = new MethodSignature(first, this.ct(constructorName), endSig, tags, mods, constructorName.getText(), null, null, null, null);
            signatureExt = MethodSignatureExt.of(signature, endSig, deprecated);
        }
        return signatureExt;
    }

    public final int constructorModifier() throws RecognitionException, TokenStreamException {
        int m = 0;
        if (this.LA(1) == 40) {
            this.match(40);
            if (this.inputState.guessing == 0) {
                m = 2;
            }
        } else if (this.LA(1) == 41) {
            this.match(41);
            if (this.inputState.guessing == 0) {
                m = 4;
            }
        } else if (this.LA(1) == 42) {
            this.match(42);
            if (this.inputState.guessing == 0) {
                m = 1;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return m;
    }

    public final long methodModifier() throws RecognitionException, TokenStreamException {
        long m = 0L;
        if (this.LA(1) == 40) {
            this.match(40);
            if (this.inputState.guessing == 0) {
                m = 2L;
            }
        } else if (this.LA(1) == 41) {
            this.match(41);
            if (this.inputState.guessing == 0) {
                m = 4L;
            }
        } else if (this.LA(1) == 42) {
            this.match(42);
            if (this.inputState.guessing == 0) {
                m = 1L;
            }
        } else if (this.LA(1) == 10) {
            this.match(10);
            if (this.inputState.guessing == 0) {
                m = 1024L;
            }
        } else if (this.LA(1) == 26) {
            this.match(26);
            if (this.inputState.guessing == 0) {
                m = 16L;
            }
        } else if (this.LA(1) == 37) {
            this.match(37);
            if (this.inputState.guessing == 0) {
                m = 256L;
            }
        } else if (this.LA(1) == 45) {
            this.match(45);
            if (this.inputState.guessing == 0) {
                m = 8L;
            }
        } else if (this.LA(1) == 46) {
            this.match(46);
            if (this.inputState.guessing == 0) {
                m = 2048L;
            }
        } else if (this.LA(1) == 49) {
            this.match(49);
            if (this.inputState.guessing == 0) {
                m = 32L;
            }
        } else if (this.LA(1) == 20) {
            this.match(20);
            if (this.inputState.guessing == 0) {
                m = 0x100000000L;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return m;
    }

    public final String superClassClause() throws RecognitionException, TokenStreamException {
        String superclass = null;
        if (this.LA(1) == 25) {
            this.match(25);
            superclass = this.classOrInterfaceType();
        } else if (this.LA(1) != 31 && this.LA(1) != 69 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return superclass;
    }

    public final void implementsClause() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 31) {
            this.match(31);
            this.classOrInterfaceType();
            while (this.LA(1) == 73) {
                this.match(73);
                this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 69 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void permitsClause(Modifiers mods) throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 120 && (mods.getMask() & 0x200000000L) != 0L && this.isNextKeyword("permits")) {
            this.match(120);
            this.classOrInterfaceType();
            while (this.LA(1) == 73) {
                this.match(73);
                this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 69) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final CloverToken classBlock(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        Token rc = null;
        CloverToken t = null;
        ip = this.LT(1);
        this.match(69);
        if (this.inputState.guessing == 0) {
            this.setRecorderMemberInsertPoint(classEntry, this.ct(ip));
        }
        while (true) {
            if (this.LA(1) == 10 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 18 || this.LA(1) == 20 || this.LA(1) == 22 || this.LA(1) == 24 || this.LA(1) == 26 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 35 || this.LA(1) == 36 || this.LA(1) == 37 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 44 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 49 || this.LA(1) == 53 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 63 || this.LA(1) == 69 || this.LA(1) == 100 || this.LA(1) == 111 || this.LA(1) == 120) {
                this.field(classEntry);
                continue;
            }
            if (this.LA(1) != 109) break;
            this.match(109);
        }
        rc = this.LT(1);
        this.match(70);
        if (this.inputState.guessing == 0) {
            t = this.ct(rc);
        }
        return t;
    }

    public final void interfaceExtends() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 25) {
            this.match(25);
            this.classOrInterfaceType();
            while (this.LA(1) == 73) {
                this.match(73);
                this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 69 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final CloverToken enumBlock(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        boolean topLevelSave = this.topLevelClass;
        CloverToken t = null;
        this.match(69);
        if (!(this.LA(1) != 70 && this.LA(1) != 73 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 1 && this.LA(2) != 10 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 18 && this.LA(2) != 20 && this.LA(2) != 22 && this.LA(2) != 24 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 35 && this.LA(2) != 36 && this.LA(2) != 37 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 49 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 73 && this.LA(2) != 100 && this.LA(2) != 109 && this.LA(2) != 111 && this.LA(2) != 120)) {
            if (this.LA(1) == 111 || this.LA(1) == 120) {
                this.enumConstant();
                while (this.LA(1) == 73 && (this.LA(2) == 111 || this.LA(2) == 120)) {
                    this.match(73);
                    this.enumConstant();
                }
            } else if (this.LA(1) != 70 && this.LA(1) != 73 && this.LA(1) != 109) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 73) {
                this.match(73);
            } else if (this.LA(1) != 70 && this.LA(1) != 109) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 109) {
                if (this.inputState.guessing == 0) {
                    topLevelSave = this.topLevelClass;
                    this.topLevelClass = false;
                }
                this.match(109);
                while (true) {
                    if (this.LA(1) == 10 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 18 || this.LA(1) == 20 || this.LA(1) == 22 || this.LA(1) == 24 || this.LA(1) == 26 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 35 || this.LA(1) == 36 || this.LA(1) == 37 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 44 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 49 || this.LA(1) == 53 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 63 || this.LA(1) == 69 || this.LA(1) == 100 || this.LA(1) == 111 || this.LA(1) == 120) {
                        this.field(null);
                        continue;
                    }
                    if (this.LA(1) != 109) break;
                    this.match(109);
                }
                if (this.inputState.guessing == 0) {
                    this.topLevelClass = topLevelSave;
                }
            } else if (this.LA(1) != 70) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        } else if (this.LA(1) != 70 || this.LA(2) != 1 && this.LA(2) != 10 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 18 && this.LA(2) != 20 && this.LA(2) != 22 && this.LA(2) != 24 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 35 && this.LA(2) != 36 && this.LA(2) != 37 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 49 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 63 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 100 && this.LA(2) != 109 && this.LA(2) != 111 && this.LA(2) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        ip = this.LT(1);
        this.match(70);
        if (this.inputState.guessing == 0) {
            t = this.ct(ip);
            this.setRecorderMemberInsertPoint(classEntry, t);
        }
        return t;
    }

    public final CloverToken annotationTypeBody(ClassEntryNode classEntry) throws RecognitionException, TokenStreamException {
        Token ip = null;
        Token endOfBlock = null;
        boolean topLevelSave = this.topLevelClass;
        CloverToken t = null;
        Modifiers mods = null;
        ip = this.LT(1);
        this.match(69);
        if (this.inputState.guessing == 0) {
            this.setRecorderMemberInsertPoint(classEntry, this.ct(ip));
        }
        while (true) {
            boolean synPredMatched172 = false;
            if (!(this.LA(1) != 10 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 20 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 37 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 49 && this.LA(1) != 55 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 10 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 20 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 37 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 49 && this.LA(2) != 55 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                int _m172 = this.mark();
                synPredMatched172 = true;
                ++this.inputState.guessing;
                try {
                    this.methodModifiers(false);
                    this.typeSpec();
                    this.match(120);
                    this.match(65);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched172 = false;
                }
                this.rewind(_m172);
                --this.inputState.guessing;
            }
            if (synPredMatched172) {
                mods = this.methodModifiers(false);
                this.typeSpec();
                this.match(120);
                this.match(65);
                this.match(66);
                if (this.LA(1) == 20) {
                    this.annDefaultValue();
                } else if (this.LA(1) != 109) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(109);
                continue;
            }
            boolean synPredMatched175 = false;
            if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                int _m175 = this.mark();
                synPredMatched175 = true;
                ++this.inputState.guessing;
                try {
                    this.fieldModifiers(false);
                    this.typeSpec();
                    this.variableDeclarator();
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched175 = false;
                }
                this.rewind(_m175);
                --this.inputState.guessing;
            }
            if (synPredMatched175) {
                mods = this.fieldModifiers(false);
                this.typeSpec();
                this.variableDefinitions();
                this.match(109);
                continue;
            }
            boolean synPredMatched178 = false;
            if (!(this.LA(1) != 10 && this.LA(1) != 18 && this.LA(1) != 24 && this.LA(1) != 26 && this.LA(1) != 35 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 63 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 10 && this.LA(2) != 18 && this.LA(2) != 24 && this.LA(2) != 26 && this.LA(2) != 35 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 111 && this.LA(2) != 120)) {
                int _m178 = this.mark();
                synPredMatched178 = true;
                ++this.inputState.guessing;
                try {
                    this.classOrInterfaceModifiers(false);
                    if (this.LA(1) == 18) {
                        this.match(18);
                    } else if (this.LA(1) == 35) {
                        this.match(35);
                    } else if (this.LA(1) == 111) {
                        this.match(111);
                        this.match(35);
                    } else if (this.LA(1) == 24) {
                        this.match(24);
                    } else if (!this.isCurrentKeyword("record")) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched178 = false;
                }
                this.rewind(_m178);
                --this.inputState.guessing;
            }
            if (synPredMatched178) {
                if (this.inputState.guessing == 0) {
                    topLevelSave = this.topLevelClass;
                    this.topLevelClass = false;
                }
                mods = this.classOrInterfaceModifiers(false);
                this.typeDefinition2(mods, null, true);
                if (this.inputState.guessing != 0) continue;
                this.topLevelClass = topLevelSave;
                continue;
            }
            if (this.LA(1) != 109) break;
            this.match(109);
        }
        endOfBlock = this.LT(1);
        this.match(70);
        if (this.inputState.guessing == 0) {
            t = this.ct(endOfBlock);
        }
        return t;
    }

    public final void typeParameter() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 111) {
            this.annotation();
        }
        if (this.LA(1) == 120) {
            this.match(120);
        } else if (this.LA(1) == 64) {
            this.match(64);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 25 && (this.LA(2) == 111 || this.LA(2) == 120)) {
            this.match(25);
            this.classOrInterfaceType();
            while (this.LA(1) == 106) {
                this.match(106);
                this.classOrInterfaceType();
            }
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 25 && this.LA(1) != 28 && this.LA(1) != 31 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 69 && this.LA(1) != 73 && this.LA(1) != 91 && this.LA(1) != 93 && this.LA(1) != 96 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 10 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 18 && this.LA(2) != 20 && this.LA(2) != 22 && this.LA(2) != 24 && this.LA(2) != 25 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 31 && this.LA(2) != 34 && this.LA(2) != 35 && this.LA(2) != 36 && this.LA(2) != 37 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 49 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 67 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 100 && this.LA(2) != 109 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void field(ClassEntryNode containingClass) throws RecognitionException, TokenStreamException {
        CloverToken first = this.lt(1);
        boolean deprecated = false;
        Modifiers mods = null;
        MethodSignature signature = null;
        MethodSignatureExt signatureExt = null;
        Map<String, List<String>> tags = null;
        if (this.inputState.guessing == 0) {
            tags = TokenListUtil.getJDocTagsAndValuesOnBlock(first);
        }
        boolean synPredMatched196 = false;
        if (!(this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 100 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 64 && this.LA(2) != 69 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120)) {
            int _m196 = this.mark();
            synPredMatched196 = true;
            ++this.inputState.guessing;
            try {
                this.compactConstructorSignature(tags, first, true);
                this.match(69);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched196 = false;
            }
            this.rewind(_m196);
            --this.inputState.guessing;
        }
        if (synPredMatched196) {
            signatureExt = this.compactConstructorSignature(tags, first, false);
            this.constructorBody(signatureExt.signature(), first, signatureExt.endToken());
            if (this.inputState.guessing == 0) {
                this.maybeExitDeprecated(signatureExt.isDeprecated());
            }
        } else {
            boolean synPredMatched198 = false;
            if (!(this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 100 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120)) {
                int _m198 = this.mark();
                synPredMatched198 = true;
                ++this.inputState.guessing;
                try {
                    this.standardConstructorSignature(tags, first, true);
                    this.match(69);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched198 = false;
                }
                this.rewind(_m198);
                --this.inputState.guessing;
            }
            if (synPredMatched198) {
                signatureExt = this.standardConstructorSignature(tags, first, false);
                this.constructorBody(signatureExt.signature(), first, signatureExt.endToken());
                if (this.inputState.guessing == 0) {
                    this.maybeExitDeprecated(signatureExt.isDeprecated());
                }
            } else {
                boolean synPredMatched200 = false;
                if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                    int _m200 = this.mark();
                    synPredMatched200 = true;
                    ++this.inputState.guessing;
                    try {
                        this.fieldModifiers(false);
                        this.typeSpec();
                        this.variableDefinitions();
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched200 = false;
                    }
                    this.rewind(_m200);
                    --this.inputState.guessing;
                }
                if (synPredMatched200) {
                    mods = this.fieldModifiers(false);
                    if (this.inputState.guessing == 0) {
                        deprecated = this.maybeEnterDeprecated(tags, mods);
                    }
                    this.typeSpec();
                    this.variableDefinitions();
                    this.match(109);
                    if (this.inputState.guessing == 0) {
                        this.maybeExitDeprecated(deprecated);
                    }
                } else if (this.LA(1) == 45 && this.LA(2) == 69) {
                    if (this.inputState.guessing == 0) {
                        deprecated = this.maybeEnterDeprecated(first);
                        signature = new MethodSignature(null, null, null, "<clinit>, line " + first.getLine(), null, null, null, null);
                    }
                    this.match(45);
                    this.outerCompoundStmt(signature, first, null, 1);
                    if (this.inputState.guessing == 0) {
                        this.maybeExitDeprecated(deprecated);
                    }
                } else if (this.LA(1) == 69) {
                    if (this.inputState.guessing == 0) {
                        deprecated = this.maybeEnterDeprecated(first);
                        signature = new MethodSignature(null, null, null, "<init>, line " + first.getLine(), null, null, null, null);
                    }
                    this.outerCompoundStmt(signature, first, null, 2);
                    if (this.inputState.guessing == 0) {
                        this.maybeExitDeprecated(deprecated);
                    }
                } else {
                    boolean synPredMatched203 = false;
                    if (!(this.LA(1) != 10 && this.LA(1) != 18 && this.LA(1) != 24 && this.LA(1) != 26 && this.LA(1) != 35 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 63 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 10 && this.LA(2) != 18 && this.LA(2) != 24 && this.LA(2) != 26 && this.LA(2) != 35 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 111 && this.LA(2) != 120)) {
                        int _m203 = this.mark();
                        synPredMatched203 = true;
                        ++this.inputState.guessing;
                        try {
                            this.classOrInterfaceModifiers(false);
                            if (this.LA(1) == 18) {
                                this.match(18);
                            } else if (this.LA(1) == 35) {
                                this.match(35);
                            } else if (this.LA(1) == 111) {
                                this.match(111);
                                this.match(35);
                            } else if (this.LA(1) == 24) {
                                this.match(24);
                            } else if (this.LA(1) != 120 || !this.isCurrentKeyword("record")) {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                            this.match(120);
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched203 = false;
                        }
                        this.rewind(_m203);
                        --this.inputState.guessing;
                    }
                    if (synPredMatched203) {
                        mods = this.classOrInterfaceModifiers(false);
                        if (this.inputState.guessing == 0) {
                            deprecated = this.maybeEnterDeprecated(tags, mods);
                        }
                        if (this.LA(1) == 18) {
                            this.classDefinition(mods);
                        } else if (this.LA(1) == 120) {
                            this.recordDefinition(mods);
                        } else if (this.LA(1) == 35) {
                            this.interfaceDefinition(mods);
                        } else if (this.LA(1) == 24) {
                            this.enumDefinition(mods);
                        } else if (this.LA(1) == 111) {
                            this.annotationTypeDeclaration(mods);
                        } else {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        if (this.inputState.guessing == 0) {
                            this.maybeExitDeprecated(deprecated);
                        }
                    } else {
                        boolean synPredMatched207 = false;
                        if (!(this.LA(1) != 10 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 20 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 37 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 49 && this.LA(1) != 55 && this.LA(1) != 100 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 10 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 20 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 37 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 49 && this.LA(2) != 55 && this.LA(2) != 64 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                            int _m207;
                            block66: {
                                _m207 = this.mark();
                                synPredMatched207 = true;
                                ++this.inputState.guessing;
                                try {
                                    this.methodSignature(tags, first, true);
                                    if (this.LA(1) == 69) {
                                        this.match(69);
                                        break block66;
                                    }
                                    if (this.LA(1) == 109) {
                                        this.match(109);
                                        break block66;
                                    }
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched207 = false;
                                }
                            }
                            this.rewind(_m207);
                            --this.inputState.guessing;
                        }
                        if (synPredMatched207) {
                            signatureExt = this.methodSignature(tags, first, false);
                            if (this.LA(1) == 69) {
                                this.outerCompoundStmt(signatureExt.signature(), first, signatureExt.endToken(), 4);
                            } else if (this.LA(1) == 109) {
                                this.match(109);
                            } else {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                            if (this.inputState.guessing == 0) {
                                this.maybeExitDeprecated(signatureExt.isDeprecated());
                            }
                        } else {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                }
            }
        }
    }

    public final void enumConstant() throws RecognitionException, TokenStreamException {
        boolean topLevelSave = this.topLevelClass;
        if (this.inputState.guessing == 0) {
            topLevelSave = this.topLevelClass;
            this.topLevelClass = false;
        }
        while (this.LA(1) == 111) {
            this.annotation();
        }
        this.match(120);
        if (this.LA(1) == 65) {
            this.match(65);
            this.argList();
            this.match(66);
        } else if (this.LA(1) != 69 && this.LA(1) != 70 && this.LA(1) != 73 && this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 69) {
            this.classBlock(null);
        } else if (this.LA(1) != 70 && this.LA(1) != 73 && this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            this.topLevelClass = topLevelSave;
        }
    }

    public final int argList() throws RecognitionException, TokenStreamException {
        int complexity = 0;
        if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
            complexity = this.expressionList();
        } else if (this.LA(1) != 66) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    protected final void annDefaultValue() throws RecognitionException, TokenStreamException {
        this.match(20);
        this.annMemberValue(false, false);
    }

    public final int variableDeclarator() throws RecognitionException, TokenStreamException {
        this.match(120);
        this.declaratorBrackets();
        int complexity = this.varInitializer();
        return complexity;
    }

    protected final boolean annMemberValue(boolean isSuppressWarnings, boolean makeArrayAndAdd) throws RecognitionException, TokenStreamException {
        boolean wasFallthroughLiteral = this.annMemberValue2(null, null, isSuppressWarnings, makeArrayAndAdd);
        return wasFallthroughLiteral;
    }

    public final void constructorBody(MethodSignature signature, CloverToken start, CloverToken endSig) throws RecognitionException, TokenStreamException {
        Token lc = null;
        Token rc = null;
        CloverToken endOfInv = null;
        if (this.inputState.guessing == 0) {
            this.enterContext(3);
        }
        lc = this.LT(1);
        this.match(69);
        boolean synPredMatched212 = false;
        if (!(this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 120 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 67 && this.LA(2) != 72 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 86 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
            int _m212 = this.mark();
            synPredMatched212 = true;
            ++this.inputState.guessing;
            try {
                this.explicitConstructorInvocation();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched212 = false;
            }
            this.rewind(_m212);
            --this.inputState.guessing;
        }
        if (synPredMatched212) {
            endOfInv = this.explicitConstructorInvocation();
        } else if (this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 10 && this.LA(1) != 11 && this.LA(1) != 12 && this.LA(1) != 13 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 18 && this.LA(1) != 19 && this.LA(1) != 21 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 29 && this.LA(1) != 30 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 43 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 50 && this.LA(1) != 51 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 57 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 69 && this.LA(1) != 70 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 10 && this.LA(2) != 11 && this.LA(2) != 12 && this.LA(2) != 13 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 18 && this.LA(2) != 19 && this.LA(2) != 20 && this.LA(2) != 21 && this.LA(2) != 22 && this.LA(2) != 24 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 29 && this.LA(2) != 30 && this.LA(2) != 33 && this.LA(2) != 34 && this.LA(2) != 35 && this.LA(2) != 36 && this.LA(2) != 37 && this.LA(2) != 38 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 43 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 49 && this.LA(2) != 50 && this.LA(2) != 51 && this.LA(2) != 53 && this.LA(2) != 54 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 57 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 69 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 86 && this.LA(2) != 87 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 90 && this.LA(2) != 91 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 95 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 10 || this.LA(1) == 11 || this.LA(1) == 12 || this.LA(1) == 13 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 18 || this.LA(1) == 19 || this.LA(1) == 21 || this.LA(1) == 22 || this.LA(1) == 26 || this.LA(1) == 28 || this.LA(1) == 29 || this.LA(1) == 30 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 43 || this.LA(1) == 44 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 49 || this.LA(1) == 50 || this.LA(1) == 51 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 57 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 69 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 109 || this.LA(1) == 111 || this.LA(1) == 120) {
            this.statement(null);
        }
        rc = this.LT(1);
        this.match(70);
        if (this.inputState.guessing == 0) {
            MethodEntryInstrEmitter entry = this.instrEnterMethod(signature, start, this.ct(lc), endOfInv);
            this.instrExitMethod(entry, this.ct(rc));
            this.exitContext();
            this.fileInfo.addMethodMarker(entry, start, endSig, this.ct(rc));
        }
    }

    public final void outerCompoundStmt(MethodSignature sig, CloverToken start, CloverToken endSig, int context) throws RecognitionException, TokenStreamException {
        Token lc = null;
        Token rc = null;
        if (this.inputState.guessing == 0) {
            this.enterContext(context);
        }
        lc = this.LT(1);
        this.match(69);
        while (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 10 || this.LA(1) == 11 || this.LA(1) == 12 || this.LA(1) == 13 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 18 || this.LA(1) == 19 || this.LA(1) == 21 || this.LA(1) == 22 || this.LA(1) == 26 || this.LA(1) == 28 || this.LA(1) == 29 || this.LA(1) == 30 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 43 || this.LA(1) == 44 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 49 || this.LA(1) == 50 || this.LA(1) == 51 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 57 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 69 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 109 || this.LA(1) == 111 || this.LA(1) == 120) {
            this.statement(null);
        }
        rc = this.LT(1);
        this.match(70);
        if (this.inputState.guessing == 0) {
            MethodEntryInstrEmitter entry = this.instrEnterMethod(sig, start, this.ct(lc));
            this.instrExitMethod(entry, this.ct(rc));
            this.exitContext();
            if (context == 4) {
                this.fileInfo.addMethodMarker(entry, start, endSig, this.ct(rc));
            }
        }
    }

    public final CloverToken explicitConstructorInvocation() throws RecognitionException, TokenStreamException {
        Token pos1 = null;
        Token t1 = null;
        Token pos2 = null;
        Token t2 = null;
        Token pos3 = null;
        Token t3 = null;
        int argListComplexity = 0;
        CloverToken t = null;
        if (this.LA(1) == 50 && this.LA(2) == 65) {
            pos1 = this.LT(1);
            this.match(50);
            this.match(65);
            argListComplexity = this.argList();
            this.match(66);
            t1 = this.LT(1);
            this.match(109);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter(this.ct(t1), this.ct(pos1), this.ct(t1), argListComplexity);
            }
        } else if (this.LA(1) == 47 && this.LA(2) == 65) {
            pos2 = this.LT(1);
            this.match(47);
            this.LT(1);
            this.match(65);
            argListComplexity = this.argList();
            this.match(66);
            t2 = this.LT(1);
            this.match(109);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter(this.ct(t2), this.ct(pos2), this.ct(t2), argListComplexity);
            }
        } else if (!(this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 120 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 67 && this.LA(2) != 72 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 86 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
            this.primaryExpressionPart();
            if (this.LA(1) == 133 && this.LA(2) == 50) {
                this.match(133);
                this.match(50);
            } else if (this.LA(1) != 133 || this.LA(2) != 47) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(133);
            pos3 = this.LT(1);
            this.match(47);
            this.LT(1);
            this.match(65);
            argListComplexity = this.argList();
            this.match(66);
            t3 = this.LT(1);
            this.match(109);
            if (this.inputState.guessing == 0) {
                t = this.instrInlineAfter(this.ct(t3), this.ct(pos3), this.ct(t3), argListComplexity);
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return t;
    }

    public final CloverToken statement(CloverToken owningLabel) throws RecognitionException, TokenStreamException {
        Token colon = null;
        Token semi = null;
        Token se1 = null;
        Token se2 = null;
        Token rp1 = null;
        Token el = null;
        Token rp = null;
        Token rp2 = null;
        Token d1 = null;
        Token rp3 = null;
        Token sem = null;
        CloverToken first = null;
        CloverToken tmp = null;
        CloverToken labelTok = null;
        boolean assertColonPart = false;
        CloverToken last = null;
        boolean labelled = owningLabel != null;
        boolean matchable = true;
        boolean instrumentable = !labelled;
        CloverToken flushAfter = null;
        int complexity = 0;
        int exprComplexity = 0;
        int forInitComp = 0;
        int forCondComp = 0;
        int forIterComp = 0;
        Modifiers mods = null;
        ContextSet saveContext = this.getCurrentContext();
        ContextSetAndComplexity contextAndComplexity = null;
        if (this.inputState.guessing == 0) {
            first = this.lt(1);
        }
        if (this.LA(1) == 11) {
            this.match(11);
            if (this.inputState.guessing == 0) {
                this.enterContext(15);
                instrumentable = false;
                saveContext = this.getCurrentContext();
            }
            if (this.inputState.guessing == 0) {
                tmp = this.lt(1);
            }
            exprComplexity = this.expression();
            if (this.LA(1) == 71) {
                colon = this.LT(1);
                this.match(71);
                if (this.inputState.guessing == 0) {
                    this.instrBoolExpr(tmp, this.ct(colon));
                    assertColonPart = true;
                }
                exprComplexity = this.expression();
            } else if (this.LA(1) != 109) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            semi = this.LT(1);
            this.match(109);
            if (this.inputState.guessing == 0) {
                if (!assertColonPart) {
                    this.instrBoolExpr(tmp, this.ct(semi));
                }
                this.exitContext();
            }
        } else if (this.LA(1) == 69) {
            tmp = this.compoundStatement();
            if (this.inputState.guessing == 0) {
                matchable = false;
                instrumentable = false;
            }
        } else {
            boolean synPredMatched268 = false;
            if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                int _m268 = this.mark();
                synPredMatched268 = true;
                ++this.inputState.guessing;
                try {
                    this.declaration();
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched268 = false;
                }
                this.rewind(_m268);
                --this.inputState.guessing;
            }
            if (synPredMatched268) {
                int declComplexity = this.declaration();
                se1 = this.LT(1);
                this.match(109);
                if (this.inputState.guessing == 0) {
                    complexity += declComplexity;
                    flushAfter = this.ct(se1);
                }
            } else {
                boolean synPredMatched270 = false;
                if (this.LA(1) == 120 && (this.LA(2) == 4 || this.LA(2) == 5 || this.LA(2) == 6 || this.LA(2) == 7 || this.LA(2) == 8 || this.LA(2) == 9 || this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 38 || this.LA(2) == 44 || this.LA(2) == 47 || this.LA(2) == 48 || this.LA(2) == 50 || this.LA(2) == 55 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 65 || this.LA(2) == 76 || this.LA(2) == 77 || this.LA(2) == 81 || this.LA(2) == 83 || this.LA(2) == 84 || this.LA(2) == 86 || this.LA(2) == 120) && this.isNextKeyword("yield")) {
                    int _m270 = this.mark();
                    synPredMatched270 = true;
                    ++this.inputState.guessing;
                    try {
                        if (!this.isNextKeyword("yield")) {
                            throw new SemanticException(" isNextKeyword(\"yield\") ");
                        }
                        this.match(120);
                        this.expression();
                        this.match(109);
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched270 = false;
                    }
                    this.rewind(_m270);
                    --this.inputState.guessing;
                }
                if (synPredMatched270) {
                    this.match(120);
                    exprComplexity = this.expression();
                    this.match(109);
                    if (this.inputState.guessing == 0) {
                        complexity += exprComplexity;
                    }
                } else {
                    boolean synPredMatched272 = false;
                    if (!(this.LA(1) != 10 && this.LA(1) != 26 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 63 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 10 && this.LA(2) != 26 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 111 && this.LA(2) != 120)) {
                        int _m272 = this.mark();
                        synPredMatched272 = true;
                        ++this.inputState.guessing;
                        try {
                            this.classOrInterfaceModifiers(false);
                            if (!this.isCurrentKeyword("record")) {
                                throw new SemanticException(" isCurrentKeyword(\"record\") ");
                            }
                        }
                        catch (RecognitionException recognitionException) {
                            synPredMatched272 = false;
                        }
                        this.rewind(_m272);
                        --this.inputState.guessing;
                    }
                    if (synPredMatched272) {
                        mods = this.classOrInterfaceModifiers(false);
                        this.recordDefinition(mods);
                        if (this.inputState.guessing == 0) {
                            instrumentable = false;
                        }
                    } else {
                        boolean synPredMatched274 = false;
                        if (!(this.LA(1) != 10 && this.LA(1) != 18 && this.LA(1) != 26 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 63 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 10 && this.LA(2) != 18 && this.LA(2) != 26 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 45 && this.LA(2) != 46 && this.LA(2) != 63 && this.LA(2) != 111 && this.LA(2) != 120)) {
                            int _m274 = this.mark();
                            synPredMatched274 = true;
                            ++this.inputState.guessing;
                            try {
                                this.classOrInterfaceModifiers(false);
                                this.match(18);
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched274 = false;
                            }
                            this.rewind(_m274);
                            --this.inputState.guessing;
                        }
                        if (synPredMatched274) {
                            mods = this.classOrInterfaceModifiers(false);
                            this.classDefinition(mods);
                            if (this.inputState.guessing == 0) {
                                instrumentable = false;
                            }
                        } else {
                            boolean synPredMatched276 = false;
                            if (!(this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 120 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 33 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 72 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 86 && this.LA(2) != 87 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 90 && this.LA(2) != 91 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 95 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                                int _m276 = this.mark();
                                synPredMatched276 = true;
                                ++this.inputState.guessing;
                                try {
                                    this.expression();
                                    this.match(109);
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched276 = false;
                                }
                                this.rewind(_m276);
                                --this.inputState.guessing;
                            }
                            if (synPredMatched276) {
                                exprComplexity = this.expression();
                                se2 = this.LT(1);
                                this.match(109);
                                if (this.inputState.guessing == 0) {
                                    flushAfter = this.ct(se2);
                                    complexity += exprComplexity;
                                }
                            } else if (this.LA(1) == 120 && this.LA(2) == 71) {
                                this.match(120);
                                this.match(71);
                                if (this.inputState.guessing == 0) {
                                    labelTok = owningLabel;
                                    if (!labelled) {
                                        labelTok = first;
                                    }
                                }
                                last = this.statement(labelTok);
                            } else if (this.LA(1) == 30) {
                                this.match(30);
                                if (this.inputState.guessing == 0) {
                                    this.enterContext(9);
                                    saveContext = this.getCurrentContext();
                                }
                                this.match(65);
                                if (this.inputState.guessing == 0) {
                                    tmp = this.lt(1);
                                }
                                exprComplexity = this.expression();
                                if (this.inputState.guessing == 0) {
                                    complexity += exprComplexity;
                                }
                                rp1 = this.LT(1);
                                this.match(66);
                                if (this.inputState.guessing == 0) {
                                    this.instrBoolExpr(tmp, this.ct(rp1));
                                    this.addOpenBraceAfter(this.ct(rp1));
                                }
                                last = this.statement(null);
                                if (this.inputState.guessing == 0) {
                                    this.addCloseBraceAfter(last);
                                    this.exitContext();
                                }
                                if (this.LA(1) == 23 && (this.LA(2) == 4 || this.LA(2) == 5 || this.LA(2) == 6 || this.LA(2) == 7 || this.LA(2) == 8 || this.LA(2) == 9 || this.LA(2) == 10 || this.LA(2) == 11 || this.LA(2) == 12 || this.LA(2) == 13 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 18 || this.LA(2) == 19 || this.LA(2) == 21 || this.LA(2) == 22 || this.LA(2) == 26 || this.LA(2) == 28 || this.LA(2) == 29 || this.LA(2) == 30 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 38 || this.LA(2) == 40 || this.LA(2) == 41 || this.LA(2) == 42 || this.LA(2) == 43 || this.LA(2) == 44 || this.LA(2) == 45 || this.LA(2) == 46 || this.LA(2) == 47 || this.LA(2) == 48 || this.LA(2) == 49 || this.LA(2) == 50 || this.LA(2) == 51 || this.LA(2) == 53 || this.LA(2) == 54 || this.LA(2) == 55 || this.LA(2) == 56 || this.LA(2) == 57 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 65 || this.LA(2) == 69 || this.LA(2) == 76 || this.LA(2) == 77 || this.LA(2) == 81 || this.LA(2) == 83 || this.LA(2) == 84 || this.LA(2) == 86 || this.LA(2) == 109 || this.LA(2) == 111 || this.LA(2) == 120)) {
                                    el = this.LT(1);
                                    this.match(23);
                                    if (this.inputState.guessing == 0) {
                                        this.addOpenBraceAfter(this.ct(el));
                                        this.enterContext(10);
                                        saveContext = this.getCurrentContext();
                                    }
                                    last = this.statement(null);
                                    if (this.inputState.guessing == 0) {
                                        this.addCloseBraceAfter(last);
                                        this.exitContext();
                                    }
                                } else if (this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 10 && this.LA(1) != 11 && this.LA(1) != 12 && this.LA(1) != 13 && this.LA(1) != 14 && this.LA(1) != 15 && this.LA(1) != 17 && this.LA(1) != 18 && this.LA(1) != 19 && this.LA(1) != 20 && this.LA(1) != 21 && this.LA(1) != 22 && this.LA(1) != 23 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 29 && this.LA(1) != 30 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 43 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 50 && this.LA(1) != 51 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 57 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 69 && this.LA(1) != 70 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 || !_tokenSet_1.member(this.LA(2))) {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                            } else if (this.LA(1) == 29) {
                                this.match(29);
                                if (this.inputState.guessing == 0) {
                                    this.enterContext(8);
                                    saveContext = this.getCurrentContext();
                                }
                                this.match(65);
                                boolean synPredMatched280 = false;
                                if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 44 && this.LA(2) != 55 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 132 && this.LA(2) != 133)) {
                                    int _m280 = this.mark();
                                    synPredMatched280 = true;
                                    ++this.inputState.guessing;
                                    try {
                                        this.parameterDeclaration();
                                        this.match(71);
                                    }
                                    catch (RecognitionException recognitionException) {
                                        synPredMatched280 = false;
                                    }
                                    this.rewind(_m280);
                                    --this.inputState.guessing;
                                }
                                if (synPredMatched280) {
                                    this.parameterDeclaration();
                                    this.match(71);
                                    exprComplexity = this.expression();
                                    if (this.inputState.guessing == 0) {
                                        complexity += exprComplexity;
                                    }
                                } else if (!(this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 33 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 86 && this.LA(2) != 87 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 90 && this.LA(2) != 91 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 95 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                                    forInitComp = this.forInit();
                                    this.match(109);
                                    forCondComp = this.forCond();
                                    forIterComp = this.forIter();
                                    if (this.inputState.guessing == 0) {
                                        complexity += forInitComp + forCondComp + forIterComp;
                                    }
                                } else {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                                rp = this.LT(1);
                                this.match(66);
                                if (this.inputState.guessing == 0) {
                                    this.addOpenBraceAfter(this.ct(rp));
                                }
                                last = this.statement(null);
                                if (this.inputState.guessing == 0) {
                                    this.addCloseBraceAfter(last);
                                    this.exitContext();
                                }
                            } else if (this.LA(1) == 57) {
                                this.match(57);
                                if (this.inputState.guessing == 0) {
                                    this.enterContext(6);
                                    saveContext = this.getCurrentContext();
                                }
                                this.match(65);
                                if (this.inputState.guessing == 0) {
                                    tmp = this.lt(1);
                                }
                                exprComplexity = this.expression();
                                if (this.inputState.guessing == 0) {
                                    complexity += exprComplexity;
                                }
                                rp2 = this.LT(1);
                                this.match(66);
                                if (this.inputState.guessing == 0) {
                                    this.instrBoolExpr(tmp, this.ct(rp2));
                                    this.addOpenBraceAfter(this.ct(rp2));
                                }
                                last = this.statement(null);
                                if (this.inputState.guessing == 0) {
                                    this.addCloseBraceAfter(last);
                                    this.exitContext();
                                }
                            } else if (this.LA(1) == 21) {
                                d1 = this.LT(1);
                                this.match(21);
                                if (this.inputState.guessing == 0) {
                                    this.addOpenBraceAfter(this.ct(d1));
                                    this.enterContext(7);
                                    saveContext = this.getCurrentContext();
                                }
                                tmp = this.statement(null);
                                if (this.inputState.guessing == 0) {
                                    this.addCloseBraceAfter(tmp);
                                    this.exitContext();
                                }
                                this.match(57);
                                this.match(65);
                                if (this.inputState.guessing == 0) {
                                    tmp = this.lt(1);
                                }
                                exprComplexity = this.expression();
                                if (this.inputState.guessing == 0) {
                                    complexity += exprComplexity;
                                }
                                rp3 = this.LT(1);
                                this.match(66);
                                if (this.inputState.guessing == 0) {
                                    this.instrBoolExpr(tmp, this.ct(rp3));
                                }
                                sem = this.LT(1);
                                this.match(109);
                                if (this.inputState.guessing == 0) {
                                    flushAfter = this.ct(sem);
                                }
                            } else if (this.LA(1) == 13) {
                                this.match(13);
                                if (this.LA(1) == 120) {
                                    this.match(120);
                                } else if (this.LA(1) != 109) {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                                this.match(109);
                            } else if (this.LA(1) == 19) {
                                this.match(19);
                                if (this.LA(1) == 120) {
                                    this.match(120);
                                } else if (this.LA(1) != 109) {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                                this.match(109);
                            } else if (this.LA(1) == 43) {
                                this.match(43);
                                if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
                                    exprComplexity = this.expression();
                                    if (this.inputState.guessing == 0) {
                                        complexity += exprComplexity;
                                    }
                                } else if (this.LA(1) != 109) {
                                    throw new NoViableAltException(this.LT(1), this.getFilename());
                                }
                                this.match(109);
                            } else {
                                boolean synPredMatched288 = false;
                                if (this.LA(1) == 48 && this.LA(2) == 65) {
                                    int _m288 = this.mark();
                                    synPredMatched288 = true;
                                    ++this.inputState.guessing;
                                    try {
                                        this.match(48);
                                        this.match(65);
                                        this.expression();
                                        this.match(66);
                                        this.match(69);
                                        if (this.LA(1) == 15) {
                                            this.match(15);
                                            this.expression();
                                        } else if (this.LA(1) == 20) {
                                            this.match(20);
                                        } else {
                                            throw new NoViableAltException(this.LT(1), this.getFilename());
                                        }
                                        this.match(71);
                                    }
                                    catch (RecognitionException recognitionException) {
                                        synPredMatched288 = false;
                                    }
                                    this.rewind(_m288);
                                    --this.inputState.guessing;
                                }
                                if (synPredMatched288) {
                                    contextAndComplexity = this.colonSwitchExpression(owningLabel, false);
                                    if (this.inputState.guessing == 0) {
                                        saveContext = contextAndComplexity.getContext();
                                        complexity += contextAndComplexity.getComplexity();
                                    }
                                } else {
                                    boolean synPredMatched291 = false;
                                    if (this.LA(1) == 48 && this.LA(2) == 65) {
                                        int _m291 = this.mark();
                                        synPredMatched291 = true;
                                        ++this.inputState.guessing;
                                        try {
                                            this.match(48);
                                            this.match(65);
                                            this.expression();
                                            this.match(66);
                                            this.match(69);
                                            if (this.LA(1) == 15) {
                                                this.match(15);
                                                this.patternMatch();
                                            } else if (this.LA(1) == 20) {
                                                this.match(20);
                                            } else {
                                                throw new NoViableAltException(this.LT(1), this.getFilename());
                                            }
                                            this.match(110);
                                        }
                                        catch (RecognitionException recognitionException) {
                                            synPredMatched291 = false;
                                        }
                                        this.rewind(_m291);
                                        --this.inputState.guessing;
                                    }
                                    if (synPredMatched291) {
                                        contextAndComplexity = this.lambdaSwitchExpression(owningLabel);
                                        if (this.inputState.guessing == 0) {
                                            saveContext = contextAndComplexity.getContext();
                                            complexity += contextAndComplexity.getComplexity();
                                        }
                                    } else {
                                        boolean synPredMatched293 = false;
                                        if (this.LA(1) == 54) {
                                            int _m293 = this.mark();
                                            synPredMatched293 = true;
                                            ++this.inputState.guessing;
                                            try {
                                                this.tryCatchBlock(labelled);
                                            }
                                            catch (RecognitionException recognitionException) {
                                                synPredMatched293 = false;
                                            }
                                            this.rewind(_m293);
                                            --this.inputState.guessing;
                                        }
                                        if (synPredMatched293) {
                                            last = this.tryCatchBlock(labelled);
                                            if (this.inputState.guessing == 0) {
                                                instrumentable = false;
                                            }
                                        } else if (this.LA(1) == 51) {
                                            this.match(51);
                                            exprComplexity = this.expression();
                                            this.match(109);
                                            if (this.inputState.guessing == 0) {
                                                complexity += exprComplexity;
                                            }
                                        } else if (this.LA(1) == 49) {
                                            this.match(49);
                                            this.match(65);
                                            exprComplexity = this.expression();
                                            this.match(66);
                                            if (this.inputState.guessing == 0) {
                                                complexity += exprComplexity;
                                                this.enterContext(14);
                                                saveContext = this.getCurrentContext();
                                            }
                                            last = this.compoundStatement();
                                            if (this.inputState.guessing == 0) {
                                                this.exitContext();
                                            }
                                        } else if (this.LA(1) == 109) {
                                            this.match(109);
                                        } else {
                                            throw new NoViableAltException(this.LT(1), this.getFilename());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.inputState.guessing == 0) {
            if (last == null) {
                last = this.lt(0);
            }
            if (instrumentable) {
                this.instrInlineBefore(first, last, saveContext, complexity);
            }
            if (flushAfter != null) {
                this.maybeAddFlushInstr(flushAfter);
            }
            if (matchable) {
                this.fileInfo.addStatementMarker(first, last);
            }
        }
        return last;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ContextSetAndComplexity primaryExpressionPart() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        ContextSetAndComplexity ret = ContextSetAndComplexity.empty();
        if (this.LA(1) == 120) {
            this.match(120);
            if (this.inputState.guessing != 0) return ret;
            this.pushIdentifierToHeadStack(this.LT(0).getText());
            return ret;
        }
        if (this.LA(1) >= 4 && this.LA(1) <= 9) {
            this.constant();
            return ret;
        }
        if (this.LA(1) == 60) {
            this.match(60);
            return ret;
        }
        if (this.LA(1) == 61) {
            this.match(61);
            return ret;
        }
        if (this.LA(1) == 50) {
            this.match(50);
            if (this.inputState.guessing != 0) return ret;
            this.pushIdentifierToHeadStack(this.LT(0).getText());
            return ret;
        }
        if (this.LA(1) == 62) {
            this.match(62);
            return ret;
        }
        if (this.LA(1) == 38) {
            tmpComplexity = this.newExpression();
            if (this.inputState.guessing != 0) return ret;
            return ContextSetAndComplexity.ofComplexity(tmpComplexity);
        }
        if (this.LA(1) == 65) {
            this.match(65);
            tmpComplexity = this.assignmentExpression();
            this.match(66);
            if (this.inputState.guessing != 0) return ret;
            return ContextSetAndComplexity.ofComplexity(tmpComplexity);
        }
        if (this.LA(1) == 47) {
            this.match(47);
            if (this.inputState.guessing != 0) return ret;
            this.pushIdentifierToHeadStack(this.LT(0).getText());
            return ret;
        }
        if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 44 || this.LA(1) == 55) {
            this.builtInType();
            while (this.LA(1) == 67) {
                this.match(67);
                this.match(68);
            }
            if (this.LA(1) == 133) {
                this.match(133);
                this.match(18);
                return ret;
            } else {
                if (this.LA(1) != 72) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(72);
                this.match(38);
            }
            return ret;
        }
        if (this.LA(1) == 63) {
            this.match(63);
            return ret;
        }
        boolean synPredMatched428 = false;
        if (this.LA(1) == 48 && this.LA(2) == 65) {
            int _m428 = this.mark();
            synPredMatched428 = true;
            ++this.inputState.guessing;
            try {
                this.match(48);
                this.match(65);
                this.expression();
                this.match(66);
                this.match(69);
                if (this.LA(1) == 15) {
                    this.match(15);
                    this.patternMatch();
                } else {
                    if (this.LA(1) != 20) throw new NoViableAltException(this.LT(1), this.getFilename());
                    this.match(20);
                }
                this.match(110);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched428 = false;
            }
            this.rewind(_m428);
            --this.inputState.guessing;
        }
        if (synPredMatched428) {
            return this.lambdaSwitchExpression(null);
        }
        boolean synPredMatched431 = false;
        if (this.LA(1) == 48 && this.LA(2) == 65) {
            int _m431 = this.mark();
            synPredMatched431 = true;
            ++this.inputState.guessing;
            try {
                this.match(48);
                this.match(65);
                this.expression();
                this.match(66);
                this.match(69);
                if (this.LA(1) == 15) {
                    this.match(15);
                    this.expression();
                } else {
                    if (this.LA(1) != 20) throw new NoViableAltException(this.LT(1), this.getFilename());
                    this.match(20);
                }
                this.match(71);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched431 = false;
            }
            this.rewind(_m431);
            --this.inputState.guessing;
        }
        if (!synPredMatched431) throw new NoViableAltException(this.LT(1), this.getFilename());
        return this.colonSwitchExpression(null, true);
    }

    public final int varInitializer() throws RecognitionException, TokenStreamException {
        int complexity = 0;
        if (this.LA(1) == 74) {
            this.match(74);
            complexity = this.initializer();
        } else if (this.LA(1) != 66 && this.LA(1) != 73 && this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    public final int initializer() throws RecognitionException, TokenStreamException {
        int complexity = 0;
        if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
            complexity = this.expression();
        } else if (this.LA(1) == 69) {
            complexity = this.arrayInitializer();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    public final int arrayInitializer() throws RecognitionException, TokenStreamException {
        int complexity = 0;
        this.match(69);
        if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 69 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
            int initComplexity = this.initializer();
            if (this.inputState.guessing == 0) {
                complexity += initComplexity;
            }
            while (this.LA(1) == 73 && (this.LA(2) == 4 || this.LA(2) == 5 || this.LA(2) == 6 || this.LA(2) == 7 || this.LA(2) == 8 || this.LA(2) == 9 || this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 38 || this.LA(2) == 44 || this.LA(2) == 47 || this.LA(2) == 48 || this.LA(2) == 50 || this.LA(2) == 55 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 65 || this.LA(2) == 69 || this.LA(2) == 76 || this.LA(2) == 77 || this.LA(2) == 81 || this.LA(2) == 83 || this.LA(2) == 84 || this.LA(2) == 86 || this.LA(2) == 120)) {
                this.match(73);
                initComplexity = this.initializer();
                if (this.inputState.guessing != 0) continue;
                complexity += initComplexity;
            }
        } else if (this.LA(1) != 70 && this.LA(1) != 73) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 73) {
            this.match(73);
        } else if (this.LA(1) != 70) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(70);
        return complexity;
    }

    public final int expression() throws RecognitionException, TokenStreamException {
        if (this.inputState.guessing == 0) {
            this.pushHeadIdentifierStack();
        }
        int complexity = this.assignmentExpression();
        if (this.inputState.guessing == 0) {
            this.popHeadIdentifierStack();
        }
        return complexity;
    }

    public final Parameter parameterDeclaration() throws RecognitionException, TokenStreamException {
        Token i = null;
        String brackets = "";
        String type = null;
        Parameter parameter = null;
        this.parameterModifier();
        type = this.typeSpec();
        if (this.LA(1) == 132) {
            this.match(132);
        } else if (this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        i = this.LT(1);
        this.match(120);
        brackets = this.declaratorBrackets();
        if (this.inputState.guessing == 0) {
            parameter = new Parameter(String.valueOf(type) + brackets, i.getText());
        }
        return parameter;
    }

    public final void parameterModifier() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 111 && this.LA(2) == 120) {
            this.annotation();
        }
        if (this.LA(1) == 26) {
            this.LT(1);
            this.match(26);
            while (this.LA(1) == 111 && this.LA(2) == 120) {
                this.annotation();
            }
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 111 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final Parameter[] implicitParameterDeclarationList() throws RecognitionException, TokenStreamException {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        Parameter param = null;
        Parameter[] parameters = new Parameter[]{};
        param = this.implicitParameterDeclaration();
        if (this.inputState.guessing == 0) {
            parameterList.add(param);
        }
        while (this.LA(1) == 73) {
            this.match(73);
            param = this.implicitParameterDeclaration();
            if (this.inputState.guessing != 0) continue;
            parameterList.add(param);
        }
        if (this.inputState.guessing == 0) {
            parameters = parameterList.toArray(new Parameter[parameterList.size()]);
        }
        return parameters;
    }

    public final Parameter implicitParameterDeclaration() throws RecognitionException, TokenStreamException {
        Token i = null;
        Parameter parameter = null;
        i = this.LT(1);
        this.match(120);
        if (this.inputState.guessing == 0) {
            parameter = new Parameter("<inferred>", i.getText());
        }
        return parameter;
    }

    public final CloverToken compoundStatement() throws RecognitionException, TokenStreamException {
        Token rc = null;
        CloverToken t = null;
        this.match(69);
        while (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 10 || this.LA(1) == 11 || this.LA(1) == 12 || this.LA(1) == 13 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 18 || this.LA(1) == 19 || this.LA(1) == 21 || this.LA(1) == 22 || this.LA(1) == 26 || this.LA(1) == 28 || this.LA(1) == 29 || this.LA(1) == 30 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 43 || this.LA(1) == 44 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 49 || this.LA(1) == 50 || this.LA(1) == 51 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 57 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 69 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 109 || this.LA(1) == 111 || this.LA(1) == 120) {
            t = this.statement(null);
        }
        rc = this.LT(1);
        this.match(70);
        if (this.inputState.guessing == 0) {
            t = this.ct(rc);
        }
        return t;
    }

    public final int forInit() throws RecognitionException, TokenStreamException {
        int complexity = 0;
        boolean synPredMatched305 = false;
        if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
            int _m305 = this.mark();
            synPredMatched305 = true;
            ++this.inputState.guessing;
            try {
                this.declaration();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched305 = false;
            }
            this.rewind(_m305);
            --this.inputState.guessing;
        }
        if (synPredMatched305) {
            complexity = this.declaration();
        } else if (!(this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 120 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 33 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 86 && this.LA(2) != 87 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 90 && this.LA(2) != 91 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 95 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
            complexity = this.expressionList();
        } else if (this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    public final int forCond() throws RecognitionException, TokenStreamException {
        Token se = null;
        CloverToken tmp = null;
        int complexity = 0;
        if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
            if (this.inputState.guessing == 0) {
                tmp = this.lt(1);
            }
            complexity = this.expression();
            se = this.LT(1);
            this.match(109);
            if (this.inputState.guessing == 0) {
                this.instrBoolExpr(tmp, this.ct(se));
            }
        } else if (this.LA(1) == 109) {
            this.match(109);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    public final int forIter() throws RecognitionException, TokenStreamException {
        int complexity = 0;
        if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
            complexity = this.expressionList();
        } else if (this.LA(1) != 66) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    public final ContextSetAndComplexity colonSwitchExpression(CloverToken owningLabel, boolean isInsideExpression) throws RecognitionException, TokenStreamException {
        Token sw = null;
        CloverToken tmp = null;
        boolean labelled = owningLabel != null;
        FlagDeclEmitter flag = null;
        ContextSetAndComplexity ret = ContextSetAndComplexity.empty();
        sw = this.LT(1);
        this.match(48);
        if (this.inputState.guessing == 0) {
            tmp = this.ct(sw);
            if (labelled) {
                tmp = owningLabel;
            }
            if (!isInsideExpression) {
                flag = this.declareFlagBefore(tmp);
            }
            this.enterContext(5);
            ret.setContext(this.getCurrentContext());
        }
        this.match(65);
        int exprComplexity = this.expression();
        this.match(66);
        this.match(69);
        if (this.inputState.guessing == 0) {
            ret.addComplexity(exprComplexity);
        }
        while (this.LA(1) == 15 || this.LA(1) == 20) {
            int casesGroupComplexity = this.colonCasesGroup(flag);
            if (this.inputState.guessing != 0) continue;
            ret.addComplexity(casesGroupComplexity);
        }
        if (this.inputState.guessing == 0) {
            this.exitContext();
        }
        this.LT(1);
        this.match(70);
        return ret;
    }

    public final void patternMatch() throws RecognitionException, TokenStreamException {
        this.constantExpression();
        while (this.LA(1) == 73) {
            this.match(73);
            this.constantExpression();
        }
    }

    public final ContextSetAndComplexity lambdaSwitchExpression(CloverToken owningLabel) throws RecognitionException, TokenStreamException {
        Token sw = null;
        int caseComplexity = -1;
        int exprComplexity = 0;
        ContextSet saveContext = this.getCurrentContext();
        ContextSetAndComplexity ret = ContextSetAndComplexity.ofComplexity(caseComplexity);
        sw = this.LT(1);
        this.match(48);
        if (this.inputState.guessing == 0) {
            this.ct(sw);
            this.enterContext(5);
            ret.setContext(this.getCurrentContext());
        }
        this.match(65);
        exprComplexity = this.expression();
        this.match(66);
        this.match(69);
        if (this.inputState.guessing == 0) {
            ret.addComplexity(exprComplexity);
        }
        int _cnt437 = 0;
        while (true) {
            if (this.LA(1) == 15 || this.LA(1) == 20) {
                caseComplexity = this.lambdaCase(saveContext);
                if (this.inputState.guessing == 0) {
                    ret.addComplexity(caseComplexity);
                }
            } else {
                if (_cnt437 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt437;
        }
        if (this.inputState.guessing == 0) {
            this.exitContext();
        }
        this.LT(1);
        this.match(70);
        return ret;
    }

    public final CloverToken tryCatchBlock(boolean labelled) throws RecognitionException, TokenStreamException {
        Token tr = null;
        Token lp = null;
        Token semi = null;
        CloverToken last = null;
        int complexity = 0;
        ContextSet saveContext = this.getCurrentContext();
        tr = this.LT(1);
        this.match(54);
        if (this.LA(1) == 65) {
            int declComplexity;
            lp = this.LT(1);
            this.match(65);
            if (this.inputState.guessing == 0) {
                this.insertAutoCloseableClassDecl(this.ct(tr));
            }
            boolean synPredMatched314 = false;
            if (this.LA(1) == 120 && (this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 74 || this.LA(2) == 109 || this.LA(2) == 111)) {
                int _m314 = this.mark();
                synPredMatched314 = true;
                ++this.inputState.guessing;
                try {
                    this.match(120);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched314 = false;
                }
                this.rewind(_m314);
                --this.inputState.guessing;
            }
            if (synPredMatched314) {
                declComplexity = this.variableDeclarator();
            } else if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                declComplexity = this.declaration();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                complexity += declComplexity;
                ++complexity;
                this.instrArmDecl(this.ct(lp).getNext(), this.lt(0), saveContext);
            }
            while (this.LA(1) == 109 && (this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 26 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 40 || this.LA(2) == 41 || this.LA(2) == 42 || this.LA(2) == 44 || this.LA(2) == 45 || this.LA(2) == 53 || this.LA(2) == 55 || this.LA(2) == 56 || this.LA(2) == 111 || this.LA(2) == 120)) {
                semi = this.LT(1);
                this.match(109);
                boolean synPredMatched318 = false;
                if (this.LA(1) == 120 && (this.LA(2) == 66 || this.LA(2) == 67 || this.LA(2) == 74 || this.LA(2) == 109 || this.LA(2) == 111)) {
                    int _m318 = this.mark();
                    synPredMatched318 = true;
                    ++this.inputState.guessing;
                    try {
                        this.match(120);
                    }
                    catch (RecognitionException recognitionException) {
                        synPredMatched318 = false;
                    }
                    this.rewind(_m318);
                    --this.inputState.guessing;
                }
                if (synPredMatched318) {
                    declComplexity = this.variableDeclarator();
                } else if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 53 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 40 && this.LA(2) != 41 && this.LA(2) != 42 && this.LA(2) != 44 && this.LA(2) != 45 && this.LA(2) != 53 && this.LA(2) != 55 && this.LA(2) != 56 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                    declComplexity = this.declaration();
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.inputState.guessing != 0) continue;
                complexity += declComplexity;
                ++complexity;
                this.instrArmDecl(this.ct(semi).getNext(), this.lt(0), saveContext);
            }
            if (this.LA(1) == 109) {
                this.match(109);
            } else if (this.LA(1) != 66) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.LT(1);
            this.match(66);
        } else if (this.LA(1) != 69) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            this.enterContext(11);
            saveContext = this.getCurrentContext();
        }
        last = this.compoundStatement();
        if (this.inputState.guessing == 0) {
            this.exitContext();
        }
        while (this.LA(1) == 16) {
            last = this.handler();
            if (this.inputState.guessing != 0) continue;
            ++complexity;
        }
        if (this.LA(1) == 27) {
            this.match(27);
            if (this.inputState.guessing == 0) {
                this.enterContext(13);
                saveContext = this.getCurrentContext();
            }
            last = this.compoundStatement();
            if (this.inputState.guessing == 0) {
                this.exitContext();
            }
        } else if (this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 10 && this.LA(1) != 11 && this.LA(1) != 12 && this.LA(1) != 13 && this.LA(1) != 14 && this.LA(1) != 15 && this.LA(1) != 17 && this.LA(1) != 18 && this.LA(1) != 19 && this.LA(1) != 20 && this.LA(1) != 21 && this.LA(1) != 22 && this.LA(1) != 23 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 29 && this.LA(1) != 30 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 40 && this.LA(1) != 41 && this.LA(1) != 42 && this.LA(1) != 43 && this.LA(1) != 44 && this.LA(1) != 45 && this.LA(1) != 46 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 49 && this.LA(1) != 50 && this.LA(1) != 51 && this.LA(1) != 53 && this.LA(1) != 54 && this.LA(1) != 55 && this.LA(1) != 56 && this.LA(1) != 57 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 69 && this.LA(1) != 70 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 109 && this.LA(1) != 111 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0 && !labelled) {
            this.instrInlineBefore(this.ct(tr), last, saveContext, complexity);
        }
        return last;
    }

    public final int colonCasesGroup(FlagDeclEmitter flag) throws RecognitionException, TokenStreamException {
        int tmp = 0;
        int complexity = 0;
        int _cnt296 = 0;
        while (true) {
            if (!(this.LA(1) != 15 && this.LA(1) != 20 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 20 && this.LA(2) != 47 && this.LA(2) != 50 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 65 && this.LA(2) != 71 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 81 && this.LA(2) != 84 && this.LA(2) != 120)) {
                tmp = this.colonCase(flag);
                if (this.inputState.guessing == 0) {
                    complexity += tmp;
                }
            } else {
                if (_cnt296 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt296;
        }
        this.caseStatementsList();
        return complexity;
    }

    public final int colonCase(FlagDeclEmitter flag) throws RecognitionException, TokenStreamException {
        Token si1 = null;
        Token si2 = null;
        Token t = null;
        Token pos = null;
        int complexity = 0;
        if (this.LA(1) == 15) {
            si1 = this.LT(1);
            this.match(15);
            if (this.inputState.guessing == 0) {
                this.constExpr = true;
            }
            this.constantExpression();
            if (this.inputState.guessing == 0) {
                this.constExpr = false;
                pos = si1;
                ++complexity;
            }
        } else if (this.LA(1) == 20) {
            si2 = this.LT(1);
            this.match(20);
            if (this.inputState.guessing == 0) {
                pos = si2;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        t = this.LT(1);
        this.match(71);
        if (this.inputState.guessing == 0) {
            if (flag != null) {
                this.instrInlineAfter(this.ct(t), this.ct(pos), this.ct(t), flag, 0);
            } else {
                this.instrInlineAfter(this.ct(t), this.ct(pos), this.ct(t), 0);
            }
            this.fileInfo.setSuppressFallthroughWarnings(true);
        }
        return complexity;
    }

    public final void caseStatementsList() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 10 || this.LA(1) == 11 || this.LA(1) == 12 || this.LA(1) == 13 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 18 || this.LA(1) == 19 || this.LA(1) == 21 || this.LA(1) == 22 || this.LA(1) == 26 || this.LA(1) == 28 || this.LA(1) == 29 || this.LA(1) == 30 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 40 || this.LA(1) == 41 || this.LA(1) == 42 || this.LA(1) == 43 || this.LA(1) == 44 || this.LA(1) == 45 || this.LA(1) == 46 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 49 || this.LA(1) == 50 || this.LA(1) == 51 || this.LA(1) == 53 || this.LA(1) == 54 || this.LA(1) == 55 || this.LA(1) == 56 || this.LA(1) == 57 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 69 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 109 || this.LA(1) == 111 || this.LA(1) == 120) {
            this.statement(null);
        }
    }

    public final void constantExpression() throws RecognitionException, TokenStreamException {
        this.constantConditionalExpression();
    }

    public final int expressionList() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = 0;
        complexity = this.expression();
        while (this.LA(1) == 73) {
            this.match(73);
            tmpComplexity = this.expression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final CloverToken handler() throws RecognitionException, TokenStreamException {
        CloverToken last = null;
        this.match(16);
        this.match(65);
        while (this.LA(1) == 111 && this.LA(2) == 120) {
            this.annotation2(false);
        }
        if (this.LA(1) == 26) {
            this.match(26);
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 111 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 111 && this.LA(2) == 120) {
            this.annotation2(false);
        }
        this.typeSpec();
        while (this.LA(1) == 103) {
            this.match(103);
            this.typeSpec();
        }
        this.match(120);
        this.match(66);
        if (this.inputState.guessing == 0) {
            this.enterContext(12);
        }
        last = this.compoundStatement();
        if (this.inputState.guessing == 0) {
            this.exitContext();
        }
        return last;
    }

    public final void lambdaFunctionPredicate() throws RecognitionException, TokenStreamException {
        boolean synPredMatched336 = false;
        if (this.LA(1) == 65 && (this.LA(2) == 111 || this.LA(2) == 120)) {
            int _m336 = this.mark();
            synPredMatched336 = true;
            ++this.inputState.guessing;
            try {
                this.match(65);
                this.classTypeSpec();
                while (this.LA(1) == 106) {
                    this.match(106);
                    this.classOrInterfaceType();
                }
                this.match(66);
                this.lambdaArgs();
                this.match(110);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched336 = false;
            }
            this.rewind(_m336);
            --this.inputState.guessing;
        }
        if (synPredMatched336) {
            this.match(65);
            this.classTypeSpec();
            while (this.LA(1) == 106) {
                this.match(106);
                this.classOrInterfaceType();
            }
            this.match(66);
            this.lambdaArgs();
            this.match(110);
        } else {
            boolean synPredMatched340 = false;
            if (!(this.LA(1) != 65 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 44 && this.LA(2) != 55 && this.LA(2) != 66 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120)) {
                int _m340 = this.mark();
                synPredMatched340 = true;
                ++this.inputState.guessing;
                try {
                    this.lambdaArgs();
                    this.match(110);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched340 = false;
                }
                this.rewind(_m340);
                --this.inputState.guessing;
            }
            if (synPredMatched340) {
                this.lambdaArgs();
                this.match(110);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final Parameter[] lambdaArgs() throws RecognitionException, TokenStreamException {
        Parameter[] parameters = new Parameter[]{};
        if (this.LA(1) == 65) {
            this.match(65);
            if (!(this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 26 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 66 && this.LA(1) != 111 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 44 && this.LA(2) != 55 && this.LA(2) != 67 && this.LA(2) != 100 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 132 && this.LA(2) != 133)) {
                Parameter[] ps = this.parameterDeclarationList();
                if (this.inputState.guessing == 0) {
                    parameters = ps;
                }
            } else if (this.LA(1) == 120 && (this.LA(2) == 66 || this.LA(2) == 73)) {
                Parameter[] ps = this.implicitParameterDeclarationList();
                if (this.inputState.guessing == 0) {
                    parameters = ps;
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(66);
        } else if (this.LA(1) == 120) {
            Parameter p = this.implicitParameterDeclaration();
            if (this.inputState.guessing == 0) {
                parameters = new Parameter[]{p};
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return parameters;
    }

    public final CloverToken lambdaFunction() throws RecognitionException, TokenStreamException {
        String type;
        CloverToken startLambdaArgs = null;
        CloverToken startLambdaBody = null;
        Parameter[] la = null;
        MethodSignature lambdaSignature = null;
        LambdaExpressionEntryEmitter expressionEntryEmitter = null;
        LambdaBlockEntryEmitter blockEntryEmitter = null;
        LambdaExprToBlockStartEntryEmitter exprToBlockStartEntryEmitter = null;
        boolean exprToBlockHeuristic = false;
        CloverToken last = null;
        CloverToken classCastStart = null;
        CloverToken classCastEnd = null;
        boolean synPredMatched346 = false;
        if (this.LA(1) == 65 && (this.LA(2) == 111 || this.LA(2) == 120)) {
            int _m346 = this.mark();
            synPredMatched346 = true;
            ++this.inputState.guessing;
            try {
                this.match(65);
                type = this.classTypeSpec();
                while (this.LA(1) == 106) {
                    this.match(106);
                    this.classOrInterfaceType();
                }
                this.match(66);
                la = this.lambdaArgs();
                this.match(110);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched346 = false;
            }
            this.rewind(_m346);
            --this.inputState.guessing;
        }
        if (synPredMatched346) {
            if (this.inputState.guessing == 0) {
                classCastStart = this.lt(1);
            }
            this.match(65);
            type = this.classTypeSpec();
            while (this.LA(1) == 106) {
                this.match(106);
                String typeExt = this.classOrInterfaceType();
                if (this.inputState.guessing != 0) continue;
                type = String.valueOf(type) + "&" + typeExt;
            }
            this.match(66);
            if (this.inputState.guessing == 0) {
                classCastEnd = this.lt(0);
            }
            if (this.inputState.guessing == 0) {
                startLambdaArgs = this.lt(1);
            }
            la = this.lambdaArgs();
            this.match(110);
        } else {
            boolean synPredMatched350 = false;
            if (!(this.LA(1) != 65 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 44 && this.LA(2) != 55 && this.LA(2) != 66 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120)) {
                int _m350 = this.mark();
                synPredMatched350 = true;
                ++this.inputState.guessing;
                try {
                    la = this.lambdaArgs();
                    this.match(110);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched350 = false;
                }
                this.rewind(_m350);
                --this.inputState.guessing;
            }
            if (synPredMatched350) {
                if (this.inputState.guessing == 0) {
                    startLambdaArgs = this.lt(1);
                }
                la = this.lambdaArgs();
                this.match(110);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            lambdaSignature = new MethodSignature(LambdaUtil.generateLambdaNameWithId(la, this.lambdaCounter++), null, null, la, null, new Modifiers());
        }
        if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
            if (this.inputState.guessing == 0) {
                startLambdaBody = this.lt(1);
                exprToBlockHeuristic = RewriteLambdaToBlockMatcher.shouldRewriteAsBlock(this.identifiersStack);
                if (exprToBlockHeuristic) {
                    exprToBlockStartEntryEmitter = this.instrEnterLambdaExprToBlockExpression(lambdaSignature, startLambdaArgs, startLambdaBody);
                } else {
                    expressionEntryEmitter = this.instrEnterLambdaExpression(lambdaSignature, startLambdaArgs, startLambdaBody, classCastStart, classCastEnd);
                }
            }
            this.expression();
            if (this.inputState.guessing == 0) {
                if (exprToBlockHeuristic) {
                    this.instrExitLambdaExprToBlockExpression(exprToBlockStartEntryEmitter, this.lt(0));
                } else {
                    this.instrExitLambdaExpression(expressionEntryEmitter, this.lt(0));
                }
            }
        } else if (this.LA(1) == 69) {
            if (this.inputState.guessing == 0) {
                blockEntryEmitter = this.instrEnterLambdaBlock(lambdaSignature, this.lt(1));
            }
            this.compoundStatement();
            if (this.inputState.guessing == 0) {
                this.instrExitLambdaBlock(blockEntryEmitter, this.lt(0));
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return last;
    }

    public final int assignmentExpression() throws RecognitionException, TokenStreamException {
        int complexity1 = 0;
        int complexity2 = 0;
        int complexity = 0;
        complexity1 = this.conditionalExpression();
        if (!(this.LA(1) != 74 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 85 && this.LA(1) != 88 && this.LA(1) != 90 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 98 && this.LA(1) != 102 && this.LA(1) != 104 && this.LA(1) != 107 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 86 && this.LA(2) != 120)) {
            if (this.LA(1) == 74) {
                this.match(74);
            } else if (this.LA(1) == 82) {
                this.match(82);
            } else if (this.LA(1) == 85) {
                this.match(85);
            } else if (this.LA(1) == 88) {
                this.match(88);
            } else if (this.LA(1) == 80) {
                this.match(80);
            } else if (this.LA(1) == 90) {
                this.match(90);
            } else if (this.LA(1) == 92) {
                this.match(92);
            } else if (this.LA(1) == 94) {
                this.match(94);
            } else if (this.LA(1) == 98) {
                this.match(98);
            } else if (this.LA(1) == 107) {
                this.match(107);
            } else if (this.LA(1) == 102) {
                this.match(102);
            } else if (this.LA(1) == 104) {
                this.match(104);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            complexity2 = this.assignmentExpression();
        } else if (this.LA(1) != 66 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 85 && this.LA(1) != 88 && this.LA(1) != 90 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 98 && this.LA(1) != 102 && this.LA(1) != 104 && this.LA(1) != 107 && this.LA(1) != 109 || !_tokenSet_2.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            complexity = complexity1 + complexity2;
        }
        return complexity;
    }

    public final int conditionalExpression() throws RecognitionException, TokenStreamException {
        Token endOfCond = null;
        CloverToken startOfCond = null;
        int complexity1 = 0;
        int complexity2 = 0;
        int complexity3 = 0;
        int complexity = 0;
        boolean synPredMatched364 = false;
        if (!(this.LA(1) != 65 && this.LA(1) != 120 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 44 && this.LA(2) != 55 && this.LA(2) != 66 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120)) {
            int _m364 = this.mark();
            synPredMatched364 = true;
            ++this.inputState.guessing;
            try {
                this.lambdaFunctionPredicate();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched364 = false;
            }
            this.rewind(_m364);
            --this.inputState.guessing;
        }
        if (synPredMatched364) {
            this.lambdaFunction();
        } else {
            boolean synPredMatched367 = false;
            if (!(this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 120 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 33 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 68 && this.LA(2) != 70 && this.LA(2) != 71 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 74 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 80 && this.LA(2) != 81 && this.LA(2) != 82 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 85 && this.LA(2) != 86 && this.LA(2) != 87 && this.LA(2) != 88 && this.LA(2) != 89 && this.LA(2) != 90 && this.LA(2) != 91 && this.LA(2) != 92 && this.LA(2) != 93 && this.LA(2) != 94 && this.LA(2) != 95 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 98 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 102 && this.LA(2) != 103 && this.LA(2) != 104 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 107 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
                int _m367 = this.mark();
                synPredMatched367 = true;
                ++this.inputState.guessing;
                try {
                    this.logicalOrExpression();
                    if (this.LA(1) == 64) {
                        this.match(64);
                    }
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched367 = false;
                }
                this.rewind(_m367);
                --this.inputState.guessing;
            }
            if (synPredMatched367) {
                if (this.inputState.guessing == 0) {
                    startOfCond = this.lt(1);
                }
                complexity1 = this.logicalOrExpression();
                if (this.LA(1) == 64) {
                    endOfCond = this.LT(1);
                    this.match(64);
                    if (this.inputState.guessing == 0 && !this.constExpr) {
                        this.instrBoolExpr(startOfCond, this.ct(endOfCond));
                    }
                    complexity2 = this.assignmentExpression();
                    this.match(71);
                    complexity3 = this.conditionalExpression();
                } else if (this.LA(1) != 66 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 80 && this.LA(1) != 82 && this.LA(1) != 85 && this.LA(1) != 88 && this.LA(1) != 90 && this.LA(1) != 92 && this.LA(1) != 94 && this.LA(1) != 98 && this.LA(1) != 102 && this.LA(1) != 104 && this.LA(1) != 107 && this.LA(1) != 109) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                if (this.inputState.guessing == 0) {
                    complexity = complexity1 + complexity2 + complexity3;
                }
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return complexity;
    }

    public final int logicalOrExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.logicalAndExpression();
        while (this.LA(1) == 105) {
            this.match(105);
            tmpComplexity = this.logicalAndExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int logicalAndExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.inclusiveOrExpression();
        while (this.LA(1) == 108) {
            this.match(108);
            tmpComplexity = this.inclusiveOrExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int inclusiveOrExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.exclusiveOrExpression();
        while (this.LA(1) == 103) {
            this.match(103);
            tmpComplexity = this.exclusiveOrExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int exclusiveOrExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.andExpression();
        while (this.LA(1) == 101) {
            this.match(101);
            tmpComplexity = this.andExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int andExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.equalityExpression();
        while (this.LA(1) == 106) {
            this.match(106);
            tmpComplexity = this.equalityExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int equalityExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.relationalExpression();
        while (this.LA(1) == 75 || this.LA(1) == 78) {
            if (this.LA(1) == 78) {
                this.match(78);
            } else if (this.LA(1) == 75) {
                this.match(75);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            tmpComplexity = this.relationalExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int relationalExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.shiftExpression();
        if (this.LA(1) == 64 || this.LA(1) == 66 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 78 || this.LA(1) == 80 || this.LA(1) == 82 || this.LA(1) == 85 || this.LA(1) == 88 || this.LA(1) == 90 || this.LA(1) == 92 || this.LA(1) == 94 || this.LA(1) == 95 || this.LA(1) == 96 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 104 || this.LA(1) == 105 || this.LA(1) == 106 || this.LA(1) == 107 || this.LA(1) == 108 || this.LA(1) == 109) {
            while (this.LA(1) == 95 || this.LA(1) == 96 || this.LA(1) == 99 || this.LA(1) == 100) {
                if (this.LA(1) == 100) {
                    this.match(100);
                } else if (this.LA(1) == 96) {
                    this.match(96);
                } else if (this.LA(1) == 99) {
                    this.match(99);
                } else if (this.LA(1) == 95) {
                    this.match(95);
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                tmpComplexity = this.shiftExpression();
                if (this.inputState.guessing != 0) continue;
                complexity += tmpComplexity;
            }
        } else {
            boolean synPredMatched394 = false;
            if (this.LA(1) == 33 && (this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 44 || this.LA(2) == 55 || this.LA(2) == 111 || this.LA(2) == 120)) {
                int _m394 = this.mark();
                synPredMatched394 = true;
                ++this.inputState.guessing;
                try {
                    this.match(33);
                    this.typeSpec();
                    this.match(120);
                }
                catch (RecognitionException recognitionException) {
                    synPredMatched394 = false;
                }
                this.rewind(_m394);
                --this.inputState.guessing;
            }
            if (synPredMatched394) {
                this.match(33);
                this.typeSpec();
                this.match(120);
            } else if (this.LA(1) == 33 && (this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 44 || this.LA(2) == 55 || this.LA(2) == 111 || this.LA(2) == 120)) {
                this.match(33);
                this.typeSpec();
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return complexity;
    }

    public final int shiftExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.additiveExpression();
        while (this.LA(1) == 91 || this.LA(1) == 93 || this.LA(1) == 97) {
            if (this.LA(1) == 97) {
                this.match(97);
            } else if (this.LA(1) == 91) {
                this.match(91);
            } else if (this.LA(1) == 93) {
                this.match(93);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            tmpComplexity = this.additiveExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int additiveExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.multiplicativeExpression();
        while (this.LA(1) == 81 || this.LA(1) == 84) {
            if (this.LA(1) == 81) {
                this.match(81);
            } else if (this.LA(1) == 84) {
                this.match(84);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            tmpComplexity = this.multiplicativeExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int multiplicativeExpression() throws RecognitionException, TokenStreamException {
        int tmpComplexity = 0;
        int complexity = this.unaryExpression();
        while (this.LA(1) == 79 || this.LA(1) == 87 || this.LA(1) == 89) {
            if (this.LA(1) == 87) {
                this.match(87);
            } else if (this.LA(1) == 79) {
                this.match(79);
            } else if (this.LA(1) == 89) {
                this.match(89);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            tmpComplexity = this.unaryExpression();
            if (this.inputState.guessing != 0) continue;
            complexity += tmpComplexity;
        }
        return complexity;
    }

    public final int unaryExpression() throws RecognitionException, TokenStreamException {
        int complexity;
        if (this.LA(1) == 83) {
            this.match(83);
            complexity = this.unaryExpression();
        } else if (this.LA(1) == 86) {
            this.match(86);
            complexity = this.unaryExpression();
        } else if (this.LA(1) == 84) {
            this.match(84);
            complexity = this.unaryExpression();
        } else if (this.LA(1) == 81) {
            this.match(81);
            complexity = this.unaryExpression();
        } else if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 120) {
            complexity = this.unaryExpressionNotPlusMinus(null, null);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int unaryExpressionNotPlusMinus(CloverToken classCastStart, CloverToken classCastEnd) throws RecognitionException, TokenStreamException {
        int complexity = 0;
        if (this.LA(1) == 77) {
            this.match(77);
            return this.unaryExpression();
        }
        if (this.LA(1) == 76) {
            this.match(76);
            return this.unaryExpression();
        }
        if (this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65) {
            if (this.LA(1) != 120) throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        boolean synPredMatched411 = false;
        if (this.LA(1) == 65 && (this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 44 || this.LA(2) == 55)) {
            int _m411 = this.mark();
            synPredMatched411 = true;
            ++this.inputState.guessing;
            try {
                this.match(65);
                this.builtInTypeSpec();
                this.match(66);
                this.unaryExpression();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched411 = false;
            }
            this.rewind(_m411);
            --this.inputState.guessing;
        }
        if (synPredMatched411) {
            this.match(65);
            this.builtInTypeSpec();
            this.match(66);
            return this.unaryExpression();
        }
        boolean synPredMatched415 = false;
        if (this.LA(1) == 65 && (this.LA(2) == 111 || this.LA(2) == 120)) {
            int _m415 = this.mark();
            synPredMatched415 = true;
            ++this.inputState.guessing;
            try {
                this.match(65);
                this.classTypeSpec();
                while (this.LA(1) == 106) {
                    this.match(106);
                    this.classOrInterfaceType();
                }
                this.match(66);
                this.unaryExpressionNotPlusMinus(null, null);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched415 = false;
            }
            this.rewind(_m415);
            --this.inputState.guessing;
        }
        if (synPredMatched415) {
            if (this.inputState.guessing == 0) {
                classCastStart = this.lt(1);
            }
            this.match(65);
            this.classTypeSpec();
            while (this.LA(1) == 106) {
                this.match(106);
                this.classOrInterfaceType();
            }
            this.match(66);
            if (this.inputState.guessing != 0) return this.unaryExpressionNotPlusMinus(classCastStart, classCastEnd);
            classCastEnd = this.lt(0);
            return this.unaryExpressionNotPlusMinus(classCastStart, classCastEnd);
        }
        if (this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65) {
            if (this.LA(1) != 120) throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(2) == 4) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 5) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 6) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 7) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 8) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 9) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 12) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 14) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 17) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 22) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 28) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 33) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 34) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 36) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 38) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 44) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 47) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 48) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 50) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 55) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 60) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 61) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 62) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 63) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 64) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 65) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 66) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 67) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 68) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 70) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 71) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 72) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 73) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 74) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 75) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 76) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 77) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 78) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 79) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 80) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 81) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 82) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 83) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 84) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 85) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 86) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 87) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 88) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 89) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 90) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 91) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 92) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 93) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 94) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 95) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 96) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 97) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 98) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 99) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 100) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 101) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 102) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 103) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 104) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 105) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 106) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 107) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 108) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 109) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 111) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) == 120) return this.postfixExpression(classCastStart, classCastEnd);
        if (this.LA(2) != 133) throw new NoViableAltException(this.LT(1), this.getFilename());
        return this.postfixExpression(classCastStart, classCastEnd);
    }

    public final int postfixExpression(CloverToken classCastStart, CloverToken classCastEnd) throws RecognitionException, TokenStreamException {
        CloverToken startMethodReference = null;
        ContextSetAndComplexity cc = null;
        int tmpComplexity = 0;
        int complexity = 0;
        if (this.inputState.guessing == 0) {
            startMethodReference = this.lt(1);
        }
        cc = this.primaryExpressionPart();
        if (this.inputState.guessing == 0) {
            complexity += cc.getComplexity();
        }
        tmpComplexity = this.supplementaryExpressionPart(classCastStart, classCastEnd, startMethodReference);
        if (this.inputState.guessing == 0) {
            complexity += tmpComplexity;
        }
        boolean synPredMatched421 = false;
        if (!(this.LA(1) != 72 && this.LA(1) != 100 || this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 55 && this.LA(2) != 64 && this.LA(2) != 72 && this.LA(2) != 91 && this.LA(2) != 93 && this.LA(2) != 96 && this.LA(2) != 100 && this.LA(2) != 111 && this.LA(2) != 120)) {
            int _m421 = this.mark();
            synPredMatched421 = true;
            ++this.inputState.guessing;
            try {
                this.methodReferencePredicate();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched421 = false;
            }
            this.rewind(_m421);
            --this.inputState.guessing;
        }
        if (synPredMatched421) {
            this.methodReferencePart();
            if (this.inputState.guessing == 0) {
                Parameter[] la = new Parameter[]{};
                MethodSignature methodReferenceSignature = new MethodSignature(LambdaUtil.generateLambdaNameWithId(la, this.lambdaCounter++), null, null, la, null, new Modifiers());
                LambdaExpressionEntryEmitter expressionEntryEmitter = this.instrEnterLambdaMethodReference(methodReferenceSignature, startMethodReference, classCastStart, classCastEnd);
                this.instrExitMethodReference(expressionEntryEmitter, this.lt(0));
            }
        } else if ((this.LA(1) == 33 || this.LA(1) == 64 || this.LA(1) == 66 || this.LA(1) == 68 || this.LA(1) == 70 || this.LA(1) == 71 || this.LA(1) == 73 || this.LA(1) == 74 || this.LA(1) == 75 || this.LA(1) == 78 || this.LA(1) == 79 || this.LA(1) == 80 || this.LA(1) == 81 || this.LA(1) == 82 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 85 || this.LA(1) == 86 || this.LA(1) == 87 || this.LA(1) == 88 || this.LA(1) == 89 || this.LA(1) == 90 || this.LA(1) == 91 || this.LA(1) == 92 || this.LA(1) == 93 || this.LA(1) == 94 || this.LA(1) == 95 || this.LA(1) == 96 || this.LA(1) == 97 || this.LA(1) == 98 || this.LA(1) == 99 || this.LA(1) == 100 || this.LA(1) == 101 || this.LA(1) == 102 || this.LA(1) == 103 || this.LA(1) == 104 || this.LA(1) == 105 || this.LA(1) == 106 || this.LA(1) == 107 || this.LA(1) == 108 || this.LA(1) == 109) && _tokenSet_2.member(this.LA(2))) {
            this.supplementaryPostIncDecPart();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    public final int supplementaryExpressionPart(CloverToken classCastStart, CloverToken classCastEnd, CloverToken startMethodReference) throws RecognitionException, TokenStreamException {
        int argListComplexity = 0;
        int exprComplexity = 0;
        int newComplexity = 0;
        int complexity = 0;
        while (true) {
            if (this.LA(1) == 133) {
                this.match(133);
                if (this.LA(1) == 100 || this.LA(1) == 120) {
                    if (this.LA(1) == 100) {
                        this.typeArguments();
                    } else if (this.LA(1) != 120) {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(120);
                    if (this.inputState.guessing != 0) continue;
                    this.pushIdentifierToHeadStack(this.LT(0).getText());
                    continue;
                }
                if (this.LA(1) == 50) {
                    this.match(50);
                    continue;
                }
                if (this.LA(1) == 18) {
                    this.match(18);
                    continue;
                }
                if (this.LA(1) == 38) {
                    newComplexity = this.newExpression();
                    if (this.inputState.guessing != 0) continue;
                    complexity += newComplexity;
                    continue;
                }
                if (this.LA(1) == 47) {
                    this.match(47);
                    continue;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 67 && this.LA(2) == 68) {
                int _cnt451 = 0;
                while (true) {
                    if (this.LA(1) != 67) {
                        if (_cnt451 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(67);
                    this.match(68);
                    ++_cnt451;
                }
                if (this.LA(1) == 133) {
                    this.match(133);
                    this.match(18);
                    continue;
                }
                if (this.LA(1) == 72) {
                    this.match(72);
                    this.match(38);
                    if (this.inputState.guessing != 0) continue;
                    Parameter[] la = new Parameter[]{};
                    MethodSignature methodReferenceSignature = new MethodSignature(LambdaUtil.generateLambdaNameWithId(la, this.lambdaCounter++), null, null, la, null, new Modifiers());
                    LambdaExpressionEntryEmitter expressionEntryEmitter = this.instrEnterLambdaExpression(methodReferenceSignature, startMethodReference, startMethodReference, classCastStart, classCastEnd);
                    this.instrExitLambdaExpression(expressionEntryEmitter, this.lt(0));
                    continue;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.LA(1) == 67 && (this.LA(2) == 4 || this.LA(2) == 5 || this.LA(2) == 6 || this.LA(2) == 7 || this.LA(2) == 8 || this.LA(2) == 9 || this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 38 || this.LA(2) == 44 || this.LA(2) == 47 || this.LA(2) == 48 || this.LA(2) == 50 || this.LA(2) == 55 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 65 || this.LA(2) == 76 || this.LA(2) == 77 || this.LA(2) == 81 || this.LA(2) == 83 || this.LA(2) == 84 || this.LA(2) == 86 || this.LA(2) == 120)) {
                this.match(67);
                exprComplexity = this.expression();
                this.match(68);
                if (this.inputState.guessing != 0) continue;
                complexity += exprComplexity;
                continue;
            }
            if (this.LA(1) != 65) break;
            this.match(65);
            argListComplexity = this.argList();
            this.match(66);
            if (this.inputState.guessing != 0) continue;
            complexity += argListComplexity;
        }
        return complexity;
    }

    public final void methodReferencePredicate() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 100) {
            this.typeArguments();
        } else if (this.LA(1) != 72) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(72);
    }

    public final void methodReferencePart() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 100) {
            this.typeArguments();
        } else if (this.LA(1) != 72) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.match(72);
        if (this.LA(1) == 100) {
            this.typeArguments();
        } else if (this.LA(1) != 38 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 120) {
            this.match(120);
        } else if (this.LA(1) == 38) {
            this.match(38);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void supplementaryPostIncDecPart() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 83) {
            this.match(83);
        } else if (this.LA(1) == 86) {
            this.match(86);
        } else if (this.LA(1) != 33 && this.LA(1) != 64 && this.LA(1) != 66 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 && this.LA(1) != 81 && this.LA(1) != 82 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 87 && this.LA(1) != 88 && this.LA(1) != 89 && this.LA(1) != 90 && this.LA(1) != 91 && this.LA(1) != 92 && this.LA(1) != 93 && this.LA(1) != 94 && this.LA(1) != 95 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 106 && this.LA(1) != 107 && this.LA(1) != 108 && this.LA(1) != 109) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void constant() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 4) {
            this.match(4);
        } else if (this.LA(1) == 5) {
            this.match(5);
        } else if (this.LA(1) == 6) {
            this.match(6);
        } else if (this.LA(1) == 7) {
            this.match(7);
        } else if (this.LA(1) == 8) {
            this.match(8);
        } else if (this.LA(1) == 9) {
            this.match(9);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final int newExpression() throws RecognitionException, TokenStreamException {
        int argListComplexity = 0;
        int declComplexity = 0;
        int initComplexity = 0;
        int complexity = 0;
        this.match(38);
        if (this.LA(1) == 100) {
            this.typeParameters();
        } else if (this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 44 && this.LA(1) != 55 && this.LA(1) != 111 && this.LA(1) != 120) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.type();
        if (this.LA(1) == 65) {
            this.match(65);
            argListComplexity = this.argList();
            this.match(66);
            if (this.LA(1) == 69) {
                this.classBlock(null);
            } else if (this.LA(1) != 33 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 && this.LA(1) != 81 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 86 && this.LA(1) != 87 && this.LA(1) != 88 && this.LA(1) != 89 && this.LA(1) != 90 && this.LA(1) != 91 && this.LA(1) != 92 && this.LA(1) != 93 && this.LA(1) != 94 && this.LA(1) != 95 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 106 && this.LA(1) != 107 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 133) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                complexity = argListComplexity;
            }
        } else if (this.LA(1) == 67 || this.LA(1) == 111) {
            declComplexity = this.newArrayDeclarator();
            if (this.LA(1) == 69) {
                initComplexity = this.arrayInitializer();
            } else if (this.LA(1) != 33 && this.LA(1) != 64 && this.LA(1) != 65 && this.LA(1) != 66 && this.LA(1) != 67 && this.LA(1) != 68 && this.LA(1) != 70 && this.LA(1) != 71 && this.LA(1) != 72 && this.LA(1) != 73 && this.LA(1) != 74 && this.LA(1) != 75 && this.LA(1) != 78 && this.LA(1) != 79 && this.LA(1) != 80 && this.LA(1) != 81 && this.LA(1) != 82 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 85 && this.LA(1) != 86 && this.LA(1) != 87 && this.LA(1) != 88 && this.LA(1) != 89 && this.LA(1) != 90 && this.LA(1) != 91 && this.LA(1) != 92 && this.LA(1) != 93 && this.LA(1) != 94 && this.LA(1) != 95 && this.LA(1) != 96 && this.LA(1) != 97 && this.LA(1) != 98 && this.LA(1) != 99 && this.LA(1) != 100 && this.LA(1) != 101 && this.LA(1) != 102 && this.LA(1) != 103 && this.LA(1) != 104 && this.LA(1) != 105 && this.LA(1) != 106 && this.LA(1) != 107 && this.LA(1) != 108 && this.LA(1) != 109 && this.LA(1) != 133) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            if (this.inputState.guessing == 0) {
                complexity = declComplexity + initComplexity;
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    public final int lambdaCase(ContextSet context) throws RecognitionException, TokenStreamException {
        Token si1 = null;
        Token si2 = null;
        Token t = null;
        CaseExpressionEntryEmitter expressionEntryEmitter = null;
        CaseThrowExpressionEntryEmitter throwEntryEmitter = null;
        int exprComplexity = 0;
        int complexity = 1;
        if (this.LA(1) == 15) {
            si1 = this.LT(1);
            this.match(15);
            this.patternMatch();
            if (this.inputState.guessing == 0) {
            }
        } else if (this.LA(1) == 20) {
            si2 = this.LT(1);
            this.match(20);
            if (this.inputState.guessing == 0) {
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        t = this.LT(1);
        this.match(110);
        boolean synPredMatched442 = false;
        if (this.LA(1) == 51) {
            int _m442 = this.mark();
            synPredMatched442 = true;
            ++this.inputState.guessing;
            try {
                this.match(51);
                this.expression();
                this.match(109);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched442 = false;
            }
            this.rewind(_m442);
            --this.inputState.guessing;
        }
        if (synPredMatched442) {
            this.match(51);
            exprComplexity = this.expression();
            this.match(109);
            if (this.inputState.guessing == 0) {
                throwEntryEmitter = this.instrEnterCaseThrowExpression(this.ct(t), this.lt(0), context, exprComplexity);
                this.instrExitCaseThrowExpression(throwEntryEmitter, this.lt(0));
            }
        } else if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
            exprComplexity = this.expression();
            this.match(109);
            if (this.inputState.guessing == 0) {
                expressionEntryEmitter = this.instrEnterCaseExpression(this.ct(t), this.lt(0), context, exprComplexity);
                this.instrExitCaseExpression(expressionEntryEmitter, this.lt(0));
            }
        } else if (this.LA(1) == 69) {
            this.compoundStatement();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return complexity;
    }

    public final int newArrayDeclarator() throws RecognitionException, TokenStreamException {
        int complexity = 0;
        int _cnt474 = 0;
        while (true) {
            if (!(this.LA(1) != 67 && this.LA(1) != 111 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 28 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 65 && this.LA(2) != 68 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 86 && this.LA(2) != 120)) {
                while (this.LA(1) == 111) {
                    this.annotation();
                }
                this.match(67);
                if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 120) {
                    complexity = this.expression();
                } else if (this.LA(1) != 68) {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            } else {
                if (_cnt474 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(68);
            ++_cnt474;
        }
        return complexity;
    }

    public final void constantConditionalExpression() throws RecognitionException, TokenStreamException {
        this.constantLogicalOrExpression();
        if (this.LA(1) == 64) {
            this.match(64);
            this.constantConditionalExpression();
            this.match(71);
            this.constantConditionalExpression();
        } else if (this.LA(1) != 71 && this.LA(1) != 73 && this.LA(1) != 110) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void constantLogicalOrExpression() throws RecognitionException, TokenStreamException {
        this.constantLogicalAndExpression();
        while (this.LA(1) == 105) {
            this.match(105);
            this.constantLogicalAndExpression();
        }
    }

    public final void constantLogicalAndExpression() throws RecognitionException, TokenStreamException {
        this.constantInclusiveOrExpression();
        while (this.LA(1) == 108) {
            this.match(108);
            this.constantInclusiveOrExpression();
        }
    }

    public final void constantInclusiveOrExpression() throws RecognitionException, TokenStreamException {
        this.constantExclusiveOrExpression();
        while (this.LA(1) == 103) {
            this.match(103);
            this.constantExclusiveOrExpression();
        }
    }

    public final void constantExclusiveOrExpression() throws RecognitionException, TokenStreamException {
        this.constantAndExpression();
        while (this.LA(1) == 101) {
            this.match(101);
            this.constantAndExpression();
        }
    }

    public final void constantAndExpression() throws RecognitionException, TokenStreamException {
        this.constantEqualityExpression();
        while (this.LA(1) == 106) {
            this.match(106);
            this.constantEqualityExpression();
        }
    }

    public final void constantEqualityExpression() throws RecognitionException, TokenStreamException {
        this.constantRelationalExpression();
        while (this.LA(1) == 75 || this.LA(1) == 78) {
            if (this.LA(1) == 78) {
                this.match(78);
            } else if (this.LA(1) == 75) {
                this.match(75);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.constantRelationalExpression();
        }
    }

    public final void constantRelationalExpression() throws RecognitionException, TokenStreamException {
        this.constantShiftExpression();
        while (this.LA(1) == 95 || this.LA(1) == 96 || this.LA(1) == 99 || this.LA(1) == 100) {
            if (this.LA(1) == 100) {
                this.match(100);
            } else if (this.LA(1) == 96) {
                this.match(96);
            } else if (this.LA(1) == 99) {
                this.match(99);
            } else if (this.LA(1) == 95) {
                this.match(95);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.constantShiftExpression();
        }
    }

    public final void constantShiftExpression() throws RecognitionException, TokenStreamException {
        this.constantAdditiveExpression();
        while (this.LA(1) == 91 || this.LA(1) == 93 || this.LA(1) == 97) {
            if (this.LA(1) == 97) {
                this.match(97);
            } else if (this.LA(1) == 91) {
                this.match(91);
            } else if (this.LA(1) == 93) {
                this.match(93);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.constantAdditiveExpression();
        }
    }

    public final void constantAdditiveExpression() throws RecognitionException, TokenStreamException {
        this.constantMultiplicativeExpression();
        while (this.LA(1) == 81 || this.LA(1) == 84) {
            if (this.LA(1) == 81) {
                this.match(81);
            } else if (this.LA(1) == 84) {
                this.match(84);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.constantMultiplicativeExpression();
        }
    }

    public final void constantMultiplicativeExpression() throws RecognitionException, TokenStreamException {
        this.constantUnaryExpression();
        while (this.LA(1) == 79 || this.LA(1) == 87 || this.LA(1) == 89) {
            if (this.LA(1) == 87) {
                this.match(87);
            } else if (this.LA(1) == 79) {
                this.match(79);
            } else if (this.LA(1) == 89) {
                this.match(89);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.constantUnaryExpression();
        }
    }

    public final void constantUnaryExpression() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 84) {
            this.match(84);
            this.constantUnaryExpression();
        } else if (this.LA(1) == 81) {
            this.match(81);
            this.constantUnaryExpression();
        } else if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 20 || this.LA(1) == 47 || this.LA(1) == 50 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 65 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 120) {
            this.constantUnaryExpressionNotPlusMinus();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void constantUnaryExpressionNotPlusMinus() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 77) {
            this.match(77);
            this.constantUnaryExpression();
            return;
        }
        if (this.LA(1) == 76) {
            this.match(76);
            this.constantUnaryExpression();
            return;
        }
        if (this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 20 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 65 && this.LA(1) != 120) throw new NoViableAltException(this.LT(1), this.getFilename());
        boolean synPredMatched519 = false;
        if (this.LA(1) == 65) {
            int _m519 = this.mark();
            synPredMatched519 = true;
            ++this.inputState.guessing;
            try {
                this.match(65);
                if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 44 || this.LA(1) == 55) {
                    this.builtInTypeSpec();
                } else {
                    if (this.LA(1) != 120 || !this.isNextKeyword("String")) throw new NoViableAltException(this.LT(1), this.getFilename());
                    this.match(120);
                }
                this.match(66);
                this.constantUnaryExpression();
            }
            catch (RecognitionException recognitionException) {
                synPredMatched519 = false;
            }
            this.rewind(_m519);
            --this.inputState.guessing;
        }
        if (synPredMatched519) {
            this.match(65);
            if (this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 44 || this.LA(1) == 55) {
                this.builtInTypeSpec();
            } else {
                if (this.LA(1) != 120 || !this.isNextKeyword("String")) throw new NoViableAltException(this.LT(1), this.getFilename());
                this.match(120);
            }
            this.match(66);
            this.constantUnaryExpression();
            return;
        } else {
            if (this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 20 && this.LA(1) != 47 && this.LA(1) != 50 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 120) throw new NoViableAltException(this.LT(1), this.getFilename());
            this.constantPostfixExpression();
        }
    }

    public final void constantPostfixExpression() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 120) {
            this.match(120);
        } else if (this.LA(1) >= 4 && this.LA(1) <= 9) {
            this.constant();
        } else if (this.LA(1) == 60) {
            this.match(60);
        } else if (this.LA(1) == 61) {
            this.match(61);
        } else if (this.LA(1) == 50) {
            this.match(50);
        } else if (this.LA(1) == 62) {
            this.match(62);
        } else if (this.LA(1) == 47) {
            this.match(47);
        } else if (this.LA(1) == 20) {
            this.match(20);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 133) {
            this.match(133);
            if (this.LA(1) == 120) {
                this.match(120);
                continue;
            }
            if (this.LA(1) == 50) {
                this.match(50);
                continue;
            }
            if (this.LA(1) == 47) {
                this.match(47);
                continue;
            }
            if (this.LA(1) == 18) {
                this.match(18);
                continue;
            }
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    protected final void annMemberValuePair(AnnotationImpl anno, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        Token name = null;
        name = this.LT(1);
        this.match(120);
        this.match(74);
        this.annMemberValue2(anno, name.getText(), isSuppressWarnings, true);
    }

    protected final boolean annMemberValue2(AnnotationValueCollection anno, String key, boolean isSuppressWarnings, boolean makeArrayAndAdd) throws RecognitionException, TokenStreamException {
        Token t = null;
        AnnotationImpl innerAnno = null;
        boolean wasFallthroughLiteral = false;
        String expr = null;
        boolean synPredMatched537 = false;
        if (this.LA(1) == 6 && (this.LA(2) == 66 || this.LA(2) == 70 || this.LA(2) == 73 || this.LA(2) == 109)) {
            int _m537 = this.mark();
            synPredMatched537 = true;
            ++this.inputState.guessing;
            try {
                this.match(6);
            }
            catch (RecognitionException recognitionException) {
                synPredMatched537 = false;
            }
            this.rewind(_m537);
            --this.inputState.guessing;
        }
        if (synPredMatched537) {
            t = this.LT(1);
            this.match(6);
            if (this.inputState.guessing == 0) {
                wasFallthroughLiteral = "\"fallthrough\"".equalsIgnoreCase(t.getText());
                if (isSuppressWarnings && makeArrayAndAdd) {
                    if (wasFallthroughLiteral) {
                        this.existingFallthroughSuppression = true;
                    } else {
                        this.suppressWarningsInstr = new SimpleEmitter("{");
                        SimpleEmitter closeCurly = new SimpleEmitter("}");
                        SimpleEmitter comma = new SimpleEmitter(",");
                        SimpleEmitter fallthrough = new SimpleEmitter("\"fallthrough\"");
                        this.ct(t).addPreEmitter(this.suppressWarningsInstr);
                        this.ct(t).addPostEmitter(comma);
                        this.ct(t).addPostEmitter(fallthrough);
                        this.ct(t).addPostEmitter(closeCurly);
                        this.suppressWarningsInstr.addDependent(closeCurly);
                        this.suppressWarningsInstr.addDependent(comma);
                        this.suppressWarningsInstr.addDependent(fallthrough);
                    }
                }
                if (anno != null) {
                    anno.put(key, new StringifiedAnnotationValue(t.getText()));
                }
            }
        } else if (!(this.LA(1) != 4 && this.LA(1) != 5 && this.LA(1) != 6 && this.LA(1) != 7 && this.LA(1) != 8 && this.LA(1) != 9 && this.LA(1) != 12 && this.LA(1) != 14 && this.LA(1) != 17 && this.LA(1) != 22 && this.LA(1) != 28 && this.LA(1) != 34 && this.LA(1) != 36 && this.LA(1) != 38 && this.LA(1) != 44 && this.LA(1) != 47 && this.LA(1) != 48 && this.LA(1) != 50 && this.LA(1) != 55 && this.LA(1) != 60 && this.LA(1) != 61 && this.LA(1) != 62 && this.LA(1) != 63 && this.LA(1) != 65 && this.LA(1) != 76 && this.LA(1) != 77 && this.LA(1) != 81 && this.LA(1) != 83 && this.LA(1) != 84 && this.LA(1) != 86 && this.LA(1) != 120 || this.LA(2) != 4 && this.LA(2) != 5 && this.LA(2) != 6 && this.LA(2) != 7 && this.LA(2) != 8 && this.LA(2) != 9 && this.LA(2) != 12 && this.LA(2) != 14 && this.LA(2) != 17 && this.LA(2) != 22 && this.LA(2) != 26 && this.LA(2) != 28 && this.LA(2) != 33 && this.LA(2) != 34 && this.LA(2) != 36 && this.LA(2) != 38 && this.LA(2) != 44 && this.LA(2) != 47 && this.LA(2) != 48 && this.LA(2) != 50 && this.LA(2) != 55 && this.LA(2) != 60 && this.LA(2) != 61 && this.LA(2) != 62 && this.LA(2) != 63 && this.LA(2) != 64 && this.LA(2) != 65 && this.LA(2) != 66 && this.LA(2) != 67 && this.LA(2) != 70 && this.LA(2) != 72 && this.LA(2) != 73 && this.LA(2) != 75 && this.LA(2) != 76 && this.LA(2) != 77 && this.LA(2) != 78 && this.LA(2) != 79 && this.LA(2) != 81 && this.LA(2) != 83 && this.LA(2) != 84 && this.LA(2) != 86 && this.LA(2) != 87 && this.LA(2) != 89 && this.LA(2) != 91 && this.LA(2) != 93 && this.LA(2) != 95 && this.LA(2) != 96 && this.LA(2) != 97 && this.LA(2) != 99 && this.LA(2) != 100 && this.LA(2) != 101 && this.LA(2) != 103 && this.LA(2) != 105 && this.LA(2) != 106 && this.LA(2) != 108 && this.LA(2) != 109 && this.LA(2) != 110 && this.LA(2) != 111 && this.LA(2) != 120 && this.LA(2) != 133)) {
            expr = this.conditionalExpression2();
            if (this.inputState.guessing == 0 && anno != null) {
                anno.put(key, new StringifiedAnnotationValue(expr));
            }
        } else if (this.LA(1) == 111) {
            innerAnno = this.annotation();
            if (this.inputState.guessing == 0 && anno != null) {
                anno.put(key, innerAnno);
            }
        } else if (this.LA(1) == 69) {
            this.annMemberValueArrayInitializer(anno, key, isSuppressWarnings);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return wasFallthroughLiteral;
    }

    protected final String conditionalExpression2() throws RecognitionException, TokenStreamException {
        CloverToken start = this.lt(1);
        CloverToken end = null;
        String asString = null;
        this.conditionalExpression();
        if (this.inputState.guessing == 0) {
            end = this.lt(0);
            asString = TokenListUtil.getNormalisedSequence(start, end);
        }
        return asString;
    }

    protected final void annMemberValueArrayInitializer(AnnotationValueCollection anno, String key, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        ArrayAnnotationValue annoArray;
        boolean emitComma = false;
        boolean seenFallthrough = false;
        ArrayAnnotationValue arrayAnnotationValue = annoArray = anno == null ? null : new ArrayAnnotationValue();
        if (anno != null) {
            anno.put(key, annoArray);
        }
        this.match(69);
        if (this.LA(1) == 4 || this.LA(1) == 5 || this.LA(1) == 6 || this.LA(1) == 7 || this.LA(1) == 8 || this.LA(1) == 9 || this.LA(1) == 12 || this.LA(1) == 14 || this.LA(1) == 17 || this.LA(1) == 22 || this.LA(1) == 28 || this.LA(1) == 34 || this.LA(1) == 36 || this.LA(1) == 38 || this.LA(1) == 44 || this.LA(1) == 47 || this.LA(1) == 48 || this.LA(1) == 50 || this.LA(1) == 55 || this.LA(1) == 60 || this.LA(1) == 61 || this.LA(1) == 62 || this.LA(1) == 63 || this.LA(1) == 65 || this.LA(1) == 69 || this.LA(1) == 76 || this.LA(1) == 77 || this.LA(1) == 81 || this.LA(1) == 83 || this.LA(1) == 84 || this.LA(1) == 86 || this.LA(1) == 111 || this.LA(1) == 120) {
            seenFallthrough = this.annMemberValues(annoArray, isSuppressWarnings);
            if (this.inputState.guessing == 0) {
                emitComma = true;
            }
        } else if (this.LA(1) != 70 && this.LA(1) != 73) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.LA(1) == 73) {
            this.match(73);
            if (this.inputState.guessing == 0) {
                emitComma = false;
            }
        } else if (this.LA(1) != 70) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (this.inputState.guessing == 0) {
            CloverToken t = this.lt(0);
            if (isSuppressWarnings) {
                if (seenFallthrough) {
                    this.existingFallthroughSuppression = true;
                } else {
                    if (emitComma) {
                        this.suppressWarningsInstr = new SimpleEmitter(",");
                        this.ct(t).addPostEmitter(this.suppressWarningsInstr);
                    }
                    SimpleEmitter fallthrough = new SimpleEmitter("\"fallthrough\"");
                    this.ct(t).addPostEmitter(fallthrough);
                    if (this.suppressWarningsInstr == null) {
                        this.suppressWarningsInstr = fallthrough;
                    } else {
                        this.suppressWarningsInstr.addDependent(fallthrough);
                    }
                }
            }
        }
        this.match(70);
    }

    protected final boolean annMemberValues(ArrayAnnotationValue annoArray, boolean isSuppressWarnings) throws RecognitionException, TokenStreamException {
        boolean sawFallthrough = false;
        boolean tmp = this.annMemberValue2(annoArray, null, isSuppressWarnings, false);
        if (this.inputState.guessing == 0 && tmp) {
            sawFallthrough = true;
        }
        while (this.LA(1) == 73 && (this.LA(2) == 4 || this.LA(2) == 5 || this.LA(2) == 6 || this.LA(2) == 7 || this.LA(2) == 8 || this.LA(2) == 9 || this.LA(2) == 12 || this.LA(2) == 14 || this.LA(2) == 17 || this.LA(2) == 22 || this.LA(2) == 28 || this.LA(2) == 34 || this.LA(2) == 36 || this.LA(2) == 38 || this.LA(2) == 44 || this.LA(2) == 47 || this.LA(2) == 48 || this.LA(2) == 50 || this.LA(2) == 55 || this.LA(2) == 60 || this.LA(2) == 61 || this.LA(2) == 62 || this.LA(2) == 63 || this.LA(2) == 65 || this.LA(2) == 69 || this.LA(2) == 76 || this.LA(2) == 77 || this.LA(2) == 81 || this.LA(2) == 83 || this.LA(2) == 84 || this.LA(2) == 86 || this.LA(2) == 111 || this.LA(2) == 120)) {
            this.match(73);
            tmp = this.annMemberValue2(annoArray, null, isSuppressWarnings, false);
            if (this.inputState.guessing != 0 || !tmp) continue;
            sawFallthrough = true;
        }
        return sawFallthrough;
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[6];
        lArray[0] = -869194732511756302L;
        lArray[1] = 72268700270460927L;
        lArray[2] = 48L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] lArray = new long[6];
        lArray[0] = -869195284314325008L;
        lArray[1] = 0x100FFFFFFFFFFFFL;
        lArray[2] = 32L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] lArray = new long[6];
        lArray[0] = -869194734692794384L;
        lArray[1] = 72268700270460927L;
        lArray[2] = 32L;
        long[] data = lArray;
        return data;
    }
}

