/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.CloverNames;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.instr.java.JavaTypeContext;
import com.atlassian.clover.instr.java.RecorderInstrEmitter;
import com.atlassian.clover.instr.tests.naming.JUnitParameterizedTestExtractor;
import com.atlassian.clover.instr.tests.naming.SpockFeatureNameExtractor;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.Modifiers;
import java.util.List;
import java.util.Map;

public class ClassEntryNode
extends Emitter {
    private String className;
    private String pkgname;
    private String superclass;
    private boolean isTopLevel;
    private boolean isInterface;
    private boolean isEnum;
    private boolean isAnnotation;
    private Map<String, List<String>> tags;
    private Modifiers mods;
    private boolean outerDetectTests;
    private CloverToken recorderInsertPoint;
    private RecorderInstrEmitter recorderInstrEmitter;

    public ClassEntryNode(Map<String, List<String>> tags, Modifiers mods, String className, String pkgname, String superclass, ContextSet context, int line, int col, boolean isTopLevel, boolean isInterface, boolean isEnum, boolean isAnnotation) {
        super(context, line, col);
        this.tags = tags;
        this.mods = mods;
        this.className = className;
        this.pkgname = pkgname;
        this.superclass = superclass;
        this.isTopLevel = isTopLevel;
        this.isInterface = isInterface;
        this.isEnum = isEnum;
        this.isAnnotation = isAnnotation;
    }

    @Override
    public void init(InstrumentationState state) {
        this.outerDetectTests = state.isDetectTests();
        boolean testClass = state.getTestDetector() != null && state.getTestDetector().isTypeMatch(state, new JavaTypeContext(this.tags, this.mods, this.pkgname, this.className, this.superclass));
        state.setDetectTests(testClass);
        state.setSpockTestClass(testClass && SpockFeatureNameExtractor.isClassWithSpecAnnotations(this.mods));
        state.setParameterizedJUnitTestClass(testClass && JUnitParameterizedTestExtractor.isParameterizedClass(this.mods));
        FullClassInfo clazz = (FullClassInfo)state.getSession().enterClass(this.className, new FixedSourceRegion(this.getLine(), this.getColumn()), this.mods, this.isInterface, this.isEnum, this.isAnnotation);
        if (this.isTopLevel) {
            String recorderPrefix = CloverNames.recorderPrefixFor(state.getFileInfo().getDataIndex(), clazz.getDataIndex());
            if (state.getCfg().isClassInstrStrategy() || this.isEnum) {
                recorderPrefix = String.valueOf(recorderPrefix) + ".R";
            }
            state.setRecorderPrefix(recorderPrefix);
        }
    }

    public CloverToken getRecorderInsertPoint() {
        return this.recorderInsertPoint;
    }

    public void setRecorderInsertPoint(CloverToken recorderInsertPoint) {
        this.recorderInsertPoint = recorderInsertPoint;
    }

    public boolean isOuterDetectTests() {
        return this.outerDetectTests;
    }

    public void setRecorderInstrEmitter(RecorderInstrEmitter emitter) {
        this.recorderInstrEmitter = emitter;
    }

    public RecorderInstrEmitter getRecorderInstrEmitter() {
        return this.recorderInstrEmitter;
    }
}

