/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.cfg.instr;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.StatementContextDef;

public class MethodContextDef
extends StatementContextDef {
    private int maxComplexity = Integer.MAX_VALUE;
    private int maxStatements = Integer.MAX_VALUE;
    private int maxAggregatedComplexity = Integer.MAX_VALUE;
    private int maxAggregatedStatements = Integer.MAX_VALUE;

    public MethodContextDef() {
    }

    public MethodContextDef(String name, String regexp, int maxComplexity, int maxStatements, int maxAggregatedComplexity, int maxAggregatedStatements) {
        super(name, regexp);
        this.maxComplexity = maxComplexity;
        this.maxStatements = maxStatements;
        this.maxAggregatedComplexity = maxAggregatedComplexity;
        this.maxAggregatedStatements = maxAggregatedStatements;
    }

    public int getMaxComplexity() {
        return this.maxComplexity;
    }

    public void setMaxComplexity(int maxComplexity) {
        this.maxComplexity = maxComplexity;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public int getMaxAggregatedComplexity() {
        return this.maxAggregatedComplexity;
    }

    public void setMaxAggregatedComplexity(int maxAggregatedComplexity) {
        this.maxAggregatedComplexity = maxAggregatedComplexity;
    }

    public int getMaxAggregatedStatements() {
        return this.maxAggregatedStatements;
    }

    public void setMaxAggregatedStatements(int maxAggregatedStatements) {
        this.maxAggregatedStatements = maxAggregatedStatements;
    }

    @Override
    public void validate() throws CloverException {
        if (this.maxComplexity < 0) {
            throw new CloverException("maxComplexity must be greater than 0");
        }
        if (this.maxComplexity == 0) {
            throw new CloverException("maxComplexity must be greater than 0 because methods have a minimum complexity of 1");
        }
        if (this.maxStatements < 0) {
            throw new CloverException("maxStatements must be >= 0");
        }
        if (this.maxAggregatedComplexity < 0) {
            throw new CloverException("maxAggregatedComplexity must be >= 0");
        }
        if (this.maxAggregatedStatements < 0) {
            throw new CloverException("maxAggregatedStatements must be >= 0");
        }
        if (this.getRegexp() == null || this.getRegexp().trim().length() == 0) {
            this.setRegexp(".*");
        }
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodContextDef that = (MethodContextDef)o;
        if (this.maxComplexity != that.maxComplexity) {
            return false;
        }
        if (this.maxStatements != that.maxStatements) {
            return false;
        }
        if (this.maxAggregatedComplexity != that.maxAggregatedComplexity) {
            return false;
        }
        return this.maxAggregatedStatements == that.maxAggregatedStatements;
    }

    @Override
    public int hashCode() {
        int result = this.maxComplexity;
        result = 31 * result + this.maxStatements;
        result = 31 * result + this.maxAggregatedComplexity;
        result = 31 * result + this.maxAggregatedStatements;
        return result;
    }
}

