/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant;

import clover.org.apache.commons.lang3.ArrayUtils;
import clover.org.apache.commons.lang3.StringUtils;
import com.atlassian.clover.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;
import org.openclover.util.function.Function;
import org.openclover.util.function.Predicate;
import org.openclover.util.function.Predicates;
import org.openclover.util.function.Streams;

public class AntFileSetUtils {
    private static Logger LOG = Logger.getInstance();
    protected static final Predicate<String> isTrimmed = new Predicate<String>(){

        @Override
        public boolean test(@Nullable String s) {
            return s != null && s.trim().equals(s);
        }
    };
    protected static final Function<String, String> wrapInBrackets = new Function<String, String>(){

        @Override
        public String apply(@Nullable String s) {
            return "<" + s + ">";
        }
    };

    public static void checkForNonTrimmedPatterns(@NotNull FileSet fileSet, @NotNull Project project) {
        PatternSet mergedPatterns = fileSet.mergePatterns(project);
        AntFileSetUtils.checkForNonTrimmedPatterns(mergedPatterns.getIncludePatterns(project), mergedPatterns.getExcludePatterns(project), fileSet.getDir(project).getAbsolutePath());
    }

    public static void checkForNonTrimmedPatterns(@NotNull PatternSet patternSet, @NotNull Project project, @NotNull String sourceDirectory) {
        AntFileSetUtils.checkForNonTrimmedPatterns(patternSet.getIncludePatterns(project), patternSet.getExcludePatterns(project), sourceDirectory);
    }

    public static void checkForNonTrimmedPatterns(@Nullable String[] includePatterns, @Nullable String[] excludePatterns, @NotNull String sourceDirectory) {
        List<String> nonTrimmedPatterns = AntFileSetUtils.getNonTrimmedPatterns(includePatterns, excludePatterns);
        if (!nonTrimmedPatterns.isEmpty()) {
            LOG.warn(AntFileSetUtils.createNonTrimmedPatternsMessage(nonTrimmedPatterns, sourceDirectory));
        }
    }

    @NotNull
    protected static List<String> getNonTrimmedPatterns(@Nullable String[] includePatterns, @Nullable String[] excludePatterns) {
        String[] allPatterns = ArrayUtils.addAll(includePatterns, excludePatterns);
        if (allPatterns != null) {
            return Lists.newArrayList(Streams.filter(Lists.newArrayList(allPatterns), Predicates.negate(isTrimmed)));
        }
        return Collections.emptyList();
    }

    @NotNull
    protected static String createNonTrimmedPatternsMessage(@NotNull Collection<String> patterns, @NotNull String sourceDirectory) {
        return "Attention: found inclusion/exclusion patterns for '" + sourceDirectory + "' containing leading/trailing whitespaces:\n" + StringUtils.join(Streams.map(patterns, wrapInBrackets), "\n");
    }
}

