/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.CloverLicense;
import com.atlassian.clover.LicenseDecoderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;

public class CloverLicenseDecoder {
    private static final CloverLicense DEFAULT_LICENSE = new CloverLicense("OpenClover", "free and open-source", "", 0L, 0L);

    public static CloverLicense decode(InputStream licenseIn) throws LicenseDecoderException {
        return CloverLicenseDecoder.decode(CloverLicenseDecoder.readFrom(licenseIn));
    }

    public static CloverLicense decode(String licenseKey) throws LicenseDecoderException {
        return DEFAULT_LICENSE;
    }

    public static CloverLicense createEvalLicense(long installTimestamp) {
        return DEFAULT_LICENSE;
    }

    private static String readFrom(InputStream licenseIn) throws LicenseDecoderException {
        try {
            StringBuilder licenseCert = new StringBuilder();
            LineNumberReader lin = new LineNumberReader(new InputStreamReader(licenseIn, StandardCharsets.UTF_8));
            String line = lin.readLine();
            while (line != null) {
                licenseCert.append(line).append("\n");
                line = lin.readLine();
            }
            return licenseCert.toString();
        }
        catch (IOException e) {
            throw new LicenseDecoderException("Error reading license. " + e.getMessage(), e);
        }
    }
}

