/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.base.log;

import clover.org.jfree.base.log.DefaultLog;
import clover.org.jfree.base.log.LogConfiguration;
import clover.org.jfree.base.modules.AbstractModule;
import clover.org.jfree.base.modules.ModuleInitializeException;
import clover.org.jfree.base.modules.SubSystem;
import clover.org.jfree.util.Log;
import clover.org.jfree.util.PrintStreamLogTarget;

public class DefaultLogModule
extends AbstractModule {
    public DefaultLogModule() throws ModuleInitializeException {
        this.loadModuleInfo();
    }

    @Override
    public void initialize(SubSystem subSystem) throws ModuleInitializeException {
        if (LogConfiguration.isDisableLogging()) {
            return;
        }
        if (LogConfiguration.getLogTarget().equals(PrintStreamLogTarget.class.getName())) {
            DefaultLog.installDefaultLog();
            Log.getInstance().addTarget(new PrintStreamLogTarget());
            if ("true".equals(subSystem.getGlobalConfig().getConfigProperty("clover.org.jfree.base.LogAutoInit"))) {
                Log.getInstance().init();
            }
            Log.info("Default log target started ... previous log messages could have been ignored.");
        }
    }
}

