/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.pdf.BaseFont;
import clover.com.lowagie.text.pdf.PdfBoolean;
import clover.com.lowagie.text.pdf.PdfDictionary;
import clover.com.lowagie.text.pdf.PdfIndirectReference;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfStream;
import clover.com.lowagie.text.pdf.PdfString;
import clover.com.lowagie.text.pdf.PdfWriter;
import clover.com.lowagie.text.pdf.collection.PdfCollectionItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

public class PdfFileSpecification
extends PdfDictionary {
    protected PdfWriter writer;
    protected PdfIndirectReference ref;

    public PdfFileSpecification() {
        super(PdfName.FILESPEC);
    }

    public static PdfFileSpecification url(PdfWriter writer, String url) {
        PdfFileSpecification fs = new PdfFileSpecification();
        fs.writer = writer;
        fs.put(PdfName.FS, PdfName.URL);
        fs.put(PdfName.F, new PdfString(url));
        return fs;
    }

    public static PdfFileSpecification fileEmbedded(PdfWriter writer, String filePath, String fileDisplay, byte[] fileStore) throws IOException {
        return PdfFileSpecification.fileEmbedded(writer, filePath, fileDisplay, fileStore, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PdfFileSpecification fileEmbedded(PdfWriter writer, String filePath, String fileDisplay, byte[] fileStore, boolean compress) throws IOException {
        block15: {
            fs = new PdfFileSpecification();
            fs.writer = writer;
            fs.put(PdfName.F, new PdfString(fileDisplay));
            fs.setUnicodeFileName(fileDisplay, false);
            in = null;
            try {
                refFileLength = writer.getPdfIndirectReference();
                if (fileStore == null) {
                    file = new File(filePath);
                    if (file.canRead()) {
                        in = new FileInputStream(filePath);
                    } else if (filePath.startsWith("file:/") || filePath.startsWith("http://") || filePath.startsWith("https://") || filePath.startsWith("jar:")) {
                        in = new URL(filePath).openStream();
                    } else {
                        in = BaseFont.getResourceStream(filePath);
                        if (in == null) {
                            throw new IOException(String.valueOf(filePath) + " not found as file or resource.");
                        }
                    }
                    stream = new PdfStream(in, writer);
                } else {
                    stream = new PdfStream(fileStore);
                }
                stream.put(PdfName.TYPE, PdfName.EMBEDDEDFILE);
                if (compress) {
                    stream.flateCompress();
                }
                stream.put(PdfName.PARAMS, refFileLength);
                ref = writer.addToBody(stream).getIndirectReference();
                if (fileStore == null) {
                    stream.writeLength();
                }
                params = new PdfDictionary();
                params.put(PdfName.SIZE, new PdfNumber(stream.getRawLength()));
                writer.addToBody((PdfObject)params, refFileLength);
            }
            catch (Throwable var11_11) {
                var12_12 = null;
                if (in == null) throw var11_11;
                try {
                    in.close();
                    throw var11_11;
                }
                catch (Exception var13_14) {
                    // empty catch block
                }
                throw var11_11;
            }
            {
                var12_13 = null;
                if (in == null) break block15;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 304->312)] { 
lbl47:
            // 1 sources

            in.close();
            break block15;
lbl49:
            // 1 sources

            catch (Exception var13_15) {
                // empty catch block
            }
        }
        f = new PdfDictionary();
        f.put(PdfName.F, ref);
        f.put(PdfName.UF, ref);
        fs.put(PdfName.EF, f);
        return fs;
    }

    public static PdfFileSpecification fileExtern(PdfWriter writer, String filePath) {
        PdfFileSpecification fs = new PdfFileSpecification();
        fs.writer = writer;
        fs.put(PdfName.F, new PdfString(filePath));
        fs.setUnicodeFileName(filePath, false);
        return fs;
    }

    public PdfIndirectReference getReference() throws IOException {
        if (this.ref != null) {
            return this.ref;
        }
        this.ref = this.writer.addToBody(this).getIndirectReference();
        return this.ref;
    }

    public void setMultiByteFileName(byte[] fileName) {
        this.put(PdfName.F, new PdfString(fileName).setHexWriting(true));
    }

    public void setUnicodeFileName(String filename, boolean unicode) {
        this.put(PdfName.UF, new PdfString(filename, unicode ? "UnicodeBig" : "PDF"));
    }

    public void setVolatile(boolean volatile_file) {
        this.put(PdfName.V, new PdfBoolean(volatile_file));
    }

    public void addDescription(String description, boolean unicode) {
        this.put(PdfName.DESC, new PdfString(description, unicode ? "UnicodeBig" : "PDF"));
    }

    public void addCollectionItem(PdfCollectionItem ci) {
        this.put(PdfName.CI, ci);
    }
}

