/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.evaluator.engine.util;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.elm.execution.Library;

public class TranslatorOptionsUtil {
    public static EnumSet<CqlTranslator.Options> getTranslatorOptions(Library library) {
        Objects.requireNonNull(library, "library can not be null");
        if (library.getAnnotation() == null || library.getAnnotation().isEmpty()) {
            return null;
        }
        String translatorOptions = TranslatorOptionsUtil.getTranslatorOptions(library.getAnnotation());
        return TranslatorOptionsUtil.parseTranslatorOptions(translatorOptions);
    }

    private static String getTranslatorOptions(List<Object> annotations) {
        for (Object o : annotations) {
            if (!(o instanceof LinkedHashMap)) continue;
            try {
                LinkedHashMap lhm = (LinkedHashMap)o;
                String options = (String)lhm.get("translatorOptions");
                if (options == null) continue;
                return options;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static EnumSet<CqlTranslator.Options> parseTranslatorOptions(String translatorOptions) {
        String[] options;
        if (translatorOptions == null) {
            return null;
        }
        EnumSet<CqlTranslator.Options> optionSet = EnumSet.noneOf(CqlTranslator.Options.class);
        for (String option : options = translatorOptions.trim().split(",")) {
            optionSet.add(CqlTranslator.Options.valueOf((String)option));
        }
        return optionSet;
    }
}

