/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.opencds.cqf.cql.engine.elm.execution.MaxValueEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MinValueEvaluator;

public class Value {
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    public static final BigDecimal MAX_DECIMAL = new BigDecimal("9999999999999999999999999999.99999999");
    public static final Integer MIN_INT = Integer.MIN_VALUE;
    public static final BigDecimal MIN_DECIMAL = new BigDecimal("-9999999999999999999999999999.99999999");

    private Value() {
    }

    public static BigDecimal verifyPrecision(BigDecimal value, Integer targetScale) {
        if (value.scale() > 8) {
            value = value.setScale(8, RoundingMode.FLOOR);
        }
        if (value.scale() < 0) {
            value = value.setScale(0, RoundingMode.FLOOR);
        }
        if (targetScale != null && value.scale() > targetScale) {
            value = value.stripTrailingZeros();
        }
        return value;
    }

    public static BigDecimal validateDecimal(BigDecimal ret, Integer targetScale) {
        if (ret.compareTo((BigDecimal)MaxValueEvaluator.maxValue("Decimal")) > 0) {
            return null;
        }
        if (ret.compareTo((BigDecimal)MinValueEvaluator.minValue("Decimal")) < 0) {
            return null;
        }
        return Value.verifyPrecision(ret, targetScale);
    }

    public static Integer validateInteger(Integer ret) {
        if (ret > MAX_INT || ret < MIN_INT) {
            return null;
        }
        return ret;
    }

    public static Integer validateInteger(Double ret) {
        if (ret > (double)MAX_INT.intValue() || ret < (double)MIN_INT.intValue()) {
            return null;
        }
        return ret.intValue();
    }
}

