/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.time.ZoneOffset;
import org.opencds.cqf.cql.engine.runtime.CqlType;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Time;

public abstract class BaseTemporal
implements CqlType,
Comparable<BaseTemporal> {
    Precision precision;
    ZoneOffset evaluationOffset;

    public Precision getPrecision() {
        return this.precision;
    }

    public BaseTemporal setPrecision(Precision precision) {
        this.precision = precision;
        return this;
    }

    public ZoneOffset getEvaluationOffset() {
        return this.evaluationOffset;
    }

    public void setEvaluationOffset(ZoneOffset evaluationOffset) {
        this.evaluationOffset = evaluationOffset;
    }

    public static String getHighestPrecision(BaseTemporal ... values) {
        int max = -1;
        boolean isDateTime = true;
        boolean isDate = false;
        for (BaseTemporal baseTemporal : values) {
            if (baseTemporal instanceof DateTime) {
                if (baseTemporal.precision.toDateTimeIndex() <= max) continue;
                max = ((DateTime)baseTemporal).precision.toDateTimeIndex();
                continue;
            }
            if (baseTemporal instanceof Date) {
                isDateTime = false;
                isDate = true;
                if (baseTemporal.precision.toTimeIndex() <= max) continue;
                max = ((Date)baseTemporal).precision.toDateIndex();
                continue;
            }
            if (!(baseTemporal instanceof Time)) continue;
            isDateTime = false;
            if (baseTemporal.precision.toTimeIndex() <= max) continue;
            max = ((Time)baseTemporal).precision.toTimeIndex();
        }
        if (max == -1) {
            return Precision.MILLISECOND.toString();
        }
        return isDateTime ? Precision.fromDateTimeIndex(max).toString() : (isDate ? Precision.fromDateIndex(max).toString() : Precision.fromTimeIndex(max).toString());
    }

    public static String getLowestPrecision(BaseTemporal ... values) {
        int min = 99;
        boolean isDateTime = true;
        boolean isDate = false;
        for (BaseTemporal baseTemporal : values) {
            if (baseTemporal instanceof DateTime) {
                if (baseTemporal.precision.toDateTimeIndex() >= min) continue;
                min = ((DateTime)baseTemporal).precision.toDateTimeIndex();
                continue;
            }
            if (baseTemporal instanceof Date) {
                isDateTime = false;
                isDate = true;
                if (baseTemporal.precision.toTimeIndex() >= min) continue;
                min = ((Date)baseTemporal).precision.toDateIndex();
                continue;
            }
            if (!(baseTemporal instanceof Time)) continue;
            isDateTime = false;
            if (baseTemporal.precision.toTimeIndex() >= min) continue;
            min = ((Time)baseTemporal).precision.toTimeIndex();
        }
        if (min == 99) {
            return Precision.YEAR.toString();
        }
        return isDateTime ? Precision.fromDateTimeIndex(min).toString() : (isDate ? Precision.fromDateIndex(min).toString() : Precision.fromTimeIndex(min).toString());
    }

    public abstract Integer compare(BaseTemporal var1, boolean var2);

    public abstract Integer compareToPrecision(BaseTemporal var1, Precision var2);

    public abstract boolean isUncertain(Precision var1);

    public abstract Interval getUncertaintyInterval(Precision var1);
}

