/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.cqframework.cql.elm.execution.Truncate;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class TruncateEvaluator
extends Truncate {
    public static Object truncate(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof BigDecimal) {
            Double val = ((BigDecimal)operand).doubleValue();
            if (val < 0.0) {
                return ((BigDecimal)operand).setScale(0, RoundingMode.CEILING).intValue();
            }
            return ((BigDecimal)operand).setScale(0, RoundingMode.FLOOR).intValue();
        }
        throw new InvalidOperatorArgument("Truncate(Decimal)", String.format("Truncate(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return TruncateEvaluator.truncate(operand);
    }
}

