/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.time.format.DateTimeParseException;
import org.cqframework.cql.elm.execution.ToDateTime;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;

public class ToDateTimeEvaluator
extends ToDateTime {
    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        if (operand == null) {
            return null;
        }
        if (operand instanceof String) {
            try {
                return new DateTime((String)operand, null);
            }
            catch (DateTimeParseException dtpe) {
                return null;
            }
        }
        if (operand instanceof Date) {
            return new DateTime(null, ((Date)operand).getDate().getYear(), ((Date)operand).getDate().getMonthValue(), ((Date)operand).getDate().getDayOfMonth(), 0, 0, 0, 0);
        }
        throw new InvalidOperatorArgument("ToDateTime(String) or ToDateTime(Date)", String.format("ToDateTime(%s)", operand.getClass().getName()));
    }
}

