/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.Sum;
import org.opencds.cqf.cql.engine.elm.execution.AddEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class SumEvaluator
extends Sum {
    public static Object sum(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            Iterable elements = (Iterable)source;
            Object sum = null;
            for (Object element : elements) {
                if (element == null) continue;
                if (sum == null) {
                    sum = element;
                    continue;
                }
                sum = AddEvaluator.add(sum, element);
            }
            return sum;
        }
        throw new InvalidOperatorArgument("Sum(List<Integer>), Sum(List<Decimal>) or Sum(List<Quantity>)", String.format("Sum(%s)", source.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object source = this.getSource().evaluate(context);
        return SumEvaluator.sum(source);
    }
}

